/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.validator;

import com.pingidentity.admin.api.validator.LdapDataStoreValidator;
import com.pingidentity.common.util.ldap.LDAPErrorException;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.PingLdapSSLSocketFactory;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.datasource.info.LdapTypeNotFoundException;

public class LdapConfigValidator {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String LDAP_PREFIX = "ldap://";
    private static final String LDAPS_PREFIX = "ldaps://";

    public List<ValidationError> validate(LdapDataSource dataSource, boolean checkForDuplicates) {
        return this.validate(dataSource, checkForDuplicates, true, false);
    }

    public List<ValidationError> validate(LdapDataSource dataSource, boolean checkForDuplicates, boolean useSecretManager) {
        return this.validate(dataSource, checkForDuplicates, true, useSecretManager);
    }

    public List<ValidationError> validate(LdapDataSource dataSource, boolean checkForDuplicates, boolean validateDefaultHostname, boolean useSecretManager) {
        LdapDataStoreValidator validator = new LdapDataStoreValidator.Builder().setId(dataSource.getId()).setHostnames(dataSource.getHost()).setAuthenticationMethod(dataSource.getAuthenticationMethod()).setBindAnonymously(dataSource.getAnonymousBinding()).setClientTlsCertificate(dataSource.getClientTlsCertificate()).setUserDN(dataSource.getPrincipal()).setUserCredentials(dataSource.getCredentials()).setUseSecretManager(useSecretManager).setUseSsl(dataSource.getUseSSL()).setUseDnsSrvRecord(dataSource.isUseDnsSrvRecords()).setUseStartTLS(dataSource.getUseStartTLS()).setName(dataSource.getDsName()).setValidateHostname(validateDefaultHostname).setCreate(checkForDuplicates).build();
        validator.validate();
        return validator.getErrors();
    }

    public void testConnection(LdapDataSource ldap) throws NamingException, SecretManagerException {
        this.testConnection(ldap, null);
    }

    public void testConnection(LdapDataSource ldap, SSLSocketFactory sslSocketFactory) throws NamingException, SecretManagerException {
        ldap.setHost(LdapConfigValidator.stripProtocol(ldap.getHost()));
        ldap.testConnection(sslSocketFactory);
    }

    public boolean testConnectionRecordErrors(LdapDataSource ldap, IValidationDelegate delegate) {
        return this.testConnectionRecordErrors(ldap, null, delegate);
    }

    public boolean testConnectionRecordErrors(LdapDataSource ldap, SSLSocketFactory sslSocketFactory, IValidationDelegate delegate) {
        boolean isSuccessful = false;
        try {
            this.testConnection(ldap, sslSocketFactory);
            isSuccessful = true;
        }
        catch (LDAPErrorException.InvalidCredentials e) {
            delegate.setFormComponent(null);
            delegate.record("Failed to establish a connection to the specified data store because the credentials provided are invalid.", ValidationConstraint.REQUIRED);
        }
        catch (SecretManagerException e) {
            delegate.setFormComponent(null);
            delegate.record("Failed to retrieve credentials from secret manager.", ValidationConstraint.REQUIRED);
        }
        catch (Exception e) {
            delegate.setFormComponent(null);
            delegate.record("Unable to communicate with the specified data store.", ValidationConstraint.REQUIRED);
        }
        this.log.info((Object)("LDAP test of " + ldap.getHost() + (isSuccessful ? " succeeded." : " failed.")));
        return isSuccessful;
    }

    protected static String stripProtocol(String hosts) {
        StringBuilder noProtocolHosts = new StringBuilder(hosts.length());
        for (String host : LDAPUtil.splitServerUrls((String)hosts)) {
            if (host.startsWith(LDAP_PREFIX)) {
                host = host.substring(LDAP_PREFIX.length());
            } else if (host.startsWith(LDAPS_PREFIX)) {
                host = host.substring(LDAPS_PREFIX.length());
            }
            noProtocolHosts.append(host).append(' ');
        }
        return noProtocolHosts.toString().trim();
    }

    private String processLdapType(String type) {
        try {
            LdapInfo.LdapType.canonicalName((String)type);
        }
        catch (LdapTypeNotFoundException e) {
            return LdapInfo.LdapType.Undefined.toString();
        }
        return type;
    }

    public SSLSocketFactory getSslSocketFactory(TrustManager trustManager) {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{trustManager}, SecurityProviderUtil.getSecureRandom());
            return context.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            this.log.error((Object)("Unable to create an SSL Socket factory due to: " + e.getMessage()));
            return PingLdapSSLSocketFactory.getDefault();
        }
    }
}

