/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.adapters.pingone.mfa.PingOneMfaIdpAdapterLogEvent;
import com.pingidentity.adapters.pingone.mfa.api.client.PingOneClientsFactory;
import com.pingidentity.adapters.pingone.mfa.api.client.flows.FlowsApiClient;
import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.model.flows.Status;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDeviceInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDevicesInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.response.CreateUsernamelessAuthenticationResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorDetail;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.FlowResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.PublicKeyCredentialRequestOptions;
import com.pingidentity.adapters.pingone.mfa.authn.api.PingOneMfaAuthnApiSupport;
import com.pingidentity.adapters.pingone.mfa.authn.api.StateSpec;
import com.pingidentity.adapters.pingone.mfa.config.CoreContract;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.exception.ApiResponseException;
import com.pingidentity.adapters.pingone.mfa.exception.InvalidActionException;
import com.pingidentity.adapters.pingone.mfa.exception.RateLimitApiResponseException;
import com.pingidentity.adapters.pingone.mfa.pingidsdk.DynamicDataUtils;
import com.pingidentity.adapters.pingone.mfa.pingidsdk.PingIDSdkAdapterInfo;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.common.cache.Cache;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.common.cache.CacheBuilder;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.Log;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.LogFactory;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.conn.ConnectTimeoutException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.conn.HttpHostConnectException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.lang.JoseException;
import com.pingidentity.adapters.pingone.mfa.template.PingOneMfaTemplateSupport;
import com.pingidentity.adapters.pingone.mfa.template.TemplateParameter;
import com.pingidentity.adapters.pingone.mfa.util.AccountRecoveryFlowUtil;
import com.pingidentity.adapters.pingone.mfa.util.AppSecretCache;
import com.pingidentity.adapters.pingone.mfa.util.DefaultAppSecretProvider;
import com.pingidentity.adapters.pingone.mfa.util.InParamsUtil;
import com.pingidentity.adapters.pingone.mfa.util.ModelMapperUtil;
import com.pingidentity.adapters.pingone.mfa.util.ObjectMappers;
import com.pingidentity.adapters.pingone.mfa.util.PingOneMfaHandler;
import com.pingidentity.adapters.pingone.mfa.util.PingOneMfaStateSupport;
import com.pingidentity.adapters.pingone.mfa.util.PingOneMfaStateSupportFactory;
import com.pingidentity.adapters.pingone.mfa.util.StatusMapping;
import com.pingidentity.adapters.pingone.mfa.util.TrackerCookieData;
import com.pingidentity.adapters.pingone.mfa.util.TrackerCookieInfo;
import com.pingidentity.adapters.pingone.mfa.util.TrackerCookieObfuscator;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.exception.AuthnErrorException;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.ResourceRef;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;

public class PingOneMfaIdpAdapter
implements IdpAuthenticationAdapterV2,
AuthnApiPlugin {
    private static final IntegrationsLogger LOG = new IntegrationsLogger(PingOneMfaIdpAdapter.class);
    private static boolean supportsSetMetadata;
    private static boolean supportsPluginServiceAssociation;
    private static final Cache<String, Object> CACHE;
    private String envId;
    private String applicationId;
    private String applicationIdForQRFlow;
    private String authenticationPolicy;
    private String registrationPolicy;
    private String notificationTemplateOverride;
    private String authEndpoint;
    private boolean showSuccessScreen;
    private boolean showErrorScreen;
    private boolean showTimeoutScreen;
    private boolean auditLoggingEnabled;
    private boolean changeDeviceAllowed;
    private boolean apiFailureBypass;
    private boolean invalidUserBypass;
    private String htmlTemplate;
    private String messageProperties;
    private boolean allowSetupMfa;
    private boolean allowSkipMfa;
    private boolean allowAddOrRemoveMethod;
    private boolean provisionUser;
    private boolean provisionAuthenticationMethods;
    private boolean updateAuthenticationMethods;
    private String overwriteAuthenticationMethodsConfig;
    private boolean isCookieTrackingEnabled;
    private String usePasswordPolicyActionAttribute;
    private String bypassDeviceMFABeforeDeviceMgmtAttribute;
    private String populationId;
    private String smsAttribute;
    private String voiceAttribute;
    private String emailAttribute;
    private String whatsAppAttribute;
    private String usernameAttribute;
    private String defaultDeviceType;
    private boolean allowOnlyPredefineValuesForPhoneOrEmailDevices;
    private final AuthnApiSupport authnApiSupport = AuthnApiSupport.getDefault();
    private final PingOneMfaStateSupportFactory stateSupportFactory;
    private PingOneMfaTemplateSupport pingOneMfaTemplateSupport;
    private PingOneMfaAuthnApiSupport pingOneMfaAuthnApiSupport;
    private FlowsApiClient flowsApiClient;
    private WorkerApiClient workerApiClient;
    private PingOneMfaHandler handler;
    private Log log = LogFactory.getLog(PingOneMfaIdpAdapter.class);

    public PingOneMfaIdpAdapter() {
        this.stateSupportFactory = PingOneMfaStateSupport::new;
    }

    public PingOneMfaIdpAdapter(Configuration configuration, PingOneMfaStateSupportFactory stateSupportFactory, PingOneMfaTemplateSupport pingOneMfaTemplateSupport, PingOneMfaAuthnApiSupport pingOneMfaAuthnApiSupport, FlowsApiClient flowsApiClient, WorkerApiClient workerApiClient, PingOneMfaHandler handler) {
        this.configureInternalState(configuration);
        this.stateSupportFactory = stateSupportFactory;
        this.pingOneMfaTemplateSupport = pingOneMfaTemplateSupport;
        this.pingOneMfaAuthnApiSupport = pingOneMfaAuthnApiSupport;
        this.flowsApiClient = flowsApiClient;
        this.workerApiClient = workerApiClient;
        this.handler = handler;
    }

    private boolean isTrackerCookieFound(HttpServletRequest req) {
        String trackerCookieData = this.handler.getTrackerCookieData(req);
        return StringUtils.isNotBlank(trackerCookieData);
    }

    private String getTrackerCookieUsername(HttpServletRequest req) {
        String trackerCookieData = this.handler.getTrackerCookieData(req);
        try {
            String urlDecodedCookieData = URLDecoder.decode(trackerCookieData, "UTF-8");
            String trackerCookieDecodedData = new TrackerCookieObfuscator(false).getDeObfuscatedCookieData(this.envId, urlDecodedCookieData);
            if (StringUtils.isNotBlank(trackerCookieDecodedData)) {
                ObjectMapper objectMapper = ObjectMappers.getDefault();
                try {
                    TrackerCookieData cookieDataObj = objectMapper.readValue(trackerCookieDecodedData, TrackerCookieData.class);
                    return cookieDataObj.getUserId();
                }
                catch (JsonProcessingException jsonProcessingException) {}
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public AuthnAdapterResponse doUsernamelessAuthenticationCodeFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, JoseException, AccessTokenProviderException, AuthnErrorException, InvalidActionException {
        String status = stateSupport.getPreviousPfStatus();
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        if (this.isCancelBiometricAuthenticationRequest(req, status)) {
            authnAdapterResponse = this.handleCancelAuthnRequest(req, resp, inParameters, false);
        } else if (this.isContinueBiometricAuthenticationRequest(req, status)) {
            authnAdapterResponse = this.handler.handleUsernamelessAuthenticationCreateAuthenticationRequest(req, resp, inParameters, stateSupport, this.authenticationPolicy);
        } else {
            if (this.isBiometricAuthenticationRequestStatusCheck(req, status)) {
                this.pingOneMfaAuthnApiSupport.writeBiometricAuthenticationInfoRequiredResponse(req, resp);
                stateSupport.setPreviousPfStatus(StateSpec.BIOMETRIC_DEVICE_AUTHENTICATION_INFO_REQUIRED.getStatus());
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return authnAdapterResponse;
            }
            if (StringUtils.isBlank(status)) {
                authnAdapterResponse = this.handler.handleUsernamelessAuthenticationCreateAuthenticationRequest(req, resp, inParameters, stateSupport, this.authenticationPolicy);
            } else if (this.isCheckAssertionRequest(req, status)) {
                authnAdapterResponse = this.handler.handleUsernameLessAuthenticationCheckAssertionRequest(req, resp, inParameters, stateSupport);
            } else if (this.isUsernamelessFlowCancelAuthnRequest(req, status)) {
                authnAdapterResponse = this.handleCancelAuthnRequest(req, resp, inParameters, false);
                stateSupport.removePreviousPfStatus();
            } else {
                if (StateSpec.ASSERTION_REQUIRED.getStatus().equals(status)) {
                    CreateUsernamelessAuthenticationResponse createUsernamelessAuthenticationResponse = stateSupport.getUsernamelessAuthenticationRequestResponse();
                    String publicKeyCredentialRequestStr = createUsernamelessAuthenticationResponse.getPublicKeyCredentialRequestOptions();
                    stateSupport.setPreviousPfStatus(StateSpec.ASSERTION_REQUIRED.getStatus());
                    stateSupport.setDeviceAuthenticationRequestId(createUsernamelessAuthenticationResponse.getId());
                    PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions = ObjectMappers.getDefault().readValue(publicKeyCredentialRequestStr, PublicKeyCredentialRequestOptions.class);
                    this.pingOneMfaAuthnApiSupport.writeUsernamelessFlowAssertionRequiredResponse(req, resp, publicKeyCredentialRequestOptions);
                    authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                    return authnAdapterResponse;
                }
                LOG.log(PingOneMfaIdpAdapterLogEvent.UNEXPECTED_STATE_IN_USERNAMELESS_FLOW);
                authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                return authnAdapterResponse;
            }
        }
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse doAuthenticationCodeFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, JoseException, AccessTokenProviderException, AuthnErrorException, InvalidActionException {
        String status = stateSupport.getPreviousPfStatus();
        AuthnAdapterResponse authnAdapterResponse = this.isCancelAuthnRequest(req, status) ? this.handleCancelAuthnRequest(req, resp, inParameters, false) : (StringUtils.isBlank(status) ? this.handler.handleCreateAuthenticationCodesRequest(req, resp, inParameters, stateSupport) : (CommonStateSpec.MFA_COMPLETED.getStatus().equals(status) ? this.handler.handleAuthenticationCodeCompleted(stateSupport) : (CommonStateSpec.MFA_FAILED.getStatus().equals(status) ? this.handler.handleAuthenticationCodeFailed(req, resp, inParameters, stateSupport) : (this.isPollRequest(req, status) ? this.handler.handleAuthenticationCodeStatusPollRequest(req, resp, inParameters, stateSupport) : this.handler.handleAuthenticationCodeStatusRequest(req, resp, inParameters, stateSupport)))));
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse initiateOneTimeDeviceOTPAuthenticationFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, OneTimeDevicesInfo oneTimeDevicesInfo, PingOneMfaStateSupport stateSupport) throws IOException, JoseException, AccessTokenProviderException, AuthnErrorException, InvalidActionException {
        stateSupport.setOneTimeDeviceOtpDevices(oneTimeDevicesInfo);
        AuthnAdapterResponse authnAdapterResponse = oneTimeDevicesInfo.isDeviceSelectionRequired() ? this.handler.handleOneTimeDeviceOTPMethodTypeInputRequiredRequest(req, resp, inParameters, oneTimeDevicesInfo, stateSupport, null) : this.handler.handleCreateOneTimeDeviceAuthenticationRequest(req, resp, inParameters, oneTimeDevicesInfo.getDevices().get(0), stateSupport);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleOneTimeDeviceOTPAuthenticationFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, JoseException, AccessTokenProviderException, AuthnErrorException, InvalidActionException {
        String status = stateSupport.getPreviousPfStatus();
        AuthnAdapterResponse authnAdapterResponse = null;
        if (this.isCancelAuthnRequest(req, status)) {
            authnAdapterResponse = this.handleCancelAuthnRequest(req, resp, inParameters, false);
        } else if (StateSpec.ONE_TIME_DEVICE_OTP_METHOD_TYPE_INPUT_REQUIRED_RESPONSE.getStatus().equals(status) && this.isSelectOneTimeDeviceMethod(req, status) || StateSpec.ONE_TIME_DEVICE_OTP_INPUT_REQUIRED_RESPONSE.getStatus().equals(status) && this.isSelectOneTimeDeviceMethod(req, status)) {
            String deviceId;
            ResourceRef selectedDeviceRef = this.handler.getSelectedDeviceRef(req);
            boolean validDeviceId = false;
            Optional<OneTimeDeviceInfo> optionalOneTimeDeviceInfo = null;
            String receivedDeviceId = null;
            if (selectedDeviceRef != null && (deviceId = selectedDeviceRef.getId()) != null) {
                receivedDeviceId = deviceId;
                optionalOneTimeDeviceInfo = stateSupport.getOneTimeDeviceOtpDevices().getDevices().stream().filter(it -> deviceId.equals(it.getId())).findFirst();
                if (optionalOneTimeDeviceInfo.isPresent()) {
                    validDeviceId = true;
                }
            }
            if (validDeviceId) {
                OneTimeDeviceInfo oneTimeDeviceInfo = (OneTimeDeviceInfo)optionalOneTimeDeviceInfo.get();
                authnAdapterResponse = this.handler.handleCreateOneTimeDeviceAuthenticationRequest(req, resp, inParameters, oneTimeDeviceInfo, stateSupport);
            } else {
                this.log.error("Received invalid device id: " + receivedDeviceId);
                if (this.authnApiSupport.isApiRequest(req)) {
                    AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
                    authnError.setDetails(Collections.singletonList(CommonErrorDetailSpec.INVALID_DEVICE.makeInstance()));
                    throw new AuthnErrorException(authnError);
                }
                stateSupport.removePreviousPfStatus();
                stateSupport.setPreviousPfStatus(StateSpec.ONE_TIME_DEVICE_OTP_METHOD_TYPE_INPUT_REQUIRED_RESPONSE.getStatus());
                authnAdapterResponse = this.handler.handleDeviceAuthenticationStatusRequest(req, resp, inParameters, stateSupport);
            }
        } else if (StateSpec.ONE_TIME_DEVICE_OTP_INPUT_REQUIRED_RESPONSE.getStatus().equals(status) && this.isCheckOtpRequest(req, status)) {
            authnAdapterResponse = this.handler.handleOneTimeDeviceCheckOtpRequest(req, resp, inParameters, stateSupport);
        } else if (StateSpec.ONE_TIME_DEVICE_OTP_INPUT_REQUIRED_RESPONSE.getStatus().equals(status) && this.isOneTimeDeviceAuthResendOtpRequest(req, status)) {
            OneTimeDeviceInfo oneTimeDeviceInfo = stateSupport.getSelectedOneTimeDeviceOtpDevice();
            authnAdapterResponse = this.handler.handleCreateOneTimeDeviceAuthenticationRequest(req, resp, inParameters, oneTimeDeviceInfo, stateSupport);
        } else {
            authnAdapterResponse = this.handler.handleDeviceAuthenticationStatusRequest(req, resp, inParameters, stateSupport);
        }
        return authnAdapterResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public AuthnAdapterResponse lookupAuthN(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnAdapterException, IOException {
        username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        trackerCookieReceived = this.isTrackerCookieFound(req);
        resumePath = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
        stateSupport = this.stateSupportFactory.newInstance(req, resp, resumePath);
        adapterInfo = new PingIDSdkAdapterInfo.Builder().inParameters(inParameters).req(req).resp(resp).username(username).stateSupport(stateSupport).build();
        try {
            DynamicDataUtils.handleAndStoreDynamicData(adapterInfo);
        }
        catch (Exception var9_9) {
            // empty catch block
        }
        chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        ignoreFIDOPolicyAction = false;
        if (chainedAttributes != null && chainedAttributes.get("ignore-fido-policy-action") != null && "true".equalsIgnoreCase(skipFIDO = ((AttributeValue)chainedAttributes.get("ignore-fido-policy-action")).getValue())) {
            ignoreFIDOPolicyAction = true;
        }
        if (chainedAttributes != null && chainedAttributes.get(CoreContract.POLICY_ACTION.toString()) != null) {
            policyAction = ((AttributeValue)chainedAttributes.get(CoreContract.POLICY_ACTION.toString())).getValue();
            if (policyAction.toLowerCase().contains("qr")) {
                try {
                    authnAdapterResponse = this.doAuthenticationCodeFlow(req, resp, inParameters, stateSupport);
                }
                catch (AuthnErrorException e) {
                    authnAdapterResponse = this.handleAuthnErrorException(req, resp, e);
                }
                catch (AccessTokenProviderException | InvalidActionException | JoseException e) {
                    PingOneMfaIdpAdapter.LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST, e);
                    authnAdapterResponse = this.handler.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
                    return authnAdapterResponse;
                }
                catch (RateLimitApiResponseException e) {
                    return this.handler.handleRateLimitErrorResponse(req, resp, inParameters, e);
                }
                return authnAdapterResponse;
            }
            if ((policyAction.toLowerCase().contains("biometric") || policyAction.toLowerCase().contains("fido") || policyAction.toLowerCase().contains("faceid") || policyAction.toLowerCase().contains("touchid")) && !ignoreFIDOPolicyAction) {
                try {
                    authnAdapterResponse = this.doUsernamelessAuthenticationCodeFlow(req, resp, inParameters, stateSupport);
                }
                catch (AuthnErrorException e) {
                    authnAdapterResponse = this.handleAuthnErrorException(req, resp, e);
                }
                catch (AccessTokenProviderException | InvalidActionException | JoseException e) {
                    PingOneMfaIdpAdapter.LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST, e);
                    authnAdapterResponse = this.handler.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
                    return authnAdapterResponse;
                }
                catch (RateLimitApiResponseException e) {
                    return this.handler.handleRateLimitErrorResponse(req, resp, inParameters, e);
                }
                return authnAdapterResponse;
            }
        }
        currentStatus = stateSupport.getPreviousPfStatus();
        if (chainedAttributes != null && chainedAttributes.get("support-one-time-device-otp") != null) {
            supportOneTimeDeviceOTP = ((AttributeValue)chainedAttributes.get("support-one-time-device-otp")).getValue();
            authnAdapterResponse = null;
            if ("true".equalsIgnoreCase(supportOneTimeDeviceOTP)) {
                if (StringUtils.isBlank(currentStatus)) {
                    oneTimeDevicesInfo = this.handler.getOneTimeDevicesInfoObject(inParameters);
                    if (!oneTimeDevicesInfo.getDevices().isEmpty()) {
                        try {
                            pingOneUser = this.handler.getUserByIdOrName(username);
                            if (pingOneUser == null) ** GOTO lbl83
                            stateSupport.setUser(ModelMapperUtil.map(pingOneUser));
                            return this.initiateOneTimeDeviceOTPAuthenticationFlow(req, resp, inParameters, oneTimeDevicesInfo, stateSupport);
                        }
                        catch (AuthnErrorException e) {
                            authnAdapterResponse = this.handleAuthnErrorException(req, resp, e);
                        }
                        catch (AccessTokenProviderException | InvalidActionException | JoseException e) {
                            PingOneMfaIdpAdapter.LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST, e);
                            authnAdapterResponse = this.handler.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
                            return authnAdapterResponse;
                        }
                        catch (RateLimitApiResponseException e) {
                            return this.handler.handleRateLimitErrorResponse(req, resp, inParameters, e);
                        }
                    } else {
                        PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.ONE_TIME_DEVICE_OTP_FLOW_INSUFFICIENT_DATA);
                    }
                } else {
                    try {
                        authnAdapterResponse = this.handleOneTimeDeviceOTPAuthenticationFlow(req, resp, inParameters, stateSupport);
                    }
                    catch (AuthnErrorException e) {
                        authnAdapterResponse = this.handleAuthnErrorException(req, resp, e);
                    }
                    catch (AccessTokenProviderException | InvalidActionException | JoseException e) {
                        PingOneMfaIdpAdapter.LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST, e);
                        authnAdapterResponse = this.handler.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
                        return authnAdapterResponse;
                    }
                    catch (RateLimitApiResponseException e) {
                        return this.handler.handleRateLimitErrorResponse(req, resp, inParameters, e);
                    }
                    return authnAdapterResponse;
                }
            }
        }
lbl83:
        // 7 sources

        if (trackerCookieReceived && this.isCookieTrackingEnabled) {
            cookieUsername = this.getTrackerCookieUsername(req);
            if (StringUtils.isNotBlank(username) && !cookieUsername.equals(username)) {
                this.log.debug("Tracker cookie found with different user. So clearing cookie..");
                trackerCookieInfo = new TrackerCookieInfo(inParameters, req);
                isHttpOnly = trackerCookieInfo.isHttpOnly();
                isSecureCookie = trackerCookieInfo.isSecure();
                domain = trackerCookieInfo.getCookieDomain();
                path = trackerCookieInfo.getCookiePath();
                this.handler.deleteTrackerCookie(resp, domain, path, isHttpOnly, isSecureCookie);
            } else {
                stateSupport.setTrackerCookie(this.handler.getTrackerCookieData(req));
                inParameters.put("com.pingidentity.adapter.input.parameter.userid", cookieUsername);
                username = cookieUsername;
            }
        }
        stateSupport.setBypassMfaBeforeDeviceMgmt(false);
        stateSupport.setSupportUsePasswordPolicyAction(false);
        if (InParamsUtil.getBypassDeviceMFABeforeDeviceMgmtAttribute(inParameters, this.bypassDeviceMFABeforeDeviceMgmtAttribute).isPresent() && StringUtils.isNotBlank(byPassValue = InParamsUtil.getBypassDeviceMFABeforeDeviceMgmtAttribute(inParameters, this.bypassDeviceMFABeforeDeviceMgmtAttribute).get()) && "true".equalsIgnoreCase(byPassValue)) {
            stateSupport.setBypassMfaBeforeDeviceMgmt(true);
        }
        if (InParamsUtil.getUsePasswordConfigAttribute(inParameters, this.usePasswordPolicyActionAttribute).isPresent() && StringUtils.isNotBlank(userPasswordValue = InParamsUtil.getUsePasswordConfigAttribute(inParameters, this.usePasswordPolicyActionAttribute).get()) && "true".equalsIgnoreCase(userPasswordValue)) {
            stateSupport.setSupportUsePasswordPolicyAction(true);
        }
        if (StringUtils.isBlank(username)) {
            if (this.provisionUser) {
                if (InParamsUtil.getUsername(inParameters, this.usernameAttribute) == null) {
                    PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.MISSING_USERINFO);
                    message = "Username attribute must be mapped to this authentication source to provision the user.";
                    throw new AuthnAdapterException(message);
                }
            } else {
                PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.MISSING_USERINFO);
                message = "Incoming user ID must be mapped to this authentication source.";
                throw new AuthnAdapterException(message);
            }
        }
        if (StringUtils.isEmpty(stateSupport.getFlowId()) && AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters) && (sessionToken = stateSupport.getSessionToken()) != null) {
            this.log.debug("Account recovery flow initiated. So clearing pre-existing session to trigger fresh MFA flow.");
            stateSupport.removeSessionToken();
            try {
                this.flowsApiClient.signoff(sessionToken);
            }
            catch (RateLimitApiResponseException e) {
                this.handler.handleRateLimitErrorResponse(req, resp, inParameters, e);
            }
            catch (IOException e) {
                PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.SIGNOFF_ERROR);
            }
        }
        authnAdapterResponse = null;
        try {
            statusMapping = this.getStatus(stateSupport);
            status = statusMapping.getStatus();
            if (!this.authnApiSupport.isApiRequest(req) || req.getMethod().equals("GET") || this.isValidPingOneMfaAdapterAuthnApiPost(req, resp, stateSupport, status)) {
                if (this.isUsePasswordAuthRequest(req, status)) {
                    authnAdapterResponse = this.handler.handleUsePasswordAuthnRequest(req, resp, inParameters);
                } else if ("TRIGGER_COOKIE_FIDO_FLOW".equals(status)) {
                    authnAdapterResponse = this.handler.handleAuthenticateRequest(req, resp, inParameters, stateSupport, true);
                } else if (this.isAuthenticateRequest(req)) {
                    authnAdapterResponse = this.handler.handleAuthenticateRequest(req, resp, inParameters, stateSupport, false);
                } else if (this.isPollRequest(req, status)) {
                    flowResponse = statusMapping.getFlowResponse();
                    authnAdapterResponse = this.handler.handlePollRequest(req, resp, inParameters, stateSupport, flowResponse);
                } else if (this.isSetDefaultDeviceRequest(req, status)) {
                    authnAdapterResponse = this.handler.handleSetDefaultDeviceRequest(req, resp, inParameters, stateSupport);
                } else if (this.isSelectDeviceRequest(req, status)) {
                    if (CommonStateSpec.MFA_COMPLETED.getStatus().equals(status)) {
                        authnAdapterResponse = this.handler.handleStatusRequest(req, resp, inParameters, stateSupport, statusMapping);
                    } else {
                        flowResponse = statusMapping.getFlowResponse();
                        authnAdapterResponse = this.handler.handleSelectDeviceRequest(req, resp, inParameters, stateSupport, flowResponse);
                    }
                } else if (this.isCheckOtpRequest(req, status)) {
                    flowResponse = statusMapping.getFlowResponse();
                    authnAdapterResponse = this.handler.handleCheckOtpRequest(req, resp, inParameters, stateSupport, flowResponse);
                } else if (this.isCheckAssertionRequest(req, status)) {
                    flowResponse = statusMapping.getFlowResponse();
                    authnAdapterResponse = this.handler.handleCheckAssertionRequest(req, resp, inParameters, stateSupport, flowResponse);
                } else if (this.isContinueAuthenticationRequest(req, status)) {
                    authnAdapterResponse = this.handler.handleContinueAuthenticationRequest(req, resp, inParameters, stateSupport);
                } else if (this.isCancelAuthnRequest(req, status)) {
                    isIncompatible = this.handler.isBrowserIncompatibileForFIDOAuthFlow(req);
                    if (status.equals(StateSpec.ASSERTION_REQUIRED.getStatus()) && isIncompatible) {
                        flowResponse = statusMapping.getFlowResponse();
                        authnAdapterResponse = this.handler.handleSelectDeviceRequest(req, resp, inParameters, stateSupport, flowResponse);
                    } else {
                        authnAdapterResponse = this.handleCancelAuthnRequest(req, resp, inParameters, false);
                    }
                } else {
                    authnAdapterResponse = this.isUsePasscodeRequest(req, status) ? this.handler.handleUsePasscodeRequest(req, resp, inParameters, stateSupport) : (this.isSetupMfaRequest(req, status) ? this.handler.handleSetupMfaRequest(req, resp, inParameters, stateSupport) : (this.isSkipMfaRequest(req, status) ? this.handler.handleSkipMfaRequest(req, resp, inParameters, stateSupport) : (this.isSelectDevicePairingMethodRequest(req, status) ? this.handler.handleSelectDevicePairingMethodRequest(req, resp, inParameters, stateSupport) : (this.isCancelDevicePairingRequest(req, status) ? this.handler.handleCancelDevicePairingRequest(req, resp, inParameters, stateSupport) : (this.isSubmitEmailTargetRequest(req, status) ? this.handler.handleSubmitOfflineDeviceTargetRequest(TemplateParameter.EMAIL, req, resp, inParameters, stateSupport) : (this.isSubmitVoiceTargetRequest(req, status) ? this.handler.handleSubmitOfflineDeviceTargetRequest(TemplateParameter.VOICE_PHONE, req, resp, inParameters, stateSupport) : (this.isSubmitSmsTargetRequest(req, status) ? this.handler.handleSubmitOfflineDeviceTargetRequest(TemplateParameter.SMS_PHONE, req, resp, inParameters, stateSupport) : (this.isSubmitWhatsAppTargetRequest(req, status) ? this.handler.handleSubmitOfflineDeviceTargetRequest(TemplateParameter.WHATSAPP_PHONE, req, resp, inParameters, stateSupport) : (this.isActivateOfflineDeviceRequest(req, status) ? this.handler.handleActivateOfflineDeviceRequest(req, resp, inParameters, stateSupport) : (this.isResendOtpRequest(req, status) ? this.handler.handleResendOtpRequest(req, resp, inParameters, stateSupport) : (this.isActivateWebAuthnDeviceRequest(req, status, stateSupport) ? this.handler.handleActivateWebAuthnDeviceRequest(req, resp, inParameters, stateSupport) : (this.isRemoveDeviceRequest(req, status) ? this.handler.handleDeleteDeviceRequest(req, resp, inParameters, stateSupport) : (this.isUpdateDeviceRequest(req, status) ? this.handler.handleUpdateDeviceNickname(req, resp, inParameters, stateSupport) : (this.isSkipUpdateNicknameDuringDevicePairingRequest(req, status) ? this.handler.handleSkipUpdateNicknameDuringDevicePairingRequest(req, resp, inParameters, stateSupport) : (this.isCancelRemoveDeviceRequest(req, status) ? this.handler.handleCancelDeviceRemovalRequest(stateSupport) : this.handler.handleStatusRequest(req, resp, inParameters, stateSupport, statusMapping))))))))))))))));
                }
            } else {
                authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            }
        }
        catch (InvalidActionException e) {
            this.log.error(e.getMessage());
            this.authnApiSupport.writeErrorResponse(req, resp, CommonErrorSpec.INVALID_REQUEST.makeInstanceBuilder().message(e.getMessage()).build());
            authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setErrorMessage(e.getMessage());
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        }
        catch (AuthnErrorException e) {
            authnAdapterResponse = this.handleAuthnErrorException(req, resp, e);
        }
        catch (ConnectTimeoutException | HttpHostConnectException | SocketTimeoutException e) {
            PingOneMfaIdpAdapter.LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST, e);
            if (this.apiFailureBypass) {
                if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
                    PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.ACCOUNT_RECOVERY_UNSUPPORTED_WHEN_SERVICE_UNAVAILABLE);
                    authnAdapterResponse = this.handler.mfaFailedServiceUnavailableResponse(req, resp, inParameters, stateSupport);
                } else {
                    PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.SERVICE_UNAVAILABLE_BYPASS_ENABLED);
                    authnAdapterResponse = new AuthnAdapterResponse();
                    authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
                    authnAdapterResponse.setAttributeMap(this.handler.fulfillBypassedAttributeMap(username, false));
                }
            } else {
                PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.SERVICE_UNAVAILABLE_BYPASS_DISABLED);
                authnAdapterResponse = this.handler.mfaFailedServiceUnavailableResponse(req, resp, inParameters, stateSupport);
            }
        }
        catch (RateLimitApiResponseException e) {
            status = this.handler.handleRateLimitErrorResponse(req, resp, inParameters, e);
            return status;
        }
        catch (ApiResponseException e) {
            statusCode = Integer.toString(e.getStatusCode());
            detailedErrorCode = this.getDetailedErrorCodeFromErrorResponse(e);
            if (statusCode.startsWith("5")) {
                PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.SERVER_ERROR_5XX);
                if (this.apiFailureBypass) {
                    if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
                        PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.ACCOUNT_RECOVERY_UNSUPPORTED_WHEN_SERVICE_UNAVAILABLE);
                        authnAdapterResponse = this.handler.mfaFailedServiceUnavailableResponse(req, resp, inParameters, stateSupport);
                    } else {
                        PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.SERVICE_UNAVAILABLE_BYPASS_ENABLED);
                        authnAdapterResponse = new AuthnAdapterResponse();
                        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
                        authnAdapterResponse.setAttributeMap(this.handler.fulfillBypassedAttributeMap(username, false));
                    }
                } else {
                    PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.SERVICE_UNAVAILABLE_BYPASS_DISABLED);
                    authnAdapterResponse = this.handler.mfaFailedServiceUnavailableResponse(req, resp, inParameters, stateSupport);
                }
            } else if (e.getStatusCode() == 404) {
                authnAdapterResponse = this.handler.handleFlowTimeOutErrorResponse(req, resp, inParameters);
            } else if (StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus().equals(this.getStatus(stateSupport).getStatus())) {
                PingOneMfaIdpAdapter.LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.SERVER_ERROR_API_RESPONSE, e);
                authnAdapterResponse = this.handler.devicePairingMethodFailedServerErrorResponse(req, resp, inParameters, stateSupport, false, e);
            } else if ("LOGIN_REQUIRED".equals(detailedErrorCode)) {
                PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.LOGIN_REQUIRED_SERVER_ERROR);
                authnAdapterResponse = this.handler.mfaFailedLoginRequiredResponse(req, resp, inParameters, stateSupport);
            } else if ("INVALID_ASSERTION".equals(detailedErrorCode)) {
                PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.INVALID_ASSERTION_ERROR);
                authnAdapterResponse = this.handler.mfaFailedInvalidAssertionResponse(req, resp, inParameters, stateSupport);
            } else {
                PingOneMfaIdpAdapter.LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.SERVER_ERROR_API_RESPONSE, e);
                authnAdapterResponse = this.handler.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
            }
        }
        catch (AccessTokenProviderException e) {
            PingOneMfaIdpAdapter.LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST, e);
            if (e.getCause().getClass().getName().contains("SocketTimeoutException") || e.getCause().getClass().getName().contains("ConnectTimeoutException") || e.getCause().getClass().getName().contains("HttpHostConnectException")) {
                if (this.apiFailureBypass) {
                    if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
                        PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.ACCOUNT_RECOVERY_UNSUPPORTED_WHEN_SERVICE_UNAVAILABLE);
                        authnAdapterResponse = this.handler.mfaFailedServiceUnavailableResponse(req, resp, inParameters, stateSupport);
                    } else {
                        PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.SERVICE_UNAVAILABLE_BYPASS_ENABLED);
                        authnAdapterResponse = new AuthnAdapterResponse();
                        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
                        authnAdapterResponse.setAttributeMap(this.handler.fulfillBypassedAttributeMap(username, false));
                    }
                } else {
                    PingOneMfaIdpAdapter.LOG.log(PingOneMfaIdpAdapterLogEvent.SERVICE_UNAVAILABLE_BYPASS_DISABLED);
                    authnAdapterResponse = this.handler.mfaFailedServiceUnavailableResponse(req, resp, inParameters, stateSupport);
                }
            } else {
                authnAdapterResponse = this.handler.mfaFailedServiceUnavailableResponse(req, resp, inParameters, stateSupport);
            }
        }
        catch (JoseException e) {
            PingOneMfaIdpAdapter.LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST, e);
            authnAdapterResponse = this.handler.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
        }
        finally {
            if (this.isFlowComplete(authnAdapterResponse)) {
                stateSupport.cleanup();
            }
        }
        return authnAdapterResponse;
    }

    private String getDetailedErrorCodeFromErrorResponse(ApiResponseException e) {
        if (Objects.nonNull(e.getErrorResponse())) {
            ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
            this.log.debug("Error response details: " + errorResponse.getPrettyErrorDetails());
            if (Objects.nonNull(errorResponse.getDetails()) && !errorResponse.getDetails().isEmpty()) {
                ErrorDetail errorDetail = errorResponse.getDetails().get(0);
                return errorDetail.getCode();
            }
        }
        return null;
    }

    private boolean isValidPingOneMfaAdapterAuthnApiPost(HttpServletRequest req, HttpServletResponse resp, PingOneMfaStateSupport stateSupport, String nextStatus) throws IOException {
        String previousPfStatus = stateSupport.getPreviousPfStatus();
        boolean isSetupMfa = false;
        boolean isDeviceSelected = false;
        try {
            isSetupMfa = this.isSetupMfaRequest(req, nextStatus);
            isDeviceSelected = this.isSelectDeviceRequest(req, nextStatus);
        }
        catch (InvalidActionException invalidActionException) {
            // empty catch block
        }
        return (CommonActionSpec.POLL.isRequested(req) || isSetupMfa || isDeviceSelected) && StateSpec.PUSH_CONFIRMATION_WAITING.getStatus().equals(previousPfStatus) || this.pingOneMfaAuthnApiSupport.isValidPingOneMfaAdapterAuthnApiPost(req, resp, nextStatus);
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        IdpAuthnAdapterDescriptor descriptor = new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, "PingOne MFA IdP Adapter 2.7", this.getContract(), true, PingOneMfaAdapterConfiguration.adapterConfigurationGuiDescriptor(), false){

            public GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
                return new GuiConfigDescriptorBuilder(){

                    public GuiConfigDescriptor buildNewGuiDescriptor() {
                        return PingOneMfaAdapterConfiguration.adapterConfigurationGuiDescriptor();
                    }

                    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
                        return PingOneMfaAdapterConfiguration.adapterConfigurationGuiDescriptor(configuration);
                    }
                };
            }
        };
        if (supportsSetMetadata && supportsPluginServiceAssociation) {
            try {
                Class<?> pluginMetadataKeysClass = Class.forName("com.pingidentity.sdk.PluginMetadataKeys");
                Class<?> pluginServiceAssociationClass = Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
                Constructor<?> pluginServiceAssociationConstructor = pluginServiceAssociationClass.getConstructor(String.class, String.class);
                descriptor.setMetadata(Collections.singletonMap((String)pluginMetadataKeysClass.getField("PING_ONE_SERVICE_ASSOCIATION").get(null), pluginServiceAssociationConstructor.newInstance("MFA Adapter", pluginServiceAssociationClass.getField("MFA_SERVICE_DISPLAY_NAME").get(null))));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return descriptor;
    }

    public void configure(Configuration configuration) {
        this.configureInternalState(configuration);
        PingOneClientsFactory clientsFactory = new PingOneClientsFactory(configuration);
        this.envId = clientsFactory.getEnvId();
        this.authEndpoint = clientsFactory.getAuthPath();
        this.workerApiClient = clientsFactory.getWorkerApiClient();
        this.flowsApiClient = clientsFactory.getFlowsApiClient();
        TokenService tokenService = clientsFactory.getTokenServiceClient();
        this.pingOneMfaTemplateSupport = new PingOneMfaTemplateSupport(this.changeDeviceAllowed, this.htmlTemplate, this.messageProperties, this.allowSkipMfa, this.allowOnlyPredefineValuesForPhoneOrEmailDevices);
        this.pingOneMfaAuthnApiSupport = new PingOneMfaAuthnApiSupport(this.authnApiSupport, this.changeDeviceAllowed);
        AppSecretCache appSecretCache = new AppSecretCache("appSecret.", CACHE, new DefaultAppSecretProvider(configuration, tokenService, this.workerApiClient));
        this.handler = new PingOneMfaHandler.Builder().setAuthPath(this.authEndpoint).setEnvId(this.envId).setApplicationId(this.applicationId).setApplicationIdForQRFlow(this.applicationIdForQRFlow).setAuthenticationPolicy(this.authenticationPolicy).setRegistrationPolicy(this.registrationPolicy).setFlowsApiClient(this.flowsApiClient).setWorkerApiClient(this.workerApiClient).setTokenService(tokenService).setPingOneMfaTemplateSupport(this.pingOneMfaTemplateSupport).setPingOneMfaAuthnApiSupport(this.pingOneMfaAuthnApiSupport).setAppSecretCache(appSecretCache).setShowErrorScreen(this.showErrorScreen).setShowSuccessScreen(this.showSuccessScreen).setShowTimeoutScreen(this.showTimeoutScreen).setApiFailureBypass(this.apiFailureBypass).setInvalidUserBypass(this.invalidUserBypass).setChangeDeviceAllowed(this.changeDeviceAllowed).setAuditLoggingEnabled(this.auditLoggingEnabled).setAllowSetupMfa(this.allowSetupMfa).setAllowSkipMfa(this.allowSkipMfa).setAllowAddOrRemoveMethod(this.allowAddOrRemoveMethod).setProvisionUser(this.provisionUser).setProvisionAuthenticationMethods(this.provisionAuthenticationMethods).setUpdateAuthenticationMethods(this.updateAuthenticationMethods).setOverwriteAuthenticationMethods(this.overwriteAuthenticationMethodsConfig).setEnableCookieTracking(this.isCookieTrackingEnabled).setPopulationId(this.populationId).setSmsAttribute(this.smsAttribute).setVoiceAttribute(this.voiceAttribute).setEmailAttribute(this.emailAttribute).setWhatsAppAttribute(this.whatsAppAttribute).setUsernameAttribute(this.usernameAttribute).setDefaultDeviceType(this.defaultDeviceType).setNotificationTemplateVariantOverride(this.notificationTemplateOverride).setAllowOnlyPredefineValuesForPhoneOrEmailDevices(this.allowOnlyPredefineValuesForPhoneOrEmailDevices).build();
    }

    private void configureInternalState(Configuration configuration) {
        this.applicationId = PingOneMfaAdapterConfiguration.ApplicationField.getApplicationId(configuration);
        this.applicationIdForQRFlow = PingOneMfaAdapterConfiguration.AuthCodeFlowAppIDField.getAuthCodeFlowAppID(configuration);
        this.authenticationPolicy = PingOneMfaAdapterConfiguration.AuthenticationPolicyField.getAuthenticationPolicy(configuration);
        this.registrationPolicy = PingOneMfaAdapterConfiguration.RegistrationPolicyField.getRegistrationPolicy(configuration);
        this.notificationTemplateOverride = PingOneMfaAdapterConfiguration.NotificationTemplateVariantOverrideField.getNotificationTemplateOverride(configuration);
        this.showSuccessScreen = PingOneMfaAdapterConfiguration.SuccessScreensField.showSuccessScreenToUsers(configuration);
        this.showErrorScreen = PingOneMfaAdapterConfiguration.ErrorScreensField.showErrorScreenToUsers(configuration);
        this.showTimeoutScreen = PingOneMfaAdapterConfiguration.TimeoutScreensField.showTimeoutScreenToUsers(configuration);
        this.auditLoggingEnabled = PingOneMfaAdapterConfiguration.EnableAuditLogField.isAuditLogEnabled(configuration);
        this.changeDeviceAllowed = PingOneMfaAdapterConfiguration.ChangeDeviceField.isChangeDeviceAllowed(configuration);
        this.htmlTemplate = PingOneMfaAdapterConfiguration.HtmlTemplateField.getHtmlTemplate(configuration);
        this.messageProperties = PingOneMfaAdapterConfiguration.MessagePropertiesField.getMessageProperties(configuration);
        this.allowSetupMfa = PingOneMfaAdapterConfiguration.AllowSetupMfaField.isAllowSetupMfa(configuration);
        this.allowSkipMfa = PingOneMfaAdapterConfiguration.AllowSkipMfaField.isAllowSkipMfa(configuration);
        this.allowAddOrRemoveMethod = PingOneMfaAdapterConfiguration.AllowAddMethodField.isAllowAddOrRemoveMethod(configuration);
        this.invalidUserBypass = PingOneMfaAdapterConfiguration.UserNotFoundFailureModeField.bypassEnabled(configuration);
        this.apiFailureBypass = PingOneMfaAdapterConfiguration.ServiceUnavailableFailureModeField.bypassEnabled(configuration);
        this.provisionUser = PingOneMfaAdapterConfiguration.ProvisionUserField.isProvisionUser(configuration);
        this.provisionAuthenticationMethods = PingOneMfaAdapterConfiguration.ProvisionAuthenticationMethodsField.isProvisionAuthenticationMethods(configuration);
        this.updateAuthenticationMethods = PingOneMfaAdapterConfiguration.UpdateAuthenticationMethodsField.isUpdateAuthenticationMethods(configuration);
        this.overwriteAuthenticationMethodsConfig = PingOneMfaAdapterConfiguration.OverwriteAuthenticationMethodsConfigurationField.getOverwriteAuthenticationMethodsConfigurations(configuration);
        this.isCookieTrackingEnabled = PingOneMfaAdapterConfiguration.EnableCookieTrackingField.isCookieTrackingEnabled(configuration);
        this.usePasswordPolicyActionAttribute = PingOneMfaAdapterConfiguration.UsePasswordPolicyActionField.getUsePasswordPolicyActionField(configuration);
        this.bypassDeviceMFABeforeDeviceMgmtAttribute = PingOneMfaAdapterConfiguration.BypassMFABeforeDeviceMgmtAttributeField.getBypassMFAForDeviceMgmtAttributeField(configuration);
        this.populationId = PingOneMfaAdapterConfiguration.PopulationField.getPingOnePopulation(configuration);
        this.smsAttribute = PingOneMfaAdapterConfiguration.SmsAttributeField.getSmsAttribute(configuration);
        this.voiceAttribute = PingOneMfaAdapterConfiguration.VoiceAttributeField.getVoiceAttribute(configuration);
        this.emailAttribute = PingOneMfaAdapterConfiguration.EmailAttributeField.getEmailAttribute(configuration);
        this.whatsAppAttribute = PingOneMfaAdapterConfiguration.WhatsAppAttributeField.getWhatsAppAttribute(configuration);
        this.usernameAttribute = PingOneMfaAdapterConfiguration.UsernameAttributeField.getUsernameAttribute(configuration);
        this.defaultDeviceType = PingOneMfaAdapterConfiguration.DefaultDeviceTypeField.getDefaultDeviceType(configuration);
        this.allowOnlyPredefineValuesForPhoneOrEmailDevices = PingOneMfaAdapterConfiguration.AllowOnlyPredefineValuesForPhoneOrEmailDevicesField.getAllowOnlyPredefineValuesForPhoneOrEmailDevicesField(configuration);
    }

    public Map lookupAuthN(HttpServletRequest req, HttpServletResponse resp, String s, AuthnPolicy authnPolicy, String s1) {
        return null;
    }

    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest req, HttpServletResponse resp, String resumePath) {
        boolean logoutWasSuccessful = true;
        PingOneMfaStateSupport stateSupport = this.stateSupportFactory.newInstance(req, resp, resumePath);
        String sessionToken = stateSupport.getSessionToken();
        if (sessionToken != null) {
            stateSupport.removeSessionToken();
            try {
                this.flowsApiClient.signoff(sessionToken);
            }
            catch (IOException ignored) {
                logoutWasSuccessful = false;
                LOG.log(PingOneMfaIdpAdapterLogEvent.SIGNOFF_ERROR);
            }
        }
        return logoutWasSuccessful;
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    public PluginApiSpec getApiSpec() {
        return new PluginApiSpec(PingOneMfaAuthnApiSupport.getAuthnStateSpecs());
    }

    public static boolean supportsSetMetadata() {
        return supportsSetMetadata;
    }

    public static boolean supportsPluginServiceAssociation() {
        return supportsPluginServiceAssociation;
    }

    private Set<String> getContract() {
        return Arrays.stream(CoreContract.values()).map(CoreContract::toString).collect(Collectors.toSet());
    }

    private StatusMapping getStatus(PingOneMfaStateSupport stateSupport) throws IOException {
        String pfStatus;
        String flowId = stateSupport.getFlowId();
        String mfaFailedCode = stateSupport.getMfaFailedCode();
        String previousPfStatus = stateSupport.getPreviousPfStatus();
        FlowResponse flowResponse = null;
        if (StringUtils.isNotBlank(mfaFailedCode) || StateSpec.MFA_FAILED.getStatus().equals(previousPfStatus)) {
            pfStatus = StringUtils.isNotBlank(mfaFailedCode) && StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus().equals(previousPfStatus) && stateSupport.getDevicePairingErrorDetail() != null ? StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED.getStatus() : (StringUtils.isNotBlank(mfaFailedCode) && StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus) && stateSupport.getDevicePairingErrorDetail() != null ? StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED.getStatus() : StateSpec.MFA_FAILED.getStatus());
        } else if (StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED.getStatus();
        } else if (CommonStateSpec.MOBILE_PAIRING_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = CommonStateSpec.MOBILE_PAIRING_REQUIRED.getStatus();
        } else if (CommonStateSpec.MFA_COMPLETED.getStatus().equals(previousPfStatus)) {
            pfStatus = CommonStateSpec.MFA_COMPLETED.getStatus();
        } else if (StateSpec.MFA_SETUP_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.MFA_SETUP_REQUIRED.getStatus();
        } else if (StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus();
        } else if (StateSpec.EMAIL_PAIRING_TARGET_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.EMAIL_PAIRING_TARGET_REQUIRED.getStatus();
        } else if (StateSpec.UPDATE_NICKNAME.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.UPDATE_NICKNAME.getStatus();
        } else if (StateSpec.SMS_PAIRING_TARGET_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.SMS_PAIRING_TARGET_REQUIRED.getStatus();
        } else if (StateSpec.VOICE_PAIRING_TARGET_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.VOICE_PAIRING_TARGET_REQUIRED.getStatus();
        } else if (StateSpec.WHATSAPP_PAIRING_TARGET_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.WHATSAPP_PAIRING_TARGET_REQUIRED.getStatus();
        } else if (StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus();
        } else if (StateSpec.TOTP_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.TOTP_ACTIVATION_REQUIRED.getStatus();
        } else if (StateSpec.EMAIL_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.EMAIL_ACTIVATION_REQUIRED.getStatus();
        } else if (StateSpec.SMS_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.SMS_ACTIVATION_REQUIRED.getStatus();
        } else if (StateSpec.VOICE_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.VOICE_ACTIVATION_REQUIRED.getStatus();
        } else if (StateSpec.WHATSAPP_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.WHATSAPP_ACTIVATION_REQUIRED.getStatus();
        } else if (StateSpec.PLATFORM_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.PLATFORM_ACTIVATION_REQUIRED.getStatus();
        } else if (StateSpec.SECURITY_KEY_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.SECURITY_KEY_ACTIVATION_REQUIRED.getStatus();
        } else if (StateSpec.FIDO2_ACTIVATION_REQUIRED.getStatus().equals(previousPfStatus)) {
            pfStatus = StateSpec.FIDO2_ACTIVATION_REQUIRED.getStatus();
        } else if (StringUtils.isBlank(flowId) && StringUtils.isNotBlank(stateSupport.getTrackerCookie()) && this.isCookieTrackingEnabled) {
            pfStatus = "TRIGGER_COOKIE_FIDO_FLOW";
        } else if (StringUtils.isBlank(flowId)) {
            pfStatus = StateSpec.AUTHENTICATION_REQUIRED.getStatus();
        } else {
            String sessionToken = stateSupport.getSessionToken();
            flowResponse = this.flowsApiClient.getFlow(flowId, sessionToken);
            String pingOneStatus = flowResponse.getStatus();
            switch (Status.valueOf(pingOneStatus)) {
                case DEVICE_SELECTION_REQUIRED: {
                    pfStatus = StateSpec.DEVICE_SELECTION_REQUIRED.getStatus();
                    break;
                }
                case OTP_REQUIRED: {
                    pfStatus = StateSpec.OTP_REQUIRED.getStatus();
                    break;
                }
                case ASSERTION_REQUIRED: {
                    pfStatus = StateSpec.ASSERTION_REQUIRED.getStatus();
                    break;
                }
                case PUSH_CONFIRMATION_REQUIRED: {
                    pfStatus = StateSpec.PUSH_CONFIRMATION_WAITING.getStatus();
                    break;
                }
                case PUSH_CONFIRMATION_TIMED_OUT: {
                    pfStatus = StateSpec.PUSH_CONFIRMATION_TIMED_OUT.getStatus();
                    break;
                }
                case COMPLETED: {
                    pfStatus = CommonStateSpec.MFA_COMPLETED.getStatus();
                    break;
                }
                case FAILED: {
                    if (StateSpec.PUSH_CONFIRMATION_REJECTED.getStatus().equals(previousPfStatus)) {
                        pfStatus = StateSpec.PUSH_CONFIRMATION_REJECTED.getStatus();
                        break;
                    }
                    pfStatus = StateSpec.MFA_FAILED.getStatus();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + Status.valueOf(flowResponse.getStatus()));
                }
            }
        }
        return new StatusMapping(pfStatus, flowResponse);
    }

    private boolean isAuthenticateRequest(HttpServletRequest req) {
        return "POST".equals(req.getMethod()) && this.pingOneMfaAuthnApiSupport.isAuthenticateRequest(req);
    }

    private boolean isUsePasswordAuthRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isUsePasswordAuthRequest(req, status) || this.pingOneMfaAuthnApiSupport.isUsePasswordAuthRequest(req));
    }

    private boolean isSetDefaultDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSetDefaultDevice(req, status) || this.pingOneMfaAuthnApiSupport.isSetDefaultDevice(req));
    }

    private boolean isSelectDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSelectDeviceRequest(req, status) || this.pingOneMfaAuthnApiSupport.isSelectDeviceRequest(req));
    }

    private boolean isCheckOtpRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isCheckOtpRequest(req, status) || this.pingOneMfaAuthnApiSupport.isCheckOtpRequest(req));
    }

    private boolean isSelectOneTimeDeviceMethod(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSelectDeviceRequest(req, status) || this.pingOneMfaAuthnApiSupport.isOneTimeDeviceSelectDeviceRequest(req));
    }

    private boolean isOneTimeDeviceAuthResendOtpRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isOneTimeDeviceAuthResendOtpRequest(req, status) || this.pingOneMfaAuthnApiSupport.isOneTimeOTPResendOtpRequest(req));
    }

    private boolean isResendOtpRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isResendOtpRequest(req, status) || this.pingOneMfaAuthnApiSupport.isResendOtpRequest(req));
    }

    private boolean isCheckAssertionRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isCheckAssertionRequest(req, status) || this.pingOneMfaAuthnApiSupport.isCheckAssertionRequest(req));
    }

    private boolean isPollRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaAuthnApiSupport.isPollRequest(req) || this.pingOneMfaTemplateSupport.isPollRequest(req, status));
    }

    private boolean isContinueAuthenticationRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isContinueAuthenticationRequest(req, status) || this.pingOneMfaAuthnApiSupport.isContinueAuthenticationRequest(req));
    }

    private boolean isCancelAuthnRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isCancelAuthnRequest(req, status) || this.pingOneMfaAuthnApiSupport.isCancelAuthenticationRequest(req));
    }

    private boolean isUsernamelessFlowCancelAuthnRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isUsernamelessCancelAuthnRequest(req, status) || this.pingOneMfaAuthnApiSupport.isCancelAuthenticationRequest(req));
    }

    private boolean isContinueBiometricAuthenticationRequest(HttpServletRequest req, String status) {
        return "POST".equals(req.getMethod()) && StateSpec.BIOMETRIC_DEVICE_AUTHENTICATION_INFO_REQUIRED.getStatus().equals(status) && this.pingOneMfaAuthnApiSupport.isContinueBiometricAuthenticationRequest(req);
    }

    private boolean isBiometricAuthenticationRequestStatusCheck(HttpServletRequest req, String status) {
        return StateSpec.BIOMETRIC_DEVICE_AUTHENTICATION_INFO_REQUIRED.getStatus().equals(status) && this.authnApiSupport.isApiRequest(req);
    }

    private boolean isCancelBiometricAuthenticationRequest(HttpServletRequest req, String status) {
        return "POST".equals(req.getMethod()) && StateSpec.BIOMETRIC_DEVICE_AUTHENTICATION_INFO_REQUIRED.getStatus().equals(status) && this.pingOneMfaAuthnApiSupport.isCancelAuthenticationRequest(req);
    }

    private boolean isUsePasscodeRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && this.pingOneMfaTemplateSupport.isUsePasscodeRequest(req, status);
    }

    private boolean isSetupMfaRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSetupMfaRequest(req, status) || this.pingOneMfaAuthnApiSupport.isSetupMfaRequest(req));
    }

    private boolean isRemoveDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isRemoveDeviceRequest(req, status) || this.pingOneMfaAuthnApiSupport.isRemoveDeviceRequest(req));
    }

    private boolean isUpdateDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isUpdateDeviceRequest(req) || this.pingOneMfaAuthnApiSupport.isUpdateDeviceRequest(req));
    }

    private boolean isSkipUpdateNicknameDuringDevicePairingRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSkipUpdateNicknameDuringDevicePairingRequest(req, status) || this.pingOneMfaAuthnApiSupport.isSkipUpdateNicknameDuringDevicePairingRequest(req));
    }

    private boolean isCancelRemoveDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isCancelRemoveDeviceRequest(req, status) || this.pingOneMfaAuthnApiSupport.isCancelRemoveDeviceRequest(req));
    }

    private boolean isSkipMfaRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSkipMfaRequest(req, status) || this.pingOneMfaAuthnApiSupport.isSkipMfaRequest(req));
    }

    private boolean isSelectDevicePairingMethodRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSelectDevicePairingMethodRequest(req, status) || this.pingOneMfaAuthnApiSupport.isSelectDevicePairingMethodRequest(req));
    }

    private boolean isCancelDevicePairingRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isCancelDevicePairingRequest(req, status) || this.pingOneMfaAuthnApiSupport.isCancelDevicePairingRequest(req));
    }

    private boolean isSubmitEmailTargetRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSubmitEmailTargetRequest(req, status) || this.pingOneMfaAuthnApiSupport.isSubmitEmailTargetRequest(req));
    }

    private boolean isSubmitVoiceTargetRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSubmitVoiceTargetRequest(req, status) || this.pingOneMfaAuthnApiSupport.isSubmitVoiceTargetRequest(req));
    }

    private boolean isSubmitSmsTargetRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSubmitSmsTargetRequest(req, status) || this.pingOneMfaAuthnApiSupport.isSubmitSmsTargetRequest(req));
    }

    private boolean isSubmitWhatsAppTargetRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isSubmitWhatsAppTargetRequest(req, status) || this.pingOneMfaAuthnApiSupport.isSubmitWhatsAppTargetRequest(req));
    }

    private boolean isActivateOfflineDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && (this.pingOneMfaTemplateSupport.isActivateOfflineDeviceRequest(req, status) || this.pingOneMfaAuthnApiSupport.isActivateOfflineDeviceRequest(req));
    }

    private boolean isActivateWebAuthnDeviceRequest(HttpServletRequest req, String status, PingOneMfaStateSupport stateSupport) throws InvalidActionException {
        return "POST".equals(req.getMethod()) && stateSupport.isManualPairingFlow() && (this.pingOneMfaTemplateSupport.isActivateWebAuthnRequest(req, status) || this.pingOneMfaAuthnApiSupport.isActivateWebAuthnDevice(req));
    }

    private AuthnAdapterResponse handleCancelAuthnRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean clearTrackerCookie) {
        return this.handler.handleCancelAuthnRequest(req, resp, inParameters, clearTrackerCookie);
    }

    private AuthnAdapterResponse handleAuthnErrorException(HttpServletRequest req, HttpServletResponse resp, AuthnErrorException e) throws IOException {
        this.authnApiSupport.writeErrorResponse(req, resp, e.getValidationError());
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private boolean isFlowComplete(AuthnAdapterResponse authnAdapterResponse) {
        return authnAdapterResponse == null || !AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS.equals((Object)authnAdapterResponse.getAuthnStatus());
    }

    static {
        Method[] methods = PluginDescriptor.class.getMethods();
        if (Arrays.stream(methods).anyMatch(m -> "setMetadata".equals(m.getName()))) {
            supportsSetMetadata = true;
        }
        try {
            Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
            supportsPluginServiceAssociation = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPluginServiceAssociation = false;
        }
        CACHE = CacheBuilder.newBuilder().build();
    }
}

