/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa;

import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogLevel;

public enum PingOneMfaIdpAdapterLogEvent implements LogEvent
{
    MISSING_USERINFO(LogLevel.ERROR, "001", "User ID missing. Returning failure."),
    ERROR_PROCESSING_REQUEST(LogLevel.ERROR, "002", "Error encountered processing request."),
    SERVICE_UNAVAILABLE_BYPASS_ENABLED(LogLevel.DEBUG, "003", "Service Unavailable Failure Mode is true, so returning success."),
    SERVICE_UNAVAILABLE_BYPASS_DISABLED(LogLevel.DEBUG, "004", "Service Unavailable Failure Mode is false, so treating as MFA service failure."),
    SERVER_ERROR_5XX(LogLevel.ERROR, "005", "Received 5xx status error."),
    SERVER_ERROR_API_RESPONSE(LogLevel.DEBUG, "006", "Received error response with API call."),
    MFA_FAILED(LogLevel.ERROR, "007", "MFA failed received from PingOne: '%s'."),
    INVALID_USER_BYPASS_ENABLED(LogLevel.DEBUG, "008", "Invalid user. Failure mode enable to bypass authentication. Returning success."),
    INVALID_USER_BYPASS_DISABLED(LogLevel.DEBUG, "009", "Invalid user. Failure mode enable to block authentication. Returning failure."),
    TOKEN_REFRESH(LogLevel.DEBUG, "010", "PingOne access token is not cached or has expired. Requesting new token."),
    UNSUPPORTED_RESPONSE(LogLevel.ERROR, "011", "Unsupported response received from PingOne. Verify PingOne policy, application configuration."),
    SIGNOFF_ERROR(LogLevel.ERROR, "012", "There was a problem terminating the PingOne session, PingOne could not process the request."),
    ACCOUNT_RECOVERY_UNSUPPORTED_WITHOUT_MFA(LogLevel.ERROR, "013", "Account recovery flow must go through MFA for success."),
    ACCOUNT_RECOVERY_UNSUPPORTED_WHEN_SERVICE_UNAVAILABLE(LogLevel.ERROR, "014", "Service unavailable but account recovery flow must go through MFA for success."),
    GET_POPULATIONS_ERROR(LogLevel.ERROR, "015", "There was an error fetching populations from PingOne."),
    NEW_USER_PROVISIONED(LogLevel.DEBUG, "016", "New user '%s' provisioned with user.id '%s'."),
    NEW_SMS_DEVICE_PROVISIONED(LogLevel.DEBUG, "017", "New SMS device with id '%s' provisioned for user '%s'."),
    NEW_EMAIL_DEVICE_PROVISIONED(LogLevel.DEBUG, "018", "New email device with id '%s' provisioned for user '%s'."),
    DEVICE_LIMIT_EXCEEDED(LogLevel.ERROR, "019", "Unable to add new device '%s' for user '%s', maximum number of devices has been reached."),
    INVALID_DEVICE_TARGET_FORMAT(LogLevel.ERROR, "020", "Unable to add new device '%s' for user '%s', device target format is invalid."),
    NON_UNIQUE_USERNAME(LogLevel.ERROR, "021", "Unable to provision new user, user with username '%s' already exists in PingOne."),
    GET_POPULATIONS_ACTION_FAILURE(LogLevel.ERROR, "022", "Unable to get populations from PingOne."),
    GET_APPLICATIONS_ERROR(LogLevel.ERROR, "023", "There was an error fetching applications from PingOne."),
    NEW_VOICE_DEVICE_PROVISIONED(LogLevel.DEBUG, "024", "New voice device with id '%s' provisioned for user '%s'."),
    MFA_SKIPPED(LogLevel.DEBUG, "025", "MFA skipped for user '%s'."),
    INVALID_ACTION_PARAM_RECEIVED(LogLevel.WARN, "026", "Invalid action param '%s' received for current state '%s'."),
    APPLICATION_ID_UNCONFIGURED_FOR_AUTHENTICATION_CODE_FLOW(LogLevel.ERROR, "027", "Application ID is not configured to invoke authentication code based flow."),
    ONE_TIME_DEVICE_OTP_FLOW_INSUFFICIENT_DATA(LogLevel.DEBUG, "028", "One-Time Device OTP flow invoked without valid email and or phone number values."),
    ERROR_PROCESSING_REQUEST_FOR_USERNAMELESS_FLOW(LogLevel.ERROR, "029", "Error encountered processing usernameless (biometrics) flow request."),
    UNEXPECTED_RESPONSE_ERROR_IN_USERNAMELESS_FLOW(LogLevel.ERROR, "030", "Encountered unexpected response in usernameless (biometrics) flow."),
    FAILED_ASSERTION_VALIDATION_IN_USERNAMELESS_FLOW(LogLevel.ERROR, "031", "Failed to validate assertion in usernameless (biometrics) flow."),
    UNEXPECTED_STATE_IN_USERNAMELESS_FLOW(LogLevel.ERROR, "032", "Unexpected state in usernameless (biometrics) flow."),
    SET_DEFAULT_DEVICE_ACTION_FAILURE(LogLevel.ERROR, "033", "Unable to set device id '%s' as default device for user '%s'."),
    AUTHENTICATION_CODE_FLOW_ERROR_INVALID_REQUEST(LogLevel.ERROR, "034", "Encountered error response in authentication code flow."),
    REMOVE_DEVICE_FAILURE(LogLevel.ERROR, "035", "Unable to remove device id '%s' for user '%s'."),
    UPDATE_DEVICE_FAILURE(LogLevel.ERROR, "036", "Unable to update device id '%s' for user '%s'."),
    LOGIN_REQUIRED_SERVER_ERROR(LogLevel.ERROR, "037", "Login required error received from server"),
    GET_MFA_POLICIES_ERROR(LogLevel.ERROR, "038", "Failed to fetch MFA policies from Pingone"),
    INVALID_ASSERTION_ERROR(LogLevel.ERROR, "039", "Invalid assertion error received from the server");

    private static final String PRODUCT_CODE = "P1MFA";
    private final LogLevel level;
    private final String code;
    private final String message;

    private PingOneMfaIdpAdapterLogEvent(LogLevel level, String code, String message) {
        this.level = level;
        this.code = code;
        this.message = message;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getCode() {
        return PRODUCT_CODE + this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

