/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow;

import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDeviceInfo;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class OneTimeDevicesInfo
implements Serializable {
    ArrayList<OneTimeDeviceInfo> devices = new ArrayList();

    public void addEmailDevice(String email) {
        if (StringUtils.isNotBlank(email)) {
            String uuid = UUID.randomUUID().toString();
            OneTimeDeviceInfo oneTimeDeviceInfo = new OneTimeDeviceInfo(OneTimeDeviceInfo.Type.Email, email.trim(), uuid);
            this.devices.add(oneTimeDeviceInfo);
        }
    }

    public void addEmailDevices(List<String> emails) {
        for (String email : emails) {
            this.addEmailDevice(email);
        }
    }

    public void addSmsDevice(String smsNumber) {
        if (StringUtils.isNotBlank(smsNumber)) {
            String uuid = UUID.randomUUID().toString();
            OneTimeDeviceInfo oneTimeDeviceInfo = new OneTimeDeviceInfo(OneTimeDeviceInfo.Type.SMS, smsNumber.trim(), uuid);
            this.devices.add(oneTimeDeviceInfo);
        }
    }

    public void addSmsDevices(List<String> smsNumbers) {
        for (String smsNumber : smsNumbers) {
            this.addSmsDevice(smsNumber);
        }
    }

    public void addVoiceDevice(String voiceNumber) {
        if (StringUtils.isNotBlank(voiceNumber)) {
            String uuid = UUID.randomUUID().toString();
            OneTimeDeviceInfo oneTimeDeviceInfo = new OneTimeDeviceInfo(OneTimeDeviceInfo.Type.Voice, voiceNumber.trim(), uuid);
            this.devices.add(oneTimeDeviceInfo);
        }
    }

    public void addVoiceDevices(List<String> voiceNumbers) {
        for (String voiceNumber : voiceNumbers) {
            this.addVoiceDevice(voiceNumber);
        }
    }

    public void addWhatsAppDevice(String whatsAppNumber) {
        if (StringUtils.isNotBlank(whatsAppNumber)) {
            String uuid = UUID.randomUUID().toString();
            OneTimeDeviceInfo oneTimeDeviceInfo = new OneTimeDeviceInfo(OneTimeDeviceInfo.Type.WhatsApp, whatsAppNumber.trim(), uuid);
            this.devices.add(oneTimeDeviceInfo);
        }
    }

    public void addWhatsAppDevices(List<String> whatsAppNumbers) {
        for (String whatsAppNumber : whatsAppNumbers) {
            this.addWhatsAppDevice(whatsAppNumber);
        }
    }

    public boolean isDeviceSelectionRequired() {
        return this.devices.size() != 1;
    }

    public ArrayList<OneTimeDeviceInfo> getDevices() {
        return this.devices;
    }

    public ArrayList<OneTimeDeviceInfo> getDevicesWithMaskedInfoValues() {
        ArrayList<OneTimeDeviceInfo> maskedDevices = new ArrayList<OneTimeDeviceInfo>();
        for (OneTimeDeviceInfo device : this.devices) {
            String maskedTarget = device.retrieveMaskedTarget();
            OneTimeDeviceInfo maskedDevice = new OneTimeDeviceInfo(device.getType(), maskedTarget, device.getId());
            maskedDevices.add(maskedDevice);
        }
        return maskedDevices;
    }
}

