/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.authn.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Notification;
import com.pingidentity.adapters.pingone.mfa.authn.api.Lock;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class Device
extends com.pingidentity.sdk.api.authn.model.Device
implements Serializable {
    @Schema(description="The model of the device, if the device is a mobile application. For other device types, this attribute is empty.")
    private String name;
    @Schema(description="The ID of the native application associated with this device. For other device types, this attribute is empty.")
    private String applicationId;
    @Schema(description="The device's application version, if the device is a mobile application. For other device types, this attribute is empty.")
    private String applicationVersion;
    @Schema(description="The device's operating system version, if the device is a mobile application. For other device types, this attribute is empty.")
    private String osVersion;
    @Schema(description="Indicates whether the device is usable.")
    private boolean usable = true;
    @Schema(description="The device nickname.")
    private String nickname;
    @Schema(description="The Relying party identifier if the device type is Security Key or Platform (Biometrics).")
    private String rpId;
    @Schema(description="Indicates whether the device is push enabled, if the device is a mobile application. For other device types, this attribute is omitted.")
    private Boolean pushEnabled;
    @Schema(description="Indicates whether the device is OTP enabled, if the device is a mobile application. For other device types, this attribute is omitted.")
    private Boolean otpEnabled;
    @Schema(description="Indicates whether the device is default or not.")
    private Boolean defaultDevice = false;
    @Schema(description="Application name for mobile device")
    private String applicationName;
    @Schema(description="Contains lock details if the device is locked, otherwise null")
    private Lock lock;
    @Schema(description="Represents notification details. Primarily used to track the cooldown period when a device is restricted from receiving further notifications due to the maximum limit being reached.")
    private Notification notification;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.getId(), device.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public Device copy(Device sourceDevice) {
        Device device = new Device();
        device.setName(sourceDevice.getName());
        device.setApplicationId(sourceDevice.getApplicationId());
        device.setApplicationVersion(sourceDevice.getApplicationVersion());
        device.setOsVersion(sourceDevice.getOsVersion());
        device.setUsable(sourceDevice.isUsable());
        device.setNickname(sourceDevice.getNickname());
        device.setRpId(sourceDevice.getRpId());
        device.setPushEnabled(sourceDevice.getPushEnabled());
        device.setOtpEnabled(sourceDevice.getOtpEnabled());
        device.setDefaultDevice(sourceDevice.getDefaultDevice());
        device.setId(sourceDevice.getId());
        device.setType(sourceDevice.getType());
        device.setTarget(sourceDevice.getTarget());
        device.setApplicationName(sourceDevice.getApplicationName());
        return device;
    }

    @JsonIgnore
    public Long getNotificationCoolDownExpiresAt() {
        if (this.notification != null) {
            return this.notification.getCoolDownExpiresAt();
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setRpId(String rpId) {
        this.rpId = rpId;
    }

    public void setPushEnabled(Boolean pushEnabled) {
        this.pushEnabled = pushEnabled;
    }

    public void setOtpEnabled(Boolean otpEnabled) {
        this.otpEnabled = otpEnabled;
    }

    public void setDefaultDevice(Boolean defaultDevice) {
        this.defaultDevice = defaultDevice;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setLock(Lock lock) {
        this.lock = lock;
    }

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getRpId() {
        return this.rpId;
    }

    public Boolean getPushEnabled() {
        return this.pushEnabled;
    }

    public Boolean getOtpEnabled() {
        return this.otpEnabled;
    }

    public Boolean getDefaultDevice() {
        return this.defaultDevice;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Lock getLock() {
        return this.lock;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public static enum Type {
        ANDROID("Android"),
        IPHONE("iPhone"),
        MOBILE("MOBILE"),
        SMS("SMS"),
        EMAIL("Email"),
        TOTP("TOTP"),
        PLATFORM("PLATFORM"),
        SECURITY_KEY("SECURITY_KEY"),
        VOICE("Voice"),
        FIDO2("FIDO2"),
        WHATSAPP("WHATSAPP");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type fromName(String name) {
            return Arrays.stream(Type.values()).filter(it -> it.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
        }
    }
}

