/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.authn.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.pingidentity.adapters.pingone.mfa.authn.api.Device;
import com.pingidentity.adapters.pingone.mfa.authn.api.EmailDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.MobileDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.SmsDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.VoiceDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.WebAuthnDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.WhatsAppDevicePairingMethod;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="deviceType", include=JsonTypeInfo.As.EXISTING_PROPERTY, visible=true, defaultImpl=DevicePairingMethod.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MobileDevicePairingMethod.class, name="MOBILE"), @JsonSubTypes.Type(value=WebAuthnDevicePairingMethod.class, name="FIDO2"), @JsonSubTypes.Type(value=WebAuthnDevicePairingMethod.class, name="PLATFORM"), @JsonSubTypes.Type(value=WebAuthnDevicePairingMethod.class, name="SECURITY_KEY"), @JsonSubTypes.Type(value=SmsDevicePairingMethod.class, name="SMS"), @JsonSubTypes.Type(value=VoiceDevicePairingMethod.class, name="Voice"), @JsonSubTypes.Type(value=WhatsAppDevicePairingMethod.class, name="WHATSAPP"), @JsonSubTypes.Type(value=EmailDevicePairingMethod.class, name="Email")})
@Schema(description="A multi-factor authentication device pairing method.")
public class DevicePairingMethod
implements Serializable {
    @Schema(description="The type of the device.")
    protected String deviceType;

    public DevicePairingMethod(Device.Type deviceType) {
        this.deviceType = deviceType.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DevicePairingMethod)) {
            return false;
        }
        DevicePairingMethod that = (DevicePairingMethod)o;
        return this.deviceType.equals(that.deviceType);
    }

    public int hashCode() {
        return Objects.hash(this.deviceType);
    }

    @JsonIgnore
    public boolean isOfflineDevice() {
        return false;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public DevicePairingMethod() {
    }
}

