/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.config;

import com.pingidentity.adapters.pingone.mfa.PingOneMfaIdpAdapterLogEvent;
import com.pingidentity.adapters.pingone.mfa.api.client.PingOneClientsFactory;
import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.model.ApiResponse;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.common.cache.Cache;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.common.cache.CacheBuilder;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;

public abstract class ApiHelper {
    private static final IntegrationsLogger LOG = new IntegrationsLogger(ApiHelper.class);
    protected static final Cache<String, Object> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    protected final String cacheKeyPrefix;

    protected ApiHelper(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    protected List<AbstractSelectionFieldDescriptor.OptionValue> getOptionValues(Configuration configuration) {
        TokenService tokenService;
        PingOneClientsFactory clientsFactory;
        WorkerApiClient workerApiClient;
        String pingOneEnvironment = PingOneMfaAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
        String cacheKey = this.cacheKeyPrefix + pingOneEnvironment;
        List<AbstractSelectionFieldDescriptor.OptionValue> optionValues = (List<AbstractSelectionFieldDescriptor.OptionValue>)cache.getIfPresent(cacheKey);
        if (optionValues == null && (optionValues = this.getOptionValues(workerApiClient = (clientsFactory = new PingOneClientsFactory(configuration)).getWorkerApiClient(), tokenService = clientsFactory.getTokenServiceClient())).size() > 1) {
            cache.put(cacheKey, optionValues);
        }
        return optionValues;
    }

    List<AbstractSelectionFieldDescriptor.OptionValue> getOptionValues(WorkerApiClient workerApiClient, TokenService tokenService) {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        optionValues.add(this.getFirstElementInList());
        try {
            String accessToken = tokenService.getToken();
            ApiResponse apiResponse = this.getResource(workerApiClient, accessToken);
            optionValues.addAll(this.extractOptionValues(apiResponse));
        }
        catch (AccessTokenProviderException | IOException e) {
            LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.GET_APPLICATIONS_ERROR, e);
        }
        return optionValues;
    }

    protected AbstractSelectionFieldDescriptor.OptionValue getFirstElementInList() {
        return SelectFieldDescriptor.SELECT_ONE;
    }

    abstract List<AbstractSelectionFieldDescriptor.OptionValue> extractOptionValues(ApiResponse var1);

    abstract ApiResponse getResource(WorkerApiClient var1, String var2) throws IOException;

    abstract String getFieldName();
}

