/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.config;

import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.model.ApiResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ApplicationsResponse;
import com.pingidentity.adapters.pingone.mfa.config.ApiHelper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;

public class ApplicationsHelper
extends ApiHelper {
    private static final String CACHE_KEY_PREFIX = "applications.";

    public ApplicationsHelper() {
        super(CACHE_KEY_PREFIX);
    }

    @Override
    List<AbstractSelectionFieldDescriptor.OptionValue> extractOptionValues(ApiResponse applicationsResponse) {
        return ((ApplicationsResponse)applicationsResponse).getEmbeddedResources().getApplications().stream().filter(it -> !"worker".equalsIgnoreCase(it.getType()) && !"ping_one_admin_console".equalsIgnoreCase(it.getType()) && !"ping_one_self_service".equalsIgnoreCase(it.getType()) && !"ping_one_portal".equalsIgnoreCase(it.getType())).map(it -> new AbstractSelectionFieldDescriptor.OptionValue(it.getName(), it.getId())).collect(Collectors.toList());
    }

    @Override
    ApplicationsResponse getResource(WorkerApiClient workerApiClient, String accessToken) throws IOException {
        return workerApiClient.getApplications(accessToken);
    }

    @Override
    String getFieldName() {
        return "Application";
    }
}

