/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.config;

import com.pingidentity.adapters.pingone.mfa.PingOneMfaIdpAdapterLogEvent;
import com.pingidentity.adapters.pingone.mfa.api.client.PingOneClientsFactory;
import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.model.response.PopulationsResponse;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.exception.ApiResponseException;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import java.io.IOException;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;

public class GetPopulationsAction
implements ActionDescriptor.Action {
    private static final IntegrationsLogger LOG = new IntegrationsLogger(GetPopulationsAction.class);
    private static final String AVAILABLE_POPULATIONS = "The following populations are available: \n\n%s";
    private static final String STATUS_LINE_MESSAGE = "PingOne returned HTTP status %s %s. ";
    private static final String UNABLE_TO_GET_POPULATIONS = "Unable to get populations. ";
    private static final String CHECK_CONFIGURATION_MESSAGE = "Please check your PingOne connection.";
    private static final String LEGACY_CHECK_CONFIGURATION_MESSAGE = "Please check the values of the 'Environment ID', 'PingFederate Connection Client ID', 'PingFederate Connection Client Secret', and 'Region' fields.";

    public String actionInvoked(Configuration configuration) {
        Object result;
        PingOneClientsFactory clientsFactory = new PingOneClientsFactory(configuration);
        WorkerApiClient workerApiClient = clientsFactory.getWorkerApiClient();
        TokenService tokenService = clientsFactory.getTokenServiceClient();
        try {
            String accessToken = tokenService.getToken();
            PopulationsResponse populationsResponse = workerApiClient.getPopulations(accessToken);
            StringBuilder populations = new StringBuilder();
            populationsResponse.getEmbeddedResources().getPopulations().forEach(it -> populations.append("\"").append(it.getName()).append("\"").append(" - ").append("\"").append(it.getId()).append("\"\n"));
            result = String.format(AVAILABLE_POPULATIONS, populations.toString());
        }
        catch (AccessTokenProviderException | IOException e) {
            LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.GET_POPULATIONS_ACTION_FAILURE, e);
            result = UNABLE_TO_GET_POPULATIONS;
            ApiResponseException apiResponseException = null;
            if (e instanceof ApiResponseException) {
                apiResponseException = (ApiResponseException)e;
            } else if (e.getCause() instanceof ApiResponseException) {
                apiResponseException = (ApiResponseException)e.getCause();
            }
            if (apiResponseException != null) {
                int statusCode = apiResponseException.getStatusCode();
                String reasonPhrase = apiResponseException.getMessage();
                result = (String)result + String.format(STATUS_LINE_MESSAGE, statusCode, reasonPhrase);
            }
            result = PingOneMfaAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration) ? (String)result + CHECK_CONFIGURATION_MESSAGE : (String)result + LEGACY_CHECK_CONFIGURATION_MESSAGE;
        }
        return result;
    }
}

