/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.config;

import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.model.ApiResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.DeviceAuthenticationPolicy;
import com.pingidentity.adapters.pingone.mfa.api.model.response.DeviceAuthenticationPolicyResponse;
import com.pingidentity.adapters.pingone.mfa.config.ApiHelper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;

public class MfaPolicyForRegistrationHelper
extends ApiHelper {
    private static final String CACHE_KEY_PREFIX = "mfapolicyforregistration.";

    public MfaPolicyForRegistrationHelper() {
        super(CACHE_KEY_PREFIX);
    }

    @Override
    protected AbstractSelectionFieldDescriptor.OptionValue getFirstElementInList() {
        return new AbstractSelectionFieldDescriptor.OptionValue("Default", "");
    }

    @Override
    List<AbstractSelectionFieldDescriptor.OptionValue> extractOptionValues(ApiResponse apiResponse) {
        List<DeviceAuthenticationPolicy> mfaPolicies = ((DeviceAuthenticationPolicyResponse)apiResponse).getMfaPolicies();
        return mfaPolicies.stream().map(it -> new AbstractSelectionFieldDescriptor.OptionValue(it.getName(), it.getName())).collect(Collectors.toList());
    }

    @Override
    DeviceAuthenticationPolicyResponse getResource(WorkerApiClient workerApiClient, String accessToken) throws IOException {
        return workerApiClient.getDeviceAuthenticationPoliciesResponse(accessToken);
    }

    @Override
    String getFieldName() {
        return "MFA policy for registration";
    }
}

