/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.pingidsdk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.adapters.pingone.mfa.pingidsdk.DynamicData;
import com.pingidentity.adapters.pingone.mfa.pingidsdk.PingIDSdkAdapterInfo;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.gson.JsonObject;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.codec.binary.Base64;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.Log;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class DynamicDataUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String IN_PARAMETER_NAME_SIGNED_REQUEST_CLAIMS = "com.pingidentity.adapter.input.parameter.signed.request.claims";
    private static final String IN_PARAMETER_NAME_CHAINED_ATTRIBUTES = "com.pingidentity.adapter.input.parameter.chained.attributes";
    private static final String IN_PARAMETER_NAME_TRACKED_HTTP_REQUEST_PARAMS = "com.pingidentity.adapter.tracked.http.request.params";
    private static final String DYNAMIC_DATA_KEY = "pingIdSdkData";
    private static final String OLD_PAYLOAD_PARAM = "payload";
    private static final String PAYLOAD_PARAM = "pingIdSdkPayload";
    private static final Log logger = LogFactory.getLog(DynamicDataUtils.class);
    private static final List<String> dynamicDataAttributes = new ArrayList<String>();

    public static boolean handleAndStoreDynamicData(PingIDSdkAdapterInfo adapterInfo) throws Exception {
        String dynamicData = null;
        try {
            dynamicData = DynamicDataUtils.getDynamicData(adapterInfo);
        }
        catch (Exception fetchDynamicDataException) {
            logger.error(String.format("An exception occured while trying to parse the request object: %s", fetchDynamicDataException.getMessage()));
            logger.debug(String.format("An exception occured while trying to parse the request object: %s", fetchDynamicDataException.getMessage()), fetchDynamicDataException);
            throw fetchDynamicDataException;
        }
        if (StringUtils.isBlank(dynamicData)) {
            logger.debug("There is no dynamic data in the incoming request (pingIdSdkData query parameter does not exist or empty)");
            DynamicDataUtils.setPayloadInSessionIfExists(adapterInfo, null);
            return true;
        }
        String decodedJson = null;
        try {
            decodedJson = Base64.isBase64(dynamicData) ? new String(java.util.Base64.getDecoder().decode(dynamicData.getBytes())) : dynamicData;
        }
        catch (Exception e) {
            logger.debug(String.format("Fail to decode the incoming pingid sdk data. The pingIdSdkData query parameter must be Base64 encoded. pingIdSdkData=%s", dynamicData));
            return false;
        }
        DynamicData dynamicDataObj = null;
        try {
            dynamicDataObj = objectMapper.readValue(decodedJson, DynamicData.class);
            adapterInfo.getStateSupport().setPidSdkDynamicData(dynamicDataObj);
        }
        catch (IOException e) {
            logger.debug(String.format("Fail to parse the incoming pingid sdk data. The pingIdSdkData query parameter is invalid. Read the documentation for further details. pingIdSdkData=%s", dynamicData));
            return false;
        }
        DynamicDataUtils.setPayloadInSessionIfExists(adapterInfo, dynamicDataObj);
        logger.debug(String.format("The pingIdSdkData parameter exists. pingIdSdkData=%s", decodedJson));
        return true;
    }

    private static void setPayloadInSessionIfExists(PingIDSdkAdapterInfo adapterInfo, DynamicData dynamicData) {
        if (adapterInfo.getInParameters() == null) {
            return;
        }
        Map trackedParameters = (Map)adapterInfo.getInParameters().get(IN_PARAMETER_NAME_TRACKED_HTTP_REQUEST_PARAMS);
        if (trackedParameters == null) {
            DynamicDataUtils.setPayloadInSessionFromDynamicData(adapterInfo, dynamicData);
            return;
        }
        Collection payload = (Collection)trackedParameters.get(PAYLOAD_PARAM);
        if (payload == null) {
            payload = (Collection)trackedParameters.get(OLD_PAYLOAD_PARAM);
        }
        if (payload != null && !payload.isEmpty()) {
            String payloadValue = (String)payload.iterator().next();
            logger.debug("The payload exists as a tracked parameter");
            adapterInfo.getStateSupport().setPidSdkPayload(payloadValue);
            return;
        }
        DynamicDataUtils.setPayloadInSessionFromDynamicData(adapterInfo, dynamicData);
    }

    protected static void setPayloadInSessionFromDynamicData(PingIDSdkAdapterInfo adapterInfo, DynamicData dynamicData) {
        if (dynamicData != null && StringUtils.isNotBlank(dynamicData.getPingIdSdkPayload())) {
            logger.debug("The payload exists in the dynamic data");
            adapterInfo.getStateSupport().setPidSdkPayload(dynamicData.getPingIdSdkPayload());
        }
    }

    private static boolean dynamicDataExistsAsJson(PingIDSdkAdapterInfo adapterInfo, String inParametersKey) {
        if (adapterInfo.getInParameters() == null) {
            return false;
        }
        Map parameters = (Map)adapterInfo.getInParameters().get(inParametersKey);
        if (parameters == null) {
            return false;
        }
        return parameters.containsKey(DYNAMIC_DATA_KEY);
    }

    private static boolean dynamicDataExistsAsAttributes(PingIDSdkAdapterInfo adapterInfo, String inParametersKey) {
        if (adapterInfo.getInParameters() == null) {
            return false;
        }
        Map parameters = (Map)adapterInfo.getInParameters().get(inParametersKey);
        if (parameters == null) {
            return false;
        }
        for (String dynamicDataAttribute : dynamicDataAttributes) {
            if (!parameters.containsKey(dynamicDataAttribute)) continue;
            return true;
        }
        return false;
    }

    private static String createDynamicDataJsonFromChainedAttributes(PingIDSdkAdapterInfo adapterInfo) {
        Map parameters = (Map)adapterInfo.getInParameters().get(IN_PARAMETER_NAME_CHAINED_ATTRIBUTES);
        JsonObject jsonObject = new JsonObject();
        for (String dynamicDataAttribute : dynamicDataAttributes) {
            if (!parameters.containsKey(dynamicDataAttribute)) continue;
            AttributeValue attributeValue = (AttributeValue)parameters.get(dynamicDataAttribute);
            jsonObject.addProperty(dynamicDataAttribute, attributeValue.getValue());
        }
        return jsonObject.toString();
    }

    private static String createDynamicDataJsonFromRequestClaims(PingIDSdkAdapterInfo adapterInfo) {
        Map parameters = (Map)adapterInfo.getInParameters().get(IN_PARAMETER_NAME_SIGNED_REQUEST_CLAIMS);
        JsonObject jsonObject = new JsonObject();
        for (String dynamicDataAttribute : dynamicDataAttributes) {
            Object attributeValue;
            if (!parameters.containsKey(dynamicDataAttribute) || (attributeValue = parameters.get(dynamicDataAttribute)) == null) continue;
            jsonObject.addProperty(dynamicDataAttribute, attributeValue.toString());
        }
        return jsonObject.toString();
    }

    private static String getDynamicData(PingIDSdkAdapterInfo adapterInfo) {
        boolean dynamicDataExistsAsJsonInChainedAttributes = DynamicDataUtils.dynamicDataExistsAsJson(adapterInfo, IN_PARAMETER_NAME_CHAINED_ATTRIBUTES);
        if (dynamicDataExistsAsJsonInChainedAttributes) {
            AttributeValue attributeValue = (AttributeValue)((Map)adapterInfo.getInParameters().get(IN_PARAMETER_NAME_CHAINED_ATTRIBUTES)).get(DYNAMIC_DATA_KEY);
            String dynamicData = attributeValue.getValue();
            logger.debug(String.format("The PingID SDK data was constructed from a Json. This Json was passed from previous adapter. The Json is:%s", dynamicData));
            return dynamicData;
        }
        boolean dynamicDataExistsAsAttributesInChainedAttributes = DynamicDataUtils.dynamicDataExistsAsAttributes(adapterInfo, IN_PARAMETER_NAME_CHAINED_ATTRIBUTES);
        if (dynamicDataExistsAsAttributesInChainedAttributes) {
            String dynamicData = DynamicDataUtils.createDynamicDataJsonFromChainedAttributes(adapterInfo);
            logger.debug(String.format("The PingID SDK data was constructed from attributes passed from previous adapter. The attributes are:%s", dynamicData));
            return dynamicData;
        }
        boolean dynamicDataExistsAsJsonInRequestClaims = DynamicDataUtils.dynamicDataExistsAsJson(adapterInfo, IN_PARAMETER_NAME_SIGNED_REQUEST_CLAIMS);
        if (dynamicDataExistsAsJsonInRequestClaims) {
            String dynamicData = (String)((Map)adapterInfo.getInParameters().get(IN_PARAMETER_NAME_SIGNED_REQUEST_CLAIMS)).get(DYNAMIC_DATA_KEY);
            logger.debug(String.format("The PingID SDK data was constructed from a Json. This Json was passed in the request object claims. The Json is:%s", dynamicData));
            return dynamicData;
        }
        boolean dynamicDataExistsAsAttriburtesInRequestClaims = DynamicDataUtils.dynamicDataExistsAsAttributes(adapterInfo, IN_PARAMETER_NAME_SIGNED_REQUEST_CLAIMS);
        if (dynamicDataExistsAsAttriburtesInRequestClaims) {
            String dynamicData = DynamicDataUtils.createDynamicDataJsonFromRequestClaims(adapterInfo);
            logger.debug(String.format("The PingID SDK data was constructed from the request object claims. The claims are:%s", dynamicData));
            return dynamicData;
        }
        return null;
    }

    static {
        dynamicDataAttributes.add("pingIdSdkClientContext");
        dynamicDataAttributes.add(PAYLOAD_PARAM);
        dynamicDataAttributes.add("pingIdSdkAdapterContext");
        dynamicDataAttributes.add("pingIdSdkSkipSuccessScreens");
        dynamicDataAttributes.add("pingIdSdkSkipErrorScreens");
        dynamicDataAttributes.add("pingIdSdkSkipTimeoutScreens");
        dynamicDataAttributes.add("pingoneMfaAdapterContext");
        dynamicDataAttributes.add("pingoneMfaSkipSuccessScreens");
        dynamicDataAttributes.add("pingoneMfaSkipErrorScreens");
        dynamicDataAttributes.add("pingoneMfaSkipTimeoutScreens");
    }
}

