/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.AbstractHttpEntity;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.ContentType;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.util.Args;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class InternalFileEntity
extends AbstractHttpEntity
implements Cloneable {
    private final File file;

    public InternalFileEntity(File file, ContentType contentType) {
        this.file = Args.notNull(file, "File");
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public InputStream getContent() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        Args.notNull(outStream, "Output stream");
        FileInputStream inStream = new FileInputStream(this.file);
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)inStream).read(tmp)) != -1) {
                outStream.write(tmp, 0, l);
            }
            outStream.flush();
        }
        finally {
            ((InputStream)inStream).close();
        }
    }

    @Override
    public boolean isStreaming() {
        return false;
    }
}

