/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpEntity;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpResponse;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.StatusLine;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.ClientProtocolException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.HttpResponseException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.ResponseHandler;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent.Content;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.fluent.ContentResponseHandler;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.ByteArrayEntity;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.ContentType;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.util.EntityUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Response {
    private final HttpResponse response;
    private boolean consumed;

    Response(HttpResponse response) {
        this.response = response;
    }

    private void assertNotConsumed() {
        if (this.consumed) {
            throw new IllegalStateException("Response content has been already consumed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        if (this.consumed) {
            return;
        }
        try {
            HttpEntity entity = this.response.getEntity();
            InputStream content = entity.getContent();
            if (content != null) {
                content.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.consumed = true;
        }
    }

    public void discardContent() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T handleResponse(ResponseHandler<T> handler) throws ClientProtocolException, IOException {
        this.assertNotConsumed();
        try {
            T t = handler.handleResponse(this.response);
            return t;
        }
        finally {
            this.dispose();
        }
    }

    public Content returnContent() throws ClientProtocolException, IOException {
        return this.handleResponse(new ContentResponseHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse returnResponse() throws IOException {
        this.assertNotConsumed();
        try {
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(EntityUtils.toByteArray(entity));
                ContentType contentType = ContentType.getOrDefault(entity);
                byteArrayEntity.setContentType(contentType.toString());
                this.response.setEntity(byteArrayEntity);
            }
            HttpResponse httpResponse = this.response;
            return httpResponse;
        }
        finally {
            this.consumed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContent(File file) throws IOException {
        this.assertNotConsumed();
        StatusLine statusLine = this.response.getStatusLine();
        if (statusLine.getStatusCode() >= 300) {
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                entity.writeTo(out);
            }
        }
        finally {
            this.consumed = true;
            out.close();
        }
    }
}

