/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.app;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.util.ClassUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldMethodizer {
    private Map<String, Field> fieldHash = new HashMap<String, Field>();
    private Logger logger = LoggerFactory.getLogger(FieldMethodizer.class);

    public FieldMethodizer() {
    }

    public FieldMethodizer(String s) {
        try {
            this.addObject(s);
        }
        catch (Exception e) {
            this.logger.error("[FieldMethodizer] Could not add {} for field methodizing", (Object)s, (Object)e);
        }
    }

    public FieldMethodizer(Object o) {
        try {
            this.addObject(o);
        }
        catch (Exception e) {
            this.logger.error("[FieldMethodizer] Could not add {} for field methodizing", o, (Object)e);
        }
    }

    public void addObject(String s) throws Exception {
        this.inspect(ClassUtils.getClass(s));
    }

    public void addObject(Object o) throws Exception {
        this.inspect(o.getClass());
    }

    public Object get(String fieldName) {
        Object value = null;
        try {
            Field f = this.fieldHash.get(fieldName);
            if (f != null) {
                value = f.get(null);
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("IllegalAccessException while trying to access " + fieldName + ": " + e.getMessage());
        }
        return value;
    }

    private void inspect(Class<?> clas) {
        Field[] fields;
        for (Field field : fields = clas.getFields()) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            this.fieldHash.put(field.getName(), field);
        }
    }
}

