/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.template;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.adapters.pingone.mfa.PingOneMfaIdpAdapterLogEvent;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDeviceInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDevicesInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AuthSession;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AuthenticationCodesResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Notification;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.OfflineDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.TOTPDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.PublicKeyCredentialRequestOptions;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.WebAuthnDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.Device;
import com.pingidentity.adapters.pingone.mfa.authn.api.DevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.OfflineDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.StateSpec;
import com.pingidentity.adapters.pingone.mfa.exception.InvalidActionException;
import com.pingidentity.adapters.pingone.mfa.pingidsdk.DynamicData;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.template.TemplateParameter;
import com.pingidentity.adapters.pingone.mfa.util.ErrorResponseUtil;
import com.pingidentity.adapters.pingone.mfa.util.LanguagePackMessagesSupport;
import com.pingidentity.adapters.pingone.mfa.util.ObjectMappers;
import com.pingidentity.adapters.pingone.mfa.util.PingOneMfaStateSupport;
import com.pingidentity.adapters.pingone.mfa.util.PollingRequestResponse;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.ResourceRef;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.template.TemplateRendererUtil;
import com.pingidentity.sdk.template.TemplateRendererUtilException;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PingOneMfaTemplateSupport {
    private static final String AUTHENTICATION_CODE_RESPONSE_REQUIRED_TEMPLATE_SUFFIX = "-authentication-code-response-required.html";
    private static final String ONE_TIME_DEVICE_SELECTION_TEMPLATE_SUFFIX = "-one-time-device-selection.html";
    private static final String DEVICE_SELECTION_TEMPLATE_SUFFIX = "-device-selection.html";
    private static final String OTP_REQUIRED_TEMPLATE_SUFFIX = "-otp-required.html";
    private static final String ASSERTION_REQUIRED_TEMPLATE_SUFFIX = "-assertion-required.html";
    private static final String PUSH_CONFIRMATION_WAITING_TEMPLATE_SUFFIX = "-push-confirmation-waiting.html";
    private static final String PUSH_CONFIRMATION_TIMED_OUT_TEMPLATE_SUFFIX = "-push-confirmation-timed-out.html";
    private static final String PUSH_CONFIRMATION_REJECTED_TEMPLATE_SUFFIX = "-push-confirmation-rejected.html";
    private static final String MFA_COMPLETED_TEMPLATE_SUFFIX = "-completed.html";
    private static final String MFA_FAILED_TEMPLATE_SUFFIX = "-failed.html";
    private static final String DEVICE_PAIRING_METHOD_FAILED_TEMPLATE_SUFFIX = "-device-pairing-method-failed.html";
    private static final String MFA_SETUP_TEMPLATE_SUFFIX = "-setup.html";
    private static final String DEVICE_PAIRING_TEMPLATE_SUFFIX = "-device-pairing.html";
    private static final String UPDATE_NICKNAME_TEMPLATE_SUFFIX = "-update-nickname.html";
    private static final String OFFLINE_DEVICE_PAIRING_TEMPLATE_SUFFIX = "-offline-device-pairing.html";
    private static final String OFFLINE_DEVICE_ACTIVATION_TEMPLATE_SUFFIX = "-offline-device-activation.html";
    private static final String TOTP_DEVICE_ACTIVATION_TEMPLATE_SUFFIX = "-totp-device-activation.html";
    private static final String FIDO2_DEVICE_ACTIVATION_TEMPLATE_SUFFIX = "-fido2-device-activation.html";
    private static final String MOBILE_ACTIVATION_TEMPLATE_SUFFIX = "-mobile-activation.html";
    private static final String DEVICE_LOCKED_TEMPLATE_SUFFIX = "-device-locked.html";
    private final boolean changeDeviceAllowed;
    private final boolean allowSkipMfa;
    private final LanguagePackMessagesSupport languagePackMessagesSupport;
    public String authenticationCodeResponseRequiredTemplate;
    public String oneTimeDeviceSelectionRequiredTemplate;
    public String deviceSelectionTemplate;
    public String otpRequiredTemplate;
    public String assertionRequiredTemplate;
    public String pushConfirmationWaitingTemplate;
    public String pushConfirmationTimedOutTemplate;
    public String pushConfirmationRejectedTemplate;
    public String mfaCompletedTemplate;
    public String mfaFailedTemplate;
    public String devicePairingMethodFailedTemplate;
    public String mfaSetupTemplate;
    public String devicePairingTemplate;
    public String updateNickNameTemplate;
    public String offlineDevicePairingTemplate;
    public String offlineDeviceActivationTemplate;
    public String totpDeviceActivationTemplate;
    public String fido2DeviceActivationTemplate;
    public String mobileActivationTemplate;
    public boolean allowOnlyPredefineValuesForPhoneOrEmailDevices;
    public String deviceLockedTemplate;
    private static final IntegrationsLogger LOG = new IntegrationsLogger(PingOneMfaTemplateSupport.class);
    private static final Map<String, List<String>> TEMPLATE_ACTION_STATE_MAPPING = new HashMap<String, List<String>>();

    public PingOneMfaTemplateSupport(boolean changeDeviceAllowed, String htmlTemplatePrefix, String messageProperties, boolean allowSkipMfa, boolean allowOnlyPredefineValuesForPhoneOrEmailDevices) {
        this.changeDeviceAllowed = changeDeviceAllowed;
        this.allowSkipMfa = allowSkipMfa;
        this.allowOnlyPredefineValuesForPhoneOrEmailDevices = allowOnlyPredefineValuesForPhoneOrEmailDevices;
        this.languagePackMessagesSupport = new LanguagePackMessagesSupport(messageProperties);
        this.authenticationCodeResponseRequiredTemplate = htmlTemplatePrefix + AUTHENTICATION_CODE_RESPONSE_REQUIRED_TEMPLATE_SUFFIX;
        this.oneTimeDeviceSelectionRequiredTemplate = htmlTemplatePrefix + ONE_TIME_DEVICE_SELECTION_TEMPLATE_SUFFIX;
        this.deviceSelectionTemplate = htmlTemplatePrefix + DEVICE_SELECTION_TEMPLATE_SUFFIX;
        this.otpRequiredTemplate = htmlTemplatePrefix + OTP_REQUIRED_TEMPLATE_SUFFIX;
        this.assertionRequiredTemplate = htmlTemplatePrefix + ASSERTION_REQUIRED_TEMPLATE_SUFFIX;
        this.pushConfirmationWaitingTemplate = htmlTemplatePrefix + PUSH_CONFIRMATION_WAITING_TEMPLATE_SUFFIX;
        this.pushConfirmationTimedOutTemplate = htmlTemplatePrefix + PUSH_CONFIRMATION_TIMED_OUT_TEMPLATE_SUFFIX;
        this.pushConfirmationRejectedTemplate = htmlTemplatePrefix + PUSH_CONFIRMATION_REJECTED_TEMPLATE_SUFFIX;
        this.mfaCompletedTemplate = htmlTemplatePrefix + MFA_COMPLETED_TEMPLATE_SUFFIX;
        this.mfaFailedTemplate = htmlTemplatePrefix + MFA_FAILED_TEMPLATE_SUFFIX;
        this.devicePairingMethodFailedTemplate = htmlTemplatePrefix + DEVICE_PAIRING_METHOD_FAILED_TEMPLATE_SUFFIX;
        this.mfaSetupTemplate = htmlTemplatePrefix + MFA_SETUP_TEMPLATE_SUFFIX;
        this.devicePairingTemplate = htmlTemplatePrefix + DEVICE_PAIRING_TEMPLATE_SUFFIX;
        this.updateNickNameTemplate = htmlTemplatePrefix + UPDATE_NICKNAME_TEMPLATE_SUFFIX;
        this.offlineDevicePairingTemplate = htmlTemplatePrefix + OFFLINE_DEVICE_PAIRING_TEMPLATE_SUFFIX;
        this.offlineDeviceActivationTemplate = htmlTemplatePrefix + OFFLINE_DEVICE_ACTIVATION_TEMPLATE_SUFFIX;
        this.totpDeviceActivationTemplate = htmlTemplatePrefix + TOTP_DEVICE_ACTIVATION_TEMPLATE_SUFFIX;
        this.fido2DeviceActivationTemplate = htmlTemplatePrefix + FIDO2_DEVICE_ACTIVATION_TEMPLATE_SUFFIX;
        this.mobileActivationTemplate = htmlTemplatePrefix + MOBILE_ACTIVATION_TEMPLATE_SUFFIX;
        this.deviceLockedTemplate = htmlTemplatePrefix + DEVICE_LOCKED_TEMPLATE_SUFFIX;
    }

    public LanguagePackMessagesSupport getLanguagePackMessagesSupport() {
        return this.languagePackMessagesSupport;
    }

    private void validateRequestParams(HttpServletRequest req, String status) throws InvalidActionException {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            return;
        }
        Set params = req.getParameterMap().keySet();
        for (String param : params) {
            if (!param.equals(TemplateParameter.CONTINUE_AUTHENTICATION.toString())) continue;
            if (StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED.getStatus().equals(status) || CommonStateSpec.MFA_COMPLETED.getStatus().equals(status)) {
                return;
            }
            LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.INVALID_ACTION_PARAM_RECEIVED, param, status);
            throw new InvalidActionException(String.format(param, status));
        }
    }

    public boolean isSelectDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.SELECTED_DEVICE_ID.toString()) != null;
    }

    public boolean isSetDefaultDevice(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.DEFAULT_DEVICE_ID.toString()) != null;
    }

    public boolean isUsePasswordAuthRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        String usePasswordAuthParamValue = req.getParameter(TemplateParameter.USE_PASSWORD_AUTH.toString());
        if (StringUtils.isBlank(usePasswordAuthParamValue)) {
            return false;
        }
        return "true".equalsIgnoreCase(usePasswordAuthParamValue);
    }

    public boolean isCheckOtpRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.OTP.toString()) != null;
    }

    public boolean isCheckAssertionRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return StringUtils.isNotBlank(req.getParameter(TemplateParameter.ASSERTION.toString()));
    }

    public boolean isCancelAuthnRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return Boolean.parseBoolean(req.getParameter(TemplateParameter.CANCEL_AUTHENTICATION.toString()));
    }

    public boolean isUsernamelessCancelAuthnRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return Boolean.parseBoolean(req.getParameter(TemplateParameter.CANCEL_AUTHENTICATION.toString())) || "None".equalsIgnoreCase(req.getParameter(TemplateParameter.COMPATIBILITY.toString())) || StringUtils.isBlank(req.getParameter(TemplateParameter.SELECTED_DEVICE_ID.toString()));
    }

    public boolean isPollRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.POLL_AUTHENTICATION_STATUS.toString()) != null;
    }

    public boolean isContinueAuthenticationRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return Boolean.parseBoolean(req.getParameter(TemplateParameter.CONTINUE_AUTHENTICATION.toString()));
    }

    public boolean isUsePasscodeRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return Boolean.parseBoolean(req.getParameter(TemplateParameter.USE_PASSCODE.toString()));
    }

    public boolean isSetupMfaRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return Boolean.parseBoolean(req.getParameter(TemplateParameter.SETUP_MFA.toString()));
    }

    public boolean isRemoveDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.DELETE_DEVICE_ID.toString()) != null;
    }

    public boolean isUpdateDeviceRequest(HttpServletRequest req) {
        return req.getParameter(TemplateParameter.UPDATE_DEVICE_NICKNAME.toString()) != null;
    }

    public boolean isSkipUpdateNicknameDuringDevicePairingRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.SKIP_UPDATE_NICKNAME_DURING_DEVICE_PAIRING.toString()) != null;
    }

    public boolean isCancelRemoveDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.CANCEL_REMOVE_DEVICE.toString()) != null;
    }

    public boolean isSkipMfaRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return Boolean.parseBoolean(req.getParameter(TemplateParameter.SKIP_MFA.toString()));
    }

    public boolean isSelectDevicePairingMethodRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.SELECT_DEVICE_PAIRING_METHOD.toString()) != null;
    }

    public boolean isCancelDevicePairingRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.CANCEL_DEVICE_PAIRING.toString()) != null;
    }

    public boolean isSubmitEmailTargetRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.EMAIL.toString()) != null;
    }

    public boolean isSubmitVoiceTargetRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.VOICE_PHONE.toString()) != null;
    }

    public boolean isSubmitSmsTargetRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.SMS_PHONE.toString()) != null;
    }

    public boolean isSubmitWhatsAppTargetRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.WHATSAPP_PHONE.toString()) != null;
    }

    public boolean isActivateOfflineDeviceRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.EMAIL_ACTIVATION_OTP.toString()) != null || req.getParameter(TemplateParameter.VOICE_ACTIVATION_OTP.toString()) != null || req.getParameter(TemplateParameter.SMS_ACTIVATION_OTP.toString()) != null || req.getParameter(TemplateParameter.TOTP_ACTIVATION_OTP.toString()) != null || req.getParameter(TemplateParameter.WHATSAPP_ACTIVATION_OTP.toString()) != null;
    }

    public boolean isOneTimeDeviceAuthResendOtpRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.SELECTED_DEVICE_ID.toString()) != null;
    }

    public boolean isResendOtpRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.RESEND_OTP.toString()) != null;
    }

    public boolean isActivateWebAuthnRequest(HttpServletRequest req, String status) throws InvalidActionException {
        this.validateRequestParams(req, status);
        return req.getParameter(TemplateParameter.WEBAUTHN_DEVICE_ATTESTATION.toString()) != null;
    }

    public void renderAuthenticationCodeResponseRequiredTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthenticationCodesResponse authenticationCodesResponse) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("authenticationCode", authenticationCodesResponse.getCode());
        params.put("authenticationCodeUri", authenticationCodesResponse.getUri());
        params.put("authenticationCodeRequestId", TemplateParameter.AUTHENTICATION_CODE_REQUEST_ID.toString());
        params.put("authCodeId", authenticationCodesResponse.getId());
        params.put("pollAuthenticationStatus", TemplateParameter.POLL_AUTHENTICATION_STATUS.toString());
        params.put("retryAuthenticationCodeRequest", TemplateParameter.RETRY_AUTHENTICATION_CODE_REQUEST.toString());
        params.put("allowChangeDevice", this.changeDeviceAllowed);
        params.put("usePasscode", TemplateParameter.USE_PASSCODE.toString());
        if (authenticationCodesResponse.getUserApproval() != null) {
            params.put("userApproval", authenticationCodesResponse.getUserApproval());
        }
        if (authenticationCodesResponse.getLifeTime() != null) {
            if (authenticationCodesResponse.getLifeTime().getTimeUnit() != null) {
                params.put("timeUnit", authenticationCodesResponse.getLifeTime().getTimeUnit());
            }
            params.put("lifeTimeDuration", authenticationCodesResponse.getLifeTime().getDuration());
        }
        params.put("applicationId", authenticationCodesResponse.getApplication().getId());
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.authenticationCodeResponseRequiredTemplate, (Map)params);
    }

    public void renderOneTimeDeviceMethodSelectionTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, OneTimeDevicesInfo oneTimeDevicesInfo, ErrorResponse errorResponse) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("devices", oneTimeDevicesInfo.getDevicesWithMaskedInfoValues());
        params.put("selectedDeviceId", TemplateParameter.SELECTED_DEVICE_ID.toString());
        if (errorResponse != null) {
            String errorDetailMessage = ErrorResponseUtil.getErrorDetailMessage(errorResponse);
            String errorMessage = !errorDetailMessage.isEmpty() ? errorDetailMessage : errorResponse.getMessage();
            params.put("errorMessage", errorMessage);
        }
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.oneTimeDeviceSelectionRequiredTemplate, (Map)params);
    }

    public void renderOneTimeDeviceMethodOtpRequiredTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String errorMessageKey, OneTimeDeviceInfo selectedOneTimeDeviceInfo, OneTimeDevicesInfo oneTimeDevicesInfo, Long attemptsRemaining, int otpLength, Notification notification) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        ArrayList<Device> devices = new ArrayList<Device>();
        Device selectedDevice = selectedOneTimeDeviceInfo.getOneTimeDeviceForResponse();
        ArrayList<OneTimeDeviceInfo> deviceInfos = oneTimeDevicesInfo.getDevices();
        for (OneTimeDeviceInfo oneTimeDeviceInfo : deviceInfos) {
            devices.add(oneTimeDeviceInfo.getOneTimeDeviceForResponse());
        }
        params.put("selectedDevice", selectedDevice);
        params.put("devices", devices);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        params.put("selectedDeviceId", TemplateParameter.SELECTED_DEVICE_ID.toString());
        params.put("otp", TemplateParameter.OTP.toString());
        params.put("errorMessageKey", errorMessageKey);
        params.put("allowChangeDevice", this.changeDeviceAllowed);
        params.put("manualPairing", false);
        params.put("attemptsRemaining", Optional.ofNullable(attemptsRemaining).map(String::valueOf).orElse(null));
        params.put("otpLength", otpLength);
        if (notification != null) {
            params.put("notificationCoolDownExpiresAt", notification.getCoolDownExpiresAt());
        }
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.otpRequiredTemplate, (Map)params);
    }

    public void renderDeviceSelectionTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, List<Device> devices, String errorMessageKey, String errorMessagePlainText, boolean manualPairingPermitted, boolean isManualPairingFlow, boolean authenticationRequiredForDeviceMgmt, boolean showUsePasswordPolicyAction, boolean isDeviceMgtAllowed, boolean shouldAggregateFidoDevices) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("devices", devices);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("setupMfa", TemplateParameter.SETUP_MFA.toString());
        params.put("deleteDeviceId", TemplateParameter.DELETE_DEVICE_ID.toString());
        params.put("showUsePasswordAuth", showUsePasswordPolicyAction);
        params.put("usePasswordAuth", TemplateParameter.USE_PASSWORD_AUTH.toString());
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        params.put("defaultDeviceId", TemplateParameter.DEFAULT_DEVICE_ID.toString());
        params.put("selectedDeviceId", TemplateParameter.SELECTED_DEVICE_ID.toString());
        if (StringUtils.isNotBlank(errorMessagePlainText)) {
            params.put("errorMessage", errorMessagePlainText);
        }
        if (StringUtils.isNotBlank(errorMessageKey) && (devices.isEmpty() || devices.size() == 1)) {
            String additionalErrorMessageKey = "no.authenticator.available";
            params.put("additionalErrorMessageKey", additionalErrorMessageKey);
        }
        params.put("errorMessageKey", errorMessageKey);
        params.put("manualPairing", manualPairingPermitted);
        params.put("isManualPairingFlow", isManualPairingFlow);
        params.put("showDeviceMgtOptions", isDeviceMgtAllowed);
        params.put("isAuthenticationRequiredForDeviceMgmt", authenticationRequiredForDeviceMgmt);
        params.put("shouldAggregateFidoDevices", shouldAggregateFidoDevices);
        params.put("currentTimeInMillis", System.currentTimeMillis());
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.deviceSelectionTemplate, (Map)params);
    }

    public void renderUpdateNicknameDuringDevicePairingTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device device, String applicationName) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("device", device);
        params.put("applicationName", applicationName);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.updateNickNameTemplate, (Map)params);
    }

    public void renderOtpRequiredTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, List<Device> devices, ResourceRef selectedDeviceRef, boolean manualPairingPermitted, int otpLength) throws TemplateRendererUtilException {
        Device selectedDevice = devices.stream().filter(device -> device.getId().equals(selectedDeviceRef.getId())).findAny().orElse(null);
        this.renderOtpRequiredTemplate(req, resp, inParameters, selectedDevice, null, null, devices, manualPairingPermitted, null, otpLength);
    }

    public void renderUsernamelessFlowAssertionRequiredTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, boolean manualPairingPermitted) throws TemplateRendererUtilException {
        this.renderAssertionRequiredTemplate(req, resp, inParameters, null, null, null, publicKeyCredentialRequestOptions, manualPairingPermitted, true);
    }

    public void renderAssertionRequiredTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, List<Device> devices, ResourceRef selectedDeviceRef, PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, boolean manualPairingPermitted) throws TemplateRendererUtilException {
        Device selectedDevice = devices.stream().filter(device -> device.getId().equals(selectedDeviceRef.getId())).findAny().orElse(null);
        this.renderAssertionRequiredTemplate(req, resp, inParameters, selectedDevice, null, devices, publicKeyCredentialRequestOptions, manualPairingPermitted, false);
    }

    public void renderAssertionRequiredTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, Device selectedDevice, String errorMessageKey, List<Device> devices, PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, boolean manualPairingPermitted, boolean isUsernamesslessAuthFlow) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        if (selectedDevice != null) {
            params.put("selectedDevice", selectedDevice);
            params.put("selectedDeviceId", selectedDevice.getId());
        }
        if (devices != null) {
            params.put("devices", devices);
        }
        params.put("assertion", TemplateParameter.ASSERTION.toString());
        params.put("compatibility", TemplateParameter.COMPATIBILITY.toString());
        try {
            String publicKeyCredentialRequestOptionsValueAsString = ObjectMappers.getDefault().writeValueAsString(publicKeyCredentialRequestOptions);
            params.put("publicKeyCredentialRequestOptions", publicKeyCredentialRequestOptions);
            params.put("publicKeyCredentialRequestOptionsAsString", publicKeyCredentialRequestOptionsValueAsString);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        params.put("selectedDeviceId", TemplateParameter.SELECTED_DEVICE_ID.toString());
        params.put("errorMessageKey", errorMessageKey);
        params.put("allowChangeDevice", this.changeDeviceAllowed);
        params.put("manualPairing", manualPairingPermitted);
        params.put("isUsernamelessAuthFlow", isUsernamesslessAuthFlow);
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.assertionRequiredTemplate, (Map)params);
    }

    public void renderOtpRequiredTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, Device selectedDevice, String errorMessageKey, String errorMessagePlainText, List<Device> devices, boolean manualPairingPermitted, Long attemptsRemaining, int otpLength) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("selectedDevice", selectedDevice);
        params.put("devices", devices);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        params.put("selectedDeviceId", TemplateParameter.SELECTED_DEVICE_ID.toString());
        params.put("otp", TemplateParameter.OTP.toString());
        params.put("errorMessageKey", errorMessageKey);
        if (StringUtils.isNotBlank(errorMessagePlainText)) {
            params.put("errorMessage", errorMessagePlainText);
        }
        params.put("allowChangeDevice", this.changeDeviceAllowed);
        params.put("manualPairing", manualPairingPermitted);
        params.put("attemptsRemaining", Optional.ofNullable(attemptsRemaining).map(String::valueOf).orElse(null));
        params.put("otpLength", otpLength);
        if (selectedDevice != null) {
            params.put("notificationCoolDownExpiresAt", selectedDevice.getNotificationCoolDownExpiresAt());
        }
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.otpRequiredTemplate, (Map)params);
    }

    public void renderPushConfirmationWaitingResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, Device selectedDevice, List<Device> devices, boolean manualPairingPermitted, AuthSession.NumberMatching numberMatching) throws TemplateRendererUtilException {
        if (Boolean.parseBoolean(req.getParameter(TemplateParameter.POLL_AUTHENTICATION_STATUS.toString()))) {
            resp.setContentType("application/json");
            PollingRequestResponse pollingRequestResponse = new PollingRequestResponse("PUSH_CONFIRMATION_WAITING", true);
            try {
                String response = ObjectMappers.getDefault().writeValueAsString(pollingRequestResponse);
                resp.getWriter().write(response);
                resp.getWriter().close();
                return;
            }
            catch (IOException response) {
                // empty catch block
            }
        }
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("selectedDeviceId", TemplateParameter.SELECTED_DEVICE_ID.toString());
        params.put("selectedDevice", selectedDevice);
        params.put("devices", devices);
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        params.put("pollAuthenticationStatus", TemplateParameter.POLL_AUTHENTICATION_STATUS.toString());
        params.put("allowChangeDevice", this.changeDeviceAllowed);
        params.put("usePasscode", TemplateParameter.USE_PASSCODE.toString());
        params.put("manualPairing", manualPairingPermitted);
        params.put("numberMatching", numberMatching);
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.pushConfirmationWaitingTemplate, (Map)params);
    }

    public void renderPushConfirmationTimedOutResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, Device selectedDevice, List<Device> devices, boolean manualPairingPermitted) throws TemplateRendererUtilException {
        this.renderPushConfirmationTimedOutResponse(req, resp, inParameters, selectedDevice, devices, null, manualPairingPermitted, null);
    }

    public void renderPushConfirmationTimedOutResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, Device selectedDevice, List<Device> devices, String errorMessageKey, boolean manualPairingPermitted, Long attemptsRemaining) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("devices", devices);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("selectedDeviceId", TemplateParameter.SELECTED_DEVICE_ID.toString());
        params.put("selectedDevice", selectedDevice);
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        params.put("allowChangeDevice", this.changeDeviceAllowed);
        params.put("otp", TemplateParameter.OTP.toString());
        params.put("errorMessageKey", errorMessageKey);
        params.put("manualPairing", manualPairingPermitted);
        params.put("attemptsRemaining", Optional.ofNullable(attemptsRemaining).map(String::valueOf).orElse(null));
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.pushConfirmationTimedOutTemplate, (Map)params);
    }

    public void renderPushConfirmationRejectedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, Device selectedDevice, boolean manualPairingPermitted) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("selectedDeviceId", TemplateParameter.SELECTED_DEVICE_ID.toString());
        params.put("selectedDevice", selectedDevice);
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        params.put("allowChangeDevice", this.changeDeviceAllowed);
        params.put("manualPairing", manualPairingPermitted);
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.pushConfirmationRejectedTemplate, (Map)params);
    }

    public void renderMfaCompletedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
        if (dynamicData != null) {
            String pingoneMfaAdapterContext;
            String pingIdSdkAdapterContext = dynamicData.getPingIdSdkAdapterContext();
            if (StringUtils.isNotBlank(pingIdSdkAdapterContext)) {
                try {
                    JSONParser parser = new JSONParser();
                    JSONObject json = (JSONObject)parser.parse(pingIdSdkAdapterContext);
                    params.put("pingIdSdkAdapterContext", json);
                }
                catch (ParseException ex) {
                    params.put("pingIdSdkAdapterContext", pingIdSdkAdapterContext);
                }
            }
            if (StringUtils.isNotBlank(pingoneMfaAdapterContext = dynamicData.getPingoneMfaAdapterContext())) {
                try {
                    JSONParser parser = new JSONParser();
                    JSONObject json = (JSONObject)parser.parse(pingoneMfaAdapterContext);
                    params.put("pingoneMfaAdapterContext", json);
                }
                catch (ParseException ex) {
                    params.put("pingoneMfaAdapterContext", pingoneMfaAdapterContext);
                }
            }
        }
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("continueAuthentication", TemplateParameter.CONTINUE_AUTHENTICATION.toString());
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.mfaCompletedTemplate, (Map)params);
    }

    public void renderMfaFailedResponseWithCoolDownMessage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String titleKey, String headerKey, String errorMessage) throws TemplateRendererUtilException {
        Map<String, Object> params = this.getMfaFailedParamMap(req, inParameters, titleKey, headerKey);
        params.put("additionalErrorMessage", errorMessage);
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.mfaFailedTemplate, params);
    }

    public void renderMfaFailedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String titleKey, String headerKey, String errorMessageKey) throws TemplateRendererUtilException {
        Map<String, Object> params = this.getMfaFailedParamMap(req, inParameters, titleKey, headerKey);
        params.put("errorMessageKey", errorMessageKey);
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.mfaFailedTemplate, params);
    }

    private Map<String, Object> getMfaFailedParamMap(HttpServletRequest req, Map<String, Object> inParameters, String titleKey, String headerKey) {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        params.put("mfaFailedTitle", titleKey);
        params.put("mfaFailedHeader", headerKey);
        return params;
    }

    public void renderDevicePairingMethodFailedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String errorMessageKey, boolean manualPairingPermitted, PingOneMfaStateSupport stateSupport) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("cancelDevicePairing", TemplateParameter.CANCEL_DEVICE_PAIRING.toString());
        params.put("continueAuthentication", TemplateParameter.CONTINUE_AUTHENTICATION.toString());
        params.put("errorMessageKey", errorMessageKey);
        params.put("allowChangeDevice", this.changeDeviceAllowed);
        params.put("manualPairing", manualPairingPermitted);
        params.put("showCancelDevicePairing", false);
        if (stateSupport.getDevicePairingErrorDetail() != null) {
            params.put("showCancelDevicePairing", true);
        }
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.devicePairingMethodFailedTemplate, (Map)params);
    }

    public void renderMfaSetupTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("setupMfa", TemplateParameter.SETUP_MFA.toString());
        params.put("isAllowSkipMfa", this.allowSkipMfa);
        params.put("skipMfa", TemplateParameter.SKIP_MFA.toString());
        params.put("cancelAuthentication", TemplateParameter.CANCEL_AUTHENTICATION.toString());
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.mfaSetupTemplate, (Map)params);
    }

    public void renderDevicePairingTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, List<DevicePairingMethod> devicePairingMethods, String errorMessageKey) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("devicePairingMethods", devicePairingMethods);
        params.put("selectDevicePairingMethod", TemplateParameter.SELECT_DEVICE_PAIRING_METHOD);
        if (StringUtils.isNotBlank(errorMessageKey)) {
            params.put("errorMessageKey", errorMessageKey);
        }
        params.put("cancelDevicePairing", TemplateParameter.CANCEL_DEVICE_PAIRING);
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.devicePairingTemplate, (Map)params);
    }

    public void renderOfflinePairingTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String errorMessageKey, OfflineDevicePairingMethod pairingMethod, Long coolDownExpiresAt) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("deviceType", pairingMethod.getDeviceType());
        params.put("errorMessageKey", errorMessageKey);
        params.put("notificationCoolDownExpiresAt", coolDownExpiresAt);
        params.put("cancelDevicePairing", TemplateParameter.CANCEL_DEVICE_PAIRING);
        if (this.allowOnlyPredefineValuesForPhoneOrEmailDevices) {
            params.put("allowOnlyPredefineValuesForPhoneOrEmailDevices", pairingMethod.getMaskedAllowedValue());
        }
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.offlineDevicePairingTemplate, (Map)params);
    }

    public void renderWebAuthnDevicePairingTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, WebAuthnDevice webAuthnDevice, String errorMessageKey) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        String publicKeyCredentialCreationOptions = webAuthnDevice.getPublicKeyCredentialCreationOptions();
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("webAuthnDeviceAttestation", TemplateParameter.WEBAUTHN_DEVICE_ATTESTATION);
        params.put("device", webAuthnDevice);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("publicKeyCredentialCreationOptions", publicKeyCredentialCreationOptions);
        params.put("cancelDevicePairing", TemplateParameter.CANCEL_DEVICE_PAIRING);
        params.put("errorMessageKey", errorMessageKey);
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.fido2DeviceActivationTemplate, (Map)params);
    }

    public void renderTOTPDevicePairingTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, TOTPDevice totpDevice, String errorMessageKey, Long attemptsRemaining) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        String totpSecret = totpDevice.getSecret();
        String totpDeviceKeyUri = totpDevice.getKeyUri();
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("totpActivationOtp", TemplateParameter.TOTP_ACTIVATION_OTP);
        params.put("totpActivationSecret", totpSecret);
        params.put("totpActivationKeyUri", totpDeviceKeyUri);
        params.put("errorMessageKey", errorMessageKey);
        params.put("cancelDevicePairing", TemplateParameter.CANCEL_DEVICE_PAIRING);
        params.put("attemptsRemaining", Optional.ofNullable(attemptsRemaining).map(String::valueOf).orElse(null));
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.totpDeviceActivationTemplate, (Map)params);
    }

    public void renderOfflineActivationTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, OfflineDevice device, String errorMessageKey, Long attemptsRemaining, int otpLength) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("deviceType", device.getType());
        params.put("deviceTarget", device.getTarget());
        params.put("resendOtp", TemplateParameter.RESEND_OTP);
        params.put("errorMessageKey", errorMessageKey);
        params.put("cancelDevicePairing", TemplateParameter.CANCEL_DEVICE_PAIRING);
        params.put("attemptsRemaining", Optional.ofNullable(attemptsRemaining).map(String::valueOf).orElse(null));
        params.put("otpLength", otpLength);
        params.put("notificationCoolDownExpiresAt", device.getNotificationCoolDownExpiresAt());
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.offlineDeviceActivationTemplate, (Map)params);
    }

    public void renderMobileActivationTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String applicationName, String mobilePairingKey) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("applicationName", applicationName);
        params.put("mobilePairingKey", mobilePairingKey);
        params.put("pollAuthenticationStatus", TemplateParameter.POLL_AUTHENTICATION_STATUS.toString());
        params.put("cancelDevicePairing", TemplateParameter.CANCEL_DEVICE_PAIRING);
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.mobileActivationTemplate, (Map)params);
    }

    public void renderDeviceLockedTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String errorMessagePlainTextWithCoolDown, String errorMessageKey, boolean isChangeDeviceButton) throws TemplateRendererUtilException {
        this.renderDeviceLockedTemplateWithCoolDown(req, resp, inParameters, errorMessagePlainTextWithCoolDown, errorMessageKey, isChangeDeviceButton, null);
    }

    public void renderDeviceLockedTemplateWithCoolDown(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String errorMessagePlainTextWithCoolDown, String errorMessageKey, boolean isChangeDeviceButton, Long coolDownExpiresAt) throws TemplateRendererUtilException {
        Map params = TemplateParamUtil.populateDefaultTemplateParams(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneMfaAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("accountLockedOutErrorMessage", errorMessagePlainTextWithCoolDown);
        params.put("errorMessageKey", errorMessageKey);
        params.put("isChangeDeviceButton", String.valueOf(isChangeDeviceButton));
        params.put("notificationCoolDownExpiresAt", coolDownExpiresAt);
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.deviceLockedTemplate, (Map)params);
    }

    static {
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.DEVICE_SELECTION_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.SELECTED_DEVICE_ID.toString(), TemplateParameter.DEFAULT_DEVICE_ID.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.CANCEL_AUTHENTICATION.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString(), TemplateParameter.POLL_AUTHENTICATION_STATUS.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.ASSERTION_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.ASSERTION.toString(), TemplateParameter.COMPATIBILITY.toString(), TemplateParameter.CANCEL_AUTHENTICATION.toString(), TemplateParameter.SELECTED_DEVICE_ID.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString(), TemplateParameter.POLL_AUTHENTICATION_STATUS.toString(), TemplateParameter.CANCEL_REMOVE_DEVICE.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.OTP_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.OTP.toString(), TemplateParameter.CANCEL_AUTHENTICATION.toString(), TemplateParameter.SELECTED_DEVICE_ID.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString(), TemplateParameter.POLL_AUTHENTICATION_STATUS.toString(), TemplateParameter.CANCEL_REMOVE_DEVICE.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.PUSH_CONFIRMATION_TIMED_OUT.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.POLL_AUTHENTICATION_STATUS.toString(), TemplateParameter.OTP.toString(), TemplateParameter.SELECTED_DEVICE_ID.toString(), TemplateParameter.CANCEL_AUTHENTICATION.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.PUSH_CONFIRMATION_WAITING.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.POLL_AUTHENTICATION_STATUS.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(CommonStateSpec.MFA_COMPLETED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.CONTINUE_AUTHENTICATION.toString(), TemplateParameter.POLL_AUTHENTICATION_STATUS.toString(), TemplateParameter.SELECTED_DEVICE_ID.toString(), TemplateParameter.DELETE_DEVICE_ID.toString(), TemplateParameter.USE_PASSCODE.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.CONTINUE_AUTHENTICATION.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString(), TemplateParameter.SELECTED_DEVICE_ID.toString(), TemplateParameter.POLL_AUTHENTICATION_STATUS.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.SELECT_DEVICE_PAIRING_METHOD.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString(), TemplateParameter.SELECTED_DEVICE_ID.toString(), TemplateParameter.POLL_AUTHENTICATION_STATUS.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.EMAIL_ACTIVATION_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.RESEND_OTP.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.EMAIL_ACTIVATION_OTP.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.EMAIL_PAIRING_TARGET_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.EMAIL.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.MFA_FAILED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.CANCEL_AUTHENTICATION.toString(), TemplateParameter.POLL_AUTHENTICATION_STATUS.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.POLL_AUTHENTICATION_STATUS.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.SELECT_DEVICE_PAIRING_METHOD.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.SELECTED_DEVICE_ID.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.PLATFORM_ACTIVATION_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.PLATFORM_DEVICE_ATTESTATION.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.PUSH_CONFIRMATION_REJECTED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.CANCEL_AUTHENTICATION.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString(), TemplateParameter.SELECTED_DEVICE_ID.toString(), TemplateParameter.POLL_AUTHENTICATION_STATUS.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.SECURITY_KEY_ACTIVATION_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.SECURITY_KEY_DEVICE_ATTESTATION.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.MFA_SETUP_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.SETUP_MFA.toString(), TemplateParameter.CANCEL_AUTHENTICATION.toString(), TemplateParameter.SKIP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.SMS_ACTIVATION_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.SMS_ACTIVATION_OTP.toString(), TemplateParameter.RESEND_OTP.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.SMS_PAIRING_TARGET_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.SMS_PHONE.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.TOTP_ACTIVATION_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.TOTP_ACTIVATION_OTP.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.VOICE_ACTIVATION_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.VOICE_ACTIVATION_OTP.toString(), TemplateParameter.RESEND_OTP.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
        TEMPLATE_ACTION_STATE_MAPPING.put(StateSpec.VOICE_PAIRING_TARGET_REQUIRED.getStatus(), new ArrayList<String>(Arrays.asList(TemplateParameter.VOICE_PHONE.toString(), TemplateParameter.SETUP_MFA.toString(), TemplateParameter.CANCEL_DEVICE_PAIRING.toString(), TemplateParameter.USE_PASSWORD_AUTH.toString())));
    }
}

