/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.common.cache.Cache;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.Log;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.LogFactory;
import com.pingidentity.adapters.pingone.mfa.util.AppSecretProvider;
import java.io.IOException;

public class AppSecretCache {
    private final String cacheKeyPrefix;
    private final Cache<String, Object> cache;
    private final AppSecretProvider appSecretProvider;
    private static final Log log = LogFactory.getLog(AppSecretCache.class);

    public AppSecretCache(String cacheKeyPrefix, Cache<String, Object> cache, AppSecretProvider appSecretProvider) {
        this.cacheKeyPrefix = cacheKeyPrefix;
        this.cache = cache;
        this.appSecretProvider = appSecretProvider;
    }

    public String getAppSecret(String appId) throws AccessTokenProviderException, IOException {
        String key = this.getKey(appId);
        log.debug("Fetching app secret for appId=" + appId + ", cache key=" + key + ".");
        String appSecret = (String)this.cache.getIfPresent(key);
        if (appSecret == null) {
            log.debug("Cache miss for appId=" + appId + ". Attempting to fetch from server.");
            appSecret = this.appSecretProvider.getAppSecret(appId);
            log.debug("Fetched app secret from server for appId=" + appId + ". Storing in cache.");
            this.cache.put(key, appSecret);
        }
        return appSecret;
    }

    public synchronized void invalidateAppSecret(String appId) {
        this.cache.invalidate(this.getKey(appId));
    }

    private String getKey(String appId) {
        return this.cacheKeyPrefix + appId;
    }
}

