/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.ThreadContext;

public class AuditLogger {
    private boolean isAuditLoggingEnabled;
    private final String auditLogFormat = "%s [User agent = %s, Correlation-ID = %s]";

    public AuditLogger(boolean isAuditLoggingEnabled) {
        this.isAuditLoggingEnabled = isAuditLoggingEnabled;
    }

    public void auditLog(String messagePrefix, HttpServletRequest req) {
        if (!this.isAuditLoggingEnabled) {
            return;
        }
        String userAgent = req.getHeader("User-Agent");
        String correlationId = ThreadContext.get((String)"correlationId");
        try {
            Class<?> clazz = Class.forName("com.pingidentity.sdk.logging.LoggingUtil");
            Method method = clazz.getMethod("setDescription", String.class);
            String auditLog = String.format("%s [User agent = %s, Correlation-ID = %s]", messagePrefix, userAgent, correlationId);
            method.invoke(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), auditLog);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

