/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.adapters.pingone.mfa.authn.api.Device;
import com.pingidentity.adapters.pingone.mfa.authn.api.DevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.EmailDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.MobileDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.SmsDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.VoiceDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.WebAuthnDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.WhatsAppDevicePairingMethod;

public class DevicePairingMethods {
    public static DevicePairingMethod mobile(String name) {
        return DevicePairingMethods.mobile(null, name);
    }

    public static DevicePairingMethod mobile(String id, String name) {
        MobileDevicePairingMethod devicePairingMethod = new MobileDevicePairingMethod(Device.Type.MOBILE);
        devicePairingMethod.setApplicationId(id);
        devicePairingMethod.setApplicationName(name);
        return devicePairingMethod;
    }

    public static DevicePairingMethod getDeviceParingMethod(String type) {
        Device.Type deviceType = Device.Type.fromName(type);
        if (deviceType == null) {
            return null;
        }
        switch (deviceType) {
            case FIDO2: 
            case PLATFORM: 
            case SECURITY_KEY: {
                return new WebAuthnDevicePairingMethod(deviceType);
            }
            case SMS: {
                return new SmsDevicePairingMethod();
            }
            case VOICE: {
                return new VoiceDevicePairingMethod();
            }
            case WHATSAPP: {
                return new WhatsAppDevicePairingMethod();
            }
            case EMAIL: {
                return new EmailDevicePairingMethod();
            }
            case TOTP: {
                return new DevicePairingMethod(deviceType);
            }
        }
        return null;
    }
}

