/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorDetail;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.InnerError;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomAuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import java.util.Optional;
import java.util.function.Function;

public class ErrorResponseUtil {
    public static String getErrorDetailMessage(ErrorResponse errorResponse) {
        return ErrorResponseUtil.getErrorDetail(errorResponse, ErrorDetail::getMessage, "");
    }

    public static String getErrorDetailTarget(ErrorResponse errorResponse) {
        return ErrorResponseUtil.getErrorDetail(errorResponse, ErrorDetail::getTarget, "");
    }

    public static String getErrorDetailCode(ErrorResponse errorResponse) {
        return ErrorResponseUtil.getErrorDetail(errorResponse, ErrorDetail::getCode, "");
    }

    public static InnerError getErrorDetailInnerError(ErrorResponse errorResponse) {
        return ErrorResponseUtil.getErrorDetail(errorResponse, ErrorDetail::getInnerError, null);
    }

    public static boolean isInvalidUserError(ErrorResponse errorResponse) {
        boolean isInvalidUserError = false;
        String code = errorResponse.getCode();
        if ("INVALID_REQUEST".equals(code)) {
            String errorDetailCode = errorResponse.getErrorDetailCode();
            String errorDetailTarget = ErrorResponseUtil.getErrorDetailTarget(errorResponse);
            if (errorDetailCode.equals("INVALID_PARAMETER") && errorDetailTarget.equals("login_hint_token")) {
                isInvalidUserError = true;
            }
        }
        return isInvalidUserError;
    }

    public static AuthnError transformPingOneErrorToPingFedErrorResponse(Integer statusCode, ErrorResponse errorResponse) {
        AuthnErrorDetail authnErrorDetail = new AuthnErrorDetail.Builder().code(ErrorResponseUtil.getErrorDetailCode(errorResponse)).message(ErrorResponseUtil.getErrorDetailMessage(errorResponse)).build();
        CustomAuthnErrorDetail customAuthnErrorDetail = new CustomAuthnErrorDetail(authnErrorDetail);
        customAuthnErrorDetail.setInnerError(ErrorResponseUtil.getErrorDetailInnerError(errorResponse));
        return new AuthnError.Builder().httpStatus(statusCode.intValue()).code(errorResponse.getCode()).message(errorResponse.getMessage()).detail((AuthnErrorDetail)customAuthnErrorDetail).build();
    }

    public static boolean isInvalidOrExpiredOtp(ErrorResponse errorResponse) {
        String errorDetailCode = errorResponse.getErrorDetailCode();
        return "INVALID_DATA".equals(errorResponse.getCode()) && ("INVALID_OTP".equals(errorDetailCode) || "INVALID_VALUE".equals(errorDetailCode)) && "otp".equals(ErrorResponseUtil.getErrorDetailTarget(errorResponse));
    }

    public static String getBadOtpErrorMessageKey(ErrorResponse errorResponse) {
        return "INVALID_OTP".equals(errorResponse.getErrorDetailCode()) ? "invalid.otp" : "expired.otp";
    }

    public static <T> T getErrorDetail(ErrorResponse errorResponse, Function<ErrorDetail, T> mapper, T defaultValue) {
        return (T)Optional.ofNullable(errorResponse).map(ErrorResponse::getDetails).filter(details -> !details.isEmpty()).map(details -> mapper.apply((ErrorDetail)details.get(0))).orElse(defaultValue);
    }
}

