/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.adapters.pingone.mfa.api.model.response.UserDevicesEmbeddedResource;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.DeviceTypeDisplayNameInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.EmailDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.MobileDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Notification;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Os;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.SmsDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.TOTPDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.VoiceDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.WhatsAppDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.FIDO2Device;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.PlatformDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.SecurityKeyDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.Device;
import com.pingidentity.adapters.pingone.mfa.authn.api.DevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.Lock;
import com.pingidentity.adapters.pingone.mfa.authn.api.WebAuthnDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.util.DevicePairingMethods;
import com.pingidentity.sdk.api.authn.model.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ModelMapperUtil {
    public static com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device pingOneDevice(String id) {
        return new com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device(id);
    }

    public static Device map(com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device pingOneDevice) {
        Device pfDevice = new Device();
        String type = null;
        String target = null;
        Notification notification = null;
        if (EmailDevice.TYPE.equals(pingOneDevice.getType())) {
            type = Device.Type.EMAIL.getName();
            target = ((EmailDevice)pingOneDevice).getEmail();
            notification = ((EmailDevice)pingOneDevice).getNotification();
        } else if (SmsDevice.TYPE.equals(pingOneDevice.getType())) {
            type = Device.Type.SMS.getName();
            target = ((SmsDevice)pingOneDevice).getPhone();
            notification = ((SmsDevice)pingOneDevice).getNotification();
        } else if (MobileDevice.TYPE.equals(pingOneDevice.getType())) {
            MobileDevice mobileDevice = (MobileDevice)pingOneDevice;
            if (Os.Type.ANDROID.name().equals(mobileDevice.getOs().getType())) {
                type = Device.Type.ANDROID.getName();
            } else if (Os.Type.IOS.name().equals(mobileDevice.getOs().getType())) {
                type = Device.Type.IPHONE.getName();
            }
            pfDevice.setName(mobileDevice.getModel().getMarketingName());
            pfDevice.setApplicationId(mobileDevice.getApplication().getId());
            pfDevice.setApplicationVersion(mobileDevice.getApplication().getVersion());
            pfDevice.setOsVersion(mobileDevice.getOs().getVersion());
            pfDevice.setPushEnabled(mobileDevice.isPushEnabled());
            pfDevice.setOtpEnabled(mobileDevice.isOtpEnabled());
            Optional.ofNullable(mobileDevice.getApplication()).ifPresent(application -> pfDevice.setApplicationName(application.getName()));
        } else if (TOTPDevice.TYPE.equals(pingOneDevice.getType())) {
            type = Device.Type.TOTP.getName();
        } else if (PlatformDevice.TYPE.equals(pingOneDevice.getType())) {
            type = Device.Type.PLATFORM.getName();
            target = ((PlatformDevice)pingOneDevice).getPlatform();
            pfDevice.setRpId(((PlatformDevice)pingOneDevice).getRp().getId());
        } else if (SecurityKeyDevice.TYPE.equals(pingOneDevice.getType())) {
            type = Device.Type.SECURITY_KEY.getName();
            target = pingOneDevice.getType();
            pfDevice.setRpId(((SecurityKeyDevice)pingOneDevice).getRp().getId());
        } else if (FIDO2Device.TYPE.equals(pingOneDevice.getType())) {
            if (pingOneDevice.getAttributes() != null && pingOneDevice.getAttributes().get("previousDeviceType") != null) {
                type = String.valueOf(pingOneDevice.getAttributes().get("previousDeviceType"));
                target = "";
            } else {
                type = Device.Type.FIDO2.getName();
                pfDevice.setName(((FIDO2Device)pingOneDevice).getDefaultDisplayName());
            }
            pfDevice.setRpId(((FIDO2Device)pingOneDevice).getRp().getId());
        } else if (VoiceDevice.TYPE.equals(pingOneDevice.getType())) {
            type = Device.Type.VOICE.getName();
            target = ((VoiceDevice)pingOneDevice).getPhone();
            notification = ((VoiceDevice)pingOneDevice).getNotification();
        } else if (WhatsAppDevice.TYPE.equals(pingOneDevice.getType())) {
            type = Device.Type.WHATSAPP.getName();
            target = ((WhatsAppDevice)pingOneDevice).getPhone();
            notification = ((WhatsAppDevice)pingOneDevice).getNotification();
        }
        pfDevice.setId(pingOneDevice.getId());
        pfDevice.setType(type);
        pfDevice.setTarget(target);
        pfDevice.setUsable(pingOneDevice.isUsable());
        pfDevice.setNickname(pingOneDevice.getNickname());
        pfDevice.setNotification(notification);
        Optional.ofNullable(pingOneDevice.getCoolDownExpiresAt()).filter(expiresAt -> expiresAt > System.currentTimeMillis()).ifPresent(expiresAt -> pfDevice.setLock(new Lock(Lock.LockStatus.LOCKED, (Long)expiresAt)));
        return pfDevice;
    }

    public static List<Device> map(List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> devices) {
        return devices.stream().map(ModelMapperUtil::map).collect(Collectors.toList());
    }

    public static User map(String username) {
        User pfUser = new User();
        pfUser.setUsername(username);
        return pfUser;
    }

    public static User map(com.pingidentity.adapters.pingone.mfa.api.model.users.User pingOneUser) {
        User pfUser = new User();
        pfUser.setUsername(pingOneUser.getUsername());
        pfUser.setId(pingOneUser.getId());
        return pfUser;
    }

    public static List<DevicePairingMethod> mapAllowedMethodsTypes(UserDevicesEmbeddedResource embeddedResources) {
        ArrayList<DevicePairingMethod> devicePairingMethods = new ArrayList<DevicePairingMethod>();
        for (String pairingMethodType : embeddedResources.getAllowedTypes()) {
            DevicePairingMethod pairingMethod;
            if (Device.Type.MOBILE.getName().equals(pairingMethodType) || (pairingMethod = DevicePairingMethods.getDeviceParingMethod(pairingMethodType)) == null) continue;
            if (Device.Type.FIDO2.getName().equalsIgnoreCase(pairingMethod.getDeviceType())) {
                Optional<DeviceTypeDisplayNameInfo> displayNameInfo = embeddedResources.getTypeDisplayNameInfo().stream().filter(deviceTypeDisplayNameInfo -> Device.Type.FIDO2.getName().equalsIgnoreCase(deviceTypeDisplayNameInfo.getType())).findFirst();
                displayNameInfo.ifPresent(deviceTypeDisplayNameInfo -> ((WebAuthnDevicePairingMethod)pairingMethod).setDisplayNameKey(deviceTypeDisplayNameInfo.getDisplayNameKey()));
            }
            devicePairingMethods.add(pairingMethod);
        }
        embeddedResources.getApplications().forEach(application -> {
            if (application.isMobileApp()) {
                DevicePairingMethod pairingMethod = DevicePairingMethods.mobile(application.getId(), application.getName());
                devicePairingMethods.add(pairingMethod);
            }
        });
        return devicePairingMethods;
    }

    public static String getMaskedEmail(String email) {
        Object maskedTarget = "";
        if (email != null && email.contains("@")) {
            String prefix = email.substring(0, email.lastIndexOf("@"));
            maskedTarget = prefix.length() == 1 ? "*" + email.substring(email.lastIndexOf("@")) : (prefix.length() == 2 ? prefix.substring(0, 1) + "****" + email.substring(email.lastIndexOf("@")) : prefix.substring(0, 2) + "****" + email.substring(email.lastIndexOf("@")));
            return maskedTarget;
        }
        return email;
    }

    public static String getMaskedPhoneNumber(String phone) {
        if (phone != null && phone.length() > 2) {
            String maskedTarget = "*******" + phone.substring(phone.length() - 2);
            return maskedTarget;
        }
        return phone;
    }
}

