/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.Header;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpResponse;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.message.BasicNameValuePair;
import java.util.Arrays;
import java.util.Optional;

public class SessionTokenUtil {
    public static Optional<String> getSessionToken(HttpResponse response) {
        Optional<Header> stCookieHeader;
        Header[] headers = response.getAllHeaders();
        if (headers != null && (stCookieHeader = Arrays.stream(headers).filter(header -> "Set-Cookie".equals(header.getName()) && SessionTokenUtil.isSessionTokenCookie(header.getValue())).findFirst()).isPresent()) {
            String rawStCookie = stCookieHeader.get().getValue();
            return Arrays.stream(rawStCookie.split(";\\s")).map(nameValuePair -> {
                String[] pair = nameValuePair.split("=");
                return new BasicNameValuePair(pair[0], pair[1]);
            }).filter(nameValuePair -> "ST".equals(nameValuePair.getName())).map(BasicNameValuePair::getValue).findFirst();
        }
        return Optional.empty();
    }

    private static boolean isSessionTokenCookie(String rawCookie) {
        return Arrays.stream(rawCookie.split(";\\s")).map(nameValuePair -> nameValuePair.split("=")[0]).anyMatch("ST"::equals);
    }
}

