/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.adapters.pingone.mfa.util.DomainInfoUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class TrackerCookieInfo {
    String cookieDomain;
    String cookiePath;
    boolean httpOnly;
    boolean secure;
    int expiry;

    public TrackerCookieInfo() {
    }

    public TrackerCookieInfo(Map<String, Object> inParameters, HttpServletRequest req) {
        this.cookieDomain = DomainInfoUtil.getCurrentDomain(inParameters, req);
        this.cookiePath = "/idp";
        String currentBaseUrl = (String)inParameters.get("com.pingidentity.adapter.input.parameter.current.server.base.url");
        boolean isHttpOnly = true;
        boolean isSecureCookie = true;
        if (currentBaseUrl.startsWith("http://")) {
            isSecureCookie = false;
        }
        this.httpOnly = isHttpOnly;
        this.secure = isSecureCookie;
    }

    public TrackerCookieInfo(HttpServletRequest req) {
        this.cookieDomain = DomainInfoUtil.getCurrentDomain(null, req);
        this.cookiePath = "/idp";
        String currentBaseUrl = BaseUrlAccessor.getCurrentBaseUrl();
        boolean isHttpOnly = true;
        boolean isSecureCookie = true;
        if (currentBaseUrl.startsWith("http://")) {
            isSecureCookie = false;
        }
        this.httpOnly = isHttpOnly;
        this.secure = isSecureCookie;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }
}

