/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TrackerCookieObfuscator {
    private static final String ALGORITHM_NAME = "AES";
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String ENCODED_IV = "4JZY1kxsUfLEr3JjWBCP8A==";
    private boolean encrypt = false;

    public TrackerCookieObfuscator(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public String getDeObfuscatedCookieData(String envId, String obfuscatedCookieData) {
        if (this.encrypt && StringUtils.isNotBlank(envId) && envId.length() >= 16) {
            byte[] key = envId.substring(0, 16).getBytes(StandardCharsets.UTF_8);
            SecretKeySpec specKey = new SecretKeySpec(key, ALGORITHM_NAME);
            byte[] iv = Base64.getDecoder().decode(ENCODED_IV);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            byte[] encryptedBytes = null;
            byte[] obfuscatedDecodedCookieData = Base64.getDecoder().decode(obfuscatedCookieData.getBytes(StandardCharsets.UTF_8));
            try {
                Cipher cipher = Cipher.getInstance(TRANSFORMATION);
                cipher.init(2, (Key)specKey, ivSpec);
                encryptedBytes = cipher.doFinal(obfuscatedDecodedCookieData);
                String deObfuscatedData = new String(encryptedBytes);
                return deObfuscatedData;
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {}
        } else {
            byte[] obfuscatedDecodedCookieData = Base64.getDecoder().decode(obfuscatedCookieData.getBytes(StandardCharsets.UTF_8));
            return new String(obfuscatedDecodedCookieData);
        }
        return null;
    }

    public String getObfuscatedCookieData(String envId, String cookieData) {
        if (this.encrypt && StringUtils.isNotBlank(envId) && envId.length() >= 16) {
            byte[] key = envId.substring(0, 16).getBytes(StandardCharsets.UTF_8);
            SecretKeySpec specKey = new SecretKeySpec(key, ALGORITHM_NAME);
            byte[] iv = Base64.getDecoder().decode(ENCODED_IV);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            byte[] encryptedBytes = null;
            try {
                Cipher cipher = Cipher.getInstance(TRANSFORMATION);
                cipher.init(1, (Key)specKey, ivSpec);
                encryptedBytes = cipher.doFinal(cookieData.getBytes());
                String obfuscatedData = new String(Base64.getEncoder().encode(encryptedBytes), StandardCharsets.UTF_8);
                return obfuscatedData;
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {}
        } else {
            return new String(Base64.getEncoder().encode(cookieData.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        return null;
    }
}

