/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util.accestoken;

import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;

public interface AccessTokenProvider {
    public String getAccessToken() throws AccessTokenProviderException;

    default public AccessTokenProviderException processException(Throwable e) {
        if (e instanceof RuntimeException) {
            boolean isPingOneConnectionDisabledException;
            boolean isInvalidConnectionCredentialException;
            try {
                Class<?> invalidConnectionCredentialExceptionClazz = Class.forName("com.pingidentity.access.InvalidConnectionCredentialException");
                isInvalidConnectionCredentialException = invalidConnectionCredentialExceptionClazz.isInstance(e);
                Class<?> pingOneConnectionDisabledException = Class.forName("com.pingidentity.access.PingOneConnectionDisabledException");
                isPingOneConnectionDisabledException = pingOneConnectionDisabledException.isInstance(e);
            }
            catch (ClassNotFoundException classNotFoundException) {
                isInvalidConnectionCredentialException = false;
                isPingOneConnectionDisabledException = false;
            }
            if (!isInvalidConnectionCredentialException && !isPingOneConnectionDisabledException) {
                throw (RuntimeException)e;
            }
        }
        return new AccessTokenProviderException("Error requesting access token", e);
    }
}

