/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util.accestoken;

import com.pingidentity.access.InvalidConnectionCredentialException;
import com.pingidentity.access.PingOneConnectionDisabledException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.HttpClient;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.CustomPingOneV2APIClient;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;

public class ReflectivePingOneEnvironmentAccessor {
    private final Object pingOneEnvironmentAccessor;
    private final Method getEnvironmentId;
    private final Method getAuthenticationEndpoint;
    private final Method getManagementEndpoint;
    private final Method getAccessToken;
    private final PingOneConnectionsManager connectionMgr = MgmtFactory.getPingOneConnectionsManager();
    private final String connectionId;

    public ReflectivePingOneEnvironmentAccessor(String connEnvFieldValue) {
        try {
            Class<?> clazz = Class.forName("com.pingidentity.access.PingOneEnvironmentAccessor");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            this.pingOneEnvironmentAccessor = constructor.newInstance(connEnvFieldValue);
            this.getEnvironmentId = clazz.getMethod("getEnvironmentId", new Class[0]);
            this.getAuthenticationEndpoint = clazz.getMethod("getAuthenticationEndpoint", Boolean.TYPE);
            this.getManagementEndpoint = clazz.getMethod("getManagementEndpoint", new Class[0]);
            this.getAccessToken = clazz.getMethod("getAccessToken", new Class[0]);
            this.connectionId = PingOneEnvironmentFieldDescriptor.getConnectionId((String)connEnvFieldValue);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getEnvironmentId() {
        try {
            return (String)this.getEnvironmentId.invoke(this.pingOneEnvironmentAccessor, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAuthenticationEndpoint(boolean withEnvironment) {
        try {
            return (String)this.getAuthenticationEndpoint.invoke(this.pingOneEnvironmentAccessor, withEnvironment);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String getManagementEndpoint() {
        try {
            return (String)this.getManagementEndpoint.invoke(this.pingOneEnvironmentAccessor, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAccessToken() throws Throwable {
        try {
            return (String)this.getAccessToken.invoke(this.pingOneEnvironmentAccessor, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public String getAccessTokenWithCustomProxySettings(HttpClient customHttpClient) throws Throwable {
        PingOneConnection conn = this.connectionMgr.getConnection(this.connectionId);
        if (!conn.isActive()) {
            throw new PingOneConnectionDisabledException("Error obtaining access token. PingOne connection " + conn.getId() + " is disabled.");
        }
        try {
            CustomPingOneV2APIClient client = new CustomPingOneV2APIClient(customHttpClient, conn.getCredential());
            return client.exchangeGatewayCredential();
        }
        catch (InvalidGatewayCredentialException e) {
            throw new InvalidConnectionCredentialException("Error exchanging credential for access token", (Throwable)e);
        }
    }
}

