/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.oobauth.pingone.mfa;

import com.pingidentity.adapters.pingone.mfa.PingOneMfaIdpAdapter;
import com.pingidentity.adapters.pingone.mfa.api.client.PingOneClientsFactory;
import com.pingidentity.adapters.pingone.mfa.api.client.flows.FlowsApiClient;
import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.common.cache.Cache;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.common.cache.CacheBuilder;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.mfa.util.AppSecretCache;
import com.pingidentity.adapters.pingone.mfa.util.DefaultAppSecretProvider;
import com.pingidentity.adapters.pingone.mfa.util.IdToken;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import com.pingidentity.oobauth.pingone.mfa.AppUtil;
import com.pingidentity.oobauth.pingone.mfa.FlowStatus;
import com.pingidentity.oobauth.pingone.mfa.KVStateSupportWrapper;
import com.pingidentity.oobauth.pingone.mfa.LogEvent;
import com.pingidentity.oobauth.pingone.mfa.PingOneMfaCibaHandler;
import com.pingidentity.oobauth.pingone.mfa.PingOneMfaCibaState;
import com.pingidentity.oobauth.pingone.mfa.VelocityTemplateVariable;
import com.pingidentity.oobauth.pingone.mfa.config.CoreContract;
import com.pingidentity.oobauth.pingone.mfa.config.PingOneMfaCibaAuthenticatorConfiguration;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.oobauth.OOBAuthGeneralException;
import com.pingidentity.sdk.oobauth.OOBAuthPlugin;
import com.pingidentity.sdk.oobauth.OOBAuthRequestContext;
import com.pingidentity.sdk.oobauth.OOBAuthResultContext;
import com.pingidentity.sdk.oobauth.OOBAuthTransactionContext;
import com.pingidentity.sdk.oobauth.UnknownUserException;
import com.pingidentity.sdk.oobauth.UserAuthBindingMessageException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.util.log.AttributeMap;

public class PingOneMfaCibaAuthenticator
implements OOBAuthPlugin {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(PingOneMfaCibaAuthenticator.class);
    private static final Cache<String, Object> CACHE = CacheBuilder.newBuilder().build();
    private List<VelocityTemplateVariable> velocityTemplateVariables;
    private String envId;
    private String authEndpoint;
    private String applicationId;
    private String templateName;
    private String templateVariant;
    private String clientContext;
    private String messageProperties;
    private final KVStateSupportWrapper keyValueStateSupport;
    private PingOneMfaCibaHandler handler;

    public PingOneMfaCibaAuthenticator() {
        this.keyValueStateSupport = new KVStateSupportWrapper();
    }

    public PingOneMfaCibaAuthenticator(Configuration configuration, PingOneMfaCibaHandler handler, KVStateSupportWrapper keyValueStateSupport) {
        this.configureInternalState(configuration);
        this.handler = handler;
        this.keyValueStateSupport = keyValueStateSupport;
    }

    public OOBAuthTransactionContext initiate(OOBAuthRequestContext oobAuthRequestContext, Map<String, Object> map) throws UnknownUserException, UserAuthBindingMessageException, OOBAuthGeneralException {
        String subject = this.getSubject(oobAuthRequestContext);
        String requestingApplicationName = oobAuthRequestContext.getRequestingApplication().getName();
        Set scopes = oobAuthRequestContext.getRequestedScope().keySet();
        LOGGER.log((com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.INITIATING_AUTH, subject, requestingApplicationName, scopes.toString());
        FlowStatus flowStatus = this.handler.initiate(subject, oobAuthRequestContext);
        PingOneMfaCibaState state = new PingOneMfaCibaState(subject);
        state.setSubject(subject);
        state.setFlowStatus(flowStatus);
        state.setApplicationId(AppUtil.getApplicationId(this.applicationId, oobAuthRequestContext));
        if (OOBAuthResultContext.Status.SUCCESS == flowStatus.getStatus() || OOBAuthResultContext.Status.FAILURE == flowStatus.getStatus()) {
            state.setCompleted(true);
        }
        OOBAuthTransactionContext oobAuthTransactionContext = new OOBAuthTransactionContext();
        oobAuthTransactionContext.setStatusChangeCallbackCapable(false);
        String transactionIdentifier = flowStatus.getId();
        oobAuthTransactionContext.setTransactionIdentifier(transactionIdentifier);
        this.keyValueStateSupport.setValue(transactionIdentifier, state);
        return oobAuthTransactionContext;
    }

    public OOBAuthResultContext check(String transactionIdentifier, Map<String, Object> inParameters) throws OOBAuthGeneralException {
        OOBAuthResultContext.Status status;
        FlowStatus flowStatus;
        PingOneMfaCibaState state = (PingOneMfaCibaState)this.keyValueStateSupport.getValue(transactionIdentifier);
        String subject = state.getSubject();
        LOGGER.log((com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.CHECKING_AUTH, subject, transactionIdentifier);
        if (!state.isCompleted()) {
            String applicationId = state.getApplicationId();
            flowStatus = this.handler.check(applicationId, transactionIdentifier);
            status = flowStatus.getStatus();
            if (OOBAuthResultContext.Status.SUCCESS == status || OOBAuthResultContext.Status.FAILURE == status) {
                state.setCompleted(true);
                state.setFlowStatus(flowStatus);
                this.keyValueStateSupport.setValue(transactionIdentifier, state);
            }
        } else {
            flowStatus = state.getFlowStatus();
            status = flowStatus.getStatus();
        }
        OOBAuthResultContext oobAuthResultContext = new OOBAuthResultContext();
        oobAuthResultContext.setStatus(status);
        oobAuthResultContext.setStatusMessage(flowStatus.getStatusMessage());
        LOGGER.log((com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.AUTH_STATUS, subject, status, transactionIdentifier);
        return oobAuthResultContext;
    }

    public void finished(String transactionIdentifier) throws OOBAuthGeneralException {
        this.keyValueStateSupport.removeValue(transactionIdentifier);
    }

    public void configure(Configuration configuration) {
        PingOneClientsFactory clientsFactory = new PingOneClientsFactory(configuration);
        this.configureInternalState(configuration);
        FlowsApiClient flowsApiClient = clientsFactory.getFlowsApiClient();
        TokenService tokenService = clientsFactory.getTokenServiceClient();
        WorkerApiClient workerApiClient = clientsFactory.getWorkerApiClient();
        this.envId = clientsFactory.getEnvId();
        this.authEndpoint = clientsFactory.getAuthPath();
        AppSecretCache appSecretCache = new AppSecretCache("appSecret.", CACHE, new DefaultAppSecretProvider(configuration, tokenService, workerApiClient));
        this.handler = new PingOneMfaCibaHandler.Builder().setApplicationId(this.applicationId).setAppSecretCache(appSecretCache).setAuthPath(this.authEndpoint).setEnvId(this.envId).setFlowsApiClient(flowsApiClient).setTemplateName(this.templateName).setTemplateVariant(this.templateVariant).setVelocityTemplateVariables(this.velocityTemplateVariables).setClientContext(this.clientContext).setMessageProperties(this.messageProperties).setLpmFactory(LanguagePackMessages::new).setIdTokenFactory(IdToken::new).build();
    }

    public PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = new PluginDescriptor("PingOne MFA CIBA Authenticator 2.7", (ConfigurablePlugin)this, PingOneMfaCibaAuthenticatorConfiguration.guiConfigDescriptor(), "2.7"){

            public GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
                return new GuiConfigDescriptorBuilder(){

                    public GuiConfigDescriptor buildNewGuiDescriptor() {
                        return PingOneMfaCibaAuthenticatorConfiguration.guiConfigDescriptor();
                    }

                    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
                        return PingOneMfaCibaAuthenticatorConfiguration.guiConfigDescriptor(configuration);
                    }
                };
            }
        };
        pluginDescriptor.setAttributeContractSet(this.getContract());
        if (PingOneMfaIdpAdapter.supportsSetMetadata() && PingOneMfaIdpAdapter.supportsPluginServiceAssociation()) {
            try {
                Class<?> pluginMetadataKeysClass = Class.forName("com.pingidentity.sdk.PluginMetadataKeys");
                Class<?> pluginServiceAssociationClass = Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
                Constructor<?> pluginServiceAssociationConstructor = pluginServiceAssociationClass.getConstructor(String.class, String.class);
                pluginDescriptor.setMetadata(Collections.singletonMap((String)pluginMetadataKeysClass.getField("PING_ONE_SERVICE_ASSOCIATION").get(null), pluginServiceAssociationConstructor.newInstance("MFA CIBA Authenticator", pluginServiceAssociationClass.getField("MFA_SERVICE_DISPLAY_NAME").get(null))));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return pluginDescriptor;
    }

    private Set<String> getContract() {
        return Arrays.stream(CoreContract.values()).map(CoreContract::toString).collect(Collectors.toSet());
    }

    private void configureInternalState(Configuration configuration) {
        this.velocityTemplateVariables = PingOneMfaCibaAuthenticatorConfiguration.TemplateVariablesTable.getTemplateVariables(configuration);
        this.applicationId = PingOneMfaAdapterConfiguration.ApplicationField.getApplicationId(configuration);
        this.templateName = PingOneMfaCibaAuthenticatorConfiguration.TemplateNameField.getTemplateName(configuration);
        this.templateVariant = PingOneMfaCibaAuthenticatorConfiguration.TemplateVariantField.getTemplateVariant(configuration);
        this.clientContext = PingOneMfaCibaAuthenticatorConfiguration.ClientContextField.getClientContext(configuration);
        this.messageProperties = PingOneMfaAdapterConfiguration.MessagePropertiesField.getMessageProperties(configuration);
    }

    private String getSubject(OOBAuthRequestContext oobAuthRequestContext) throws UnknownUserException {
        AttributeMap attributeMap = oobAuthRequestContext.getUserAttributes();
        AttributeValue attributeValue = (AttributeValue)attributeMap.get((Object)CoreContract.SUBJECT.toString());
        if (attributeValue == null || attributeValue.getValue() == null) {
            throw new UnknownUserException("No attribute provided for " + CoreContract.SUBJECT.toString());
        }
        return attributeValue.getValue();
    }
}

