/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.oobauth.pingone.mfa;

import com.pingidentity.adapters.pingone.mfa.api.client.flows.FlowsApiClient;
import com.pingidentity.adapters.pingone.mfa.api.model.flows.Status;
import com.pingidentity.adapters.pingone.mfa.api.model.request.SelectDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AuthorizeResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.CompletedResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.DeviceSelectionRequiredResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.FailedResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.FlowError;
import com.pingidentity.adapters.pingone.mfa.api.model.response.FlowResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.MobileDevice;
import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.exception.ApiResponseException;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.parser.ParseException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.json.internal.json_simple.JSONValue;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.InvalidJwtException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.lang.JoseException;
import com.pingidentity.adapters.pingone.mfa.util.AppSecretCache;
import com.pingidentity.adapters.pingone.mfa.util.ErrorResponseUtil;
import com.pingidentity.adapters.pingone.mfa.util.IdToken;
import com.pingidentity.adapters.pingone.mfa.util.LoginHintTokenUtil;
import com.pingidentity.adapters.pingone.mfa.util.ObjectMappers;
import com.pingidentity.adapters.pingone.mfa.util.RequestParamUtil;
import com.pingidentity.oobauth.pingone.mfa.AppUtil;
import com.pingidentity.oobauth.pingone.mfa.FlowStatus;
import com.pingidentity.oobauth.pingone.mfa.IdTokenFactory;
import com.pingidentity.oobauth.pingone.mfa.LanguagePackMessagesFactory;
import com.pingidentity.oobauth.pingone.mfa.LogEvent;
import com.pingidentity.oobauth.pingone.mfa.PiTemplate;
import com.pingidentity.oobauth.pingone.mfa.TemplateVariable;
import com.pingidentity.oobauth.pingone.mfa.TemplateVariables;
import com.pingidentity.oobauth.pingone.mfa.VelocityTemplateVariable;
import com.pingidentity.oobauth.pingone.mfa.VelocityUtils;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.oobauth.OOBAuthGeneralException;
import com.pingidentity.sdk.oobauth.OOBAuthRequestContext;
import com.pingidentity.sdk.oobauth.OOBAuthResultContext;
import com.pingidentity.sdk.oobauth.UnknownUserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.AttributeMap;

public class PingOneMfaCibaHandler {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(PingOneMfaCibaHandler.class);
    private final String applicationId;
    private AppSecretCache appSecretCache;
    private final String authPath;
    private final String envId;
    private final FlowsApiClient flowsApiClient;
    private final String templateName;
    private final String templateVariant;
    private final List<VelocityTemplateVariable> velocityTemplateVariables;
    private final String clientContext;
    private final String messageProperties;
    private final LanguagePackMessagesFactory lpmFactory;
    private final IdTokenFactory idTokenFactory;

    private PingOneMfaCibaHandler(Builder builder) {
        this.applicationId = builder.applicationId;
        this.appSecretCache = builder.appSecretCache;
        this.authPath = builder.authPath;
        this.envId = builder.envId;
        this.flowsApiClient = builder.flowsApiClient;
        this.templateName = builder.templateName;
        this.templateVariant = builder.templateVariant;
        this.velocityTemplateVariables = builder.velocityTemplateVariables;
        this.clientContext = builder.clientContext;
        this.messageProperties = builder.messageProperties;
        this.lpmFactory = builder.lpmFactory;
        this.idTokenFactory = builder.idTokenFactory;
    }

    public FlowStatus initiate(String subject, OOBAuthRequestContext oobAuthRequestContext) throws OOBAuthGeneralException, UnknownUserException {
        try {
            String applicationId = AppUtil.getApplicationId(this.applicationId, oobAuthRequestContext);
            String applicationSecret = AppUtil.getApplicationSecret(this.appSecretCache.getAppSecret(applicationId), oobAuthRequestContext);
            String loginHintToken = LoginHintTokenUtil.generateLoginHintToken(this.authPath, applicationId, applicationSecret, this.envId, subject);
            String piTemplate = this.getPiTemplate(oobAuthRequestContext);
            String clientContext = this.getClientContext(oobAuthRequestContext);
            List<Device.Type> allowedMfaMethods = Collections.singletonList(Device.Type.MOBILE);
            String requestParam = RequestParamUtil.generateRequestParamToken(this.authPath, applicationId, applicationSecret, this.envId, null, piTemplate, clientContext, allowedMfaMethods, null, false);
            String acrValues = this.getPingOneMfaAcrValue(oobAuthRequestContext);
            FlowResponse flowResponse = this.flowsApiClient.initiateFlowPost(applicationId, loginHintToken, null, acrValues, requestParam, null, null, null);
            return this.handleFlowResponse(applicationId, flowResponse);
        }
        catch (AccessTokenProviderException | ParseException | JoseException | IOException e) {
            if (e instanceof ApiResponseException) {
                ApiResponseException apiResponseException = (ApiResponseException)e;
                this.handleApiResponseException(apiResponseException);
                ErrorResponse errorResponse = (ErrorResponse)apiResponseException.getErrorResponse();
                if (ErrorResponseUtil.isInvalidUserError(errorResponse)) {
                    UnknownUserException unknownUserException = new UnknownUserException(String.format("User '%s' was not found PingOne.", subject), (Throwable)e);
                    unknownUserException.setAllowMessagePropagation(true);
                    throw unknownUserException;
                }
            } else if (e instanceof AccessTokenProviderException) {
                throw new OOBAuthGeneralException("There was an error retrieving the application secret.", (Throwable)e);
            }
            throw new OOBAuthGeneralException("There was an error initiating authentication.", (Throwable)e);
        }
    }

    public FlowStatus check(String applicationId, String flowId) throws OOBAuthGeneralException {
        try {
            FlowResponse flowResponse = this.flowsApiClient.getFlow(flowId, null);
            return this.handleFlowResponse(applicationId, flowResponse);
        }
        catch (IOException e) {
            if (e instanceof ApiResponseException) {
                this.handleApiResponseException((ApiResponseException)e);
            }
            throw new OOBAuthGeneralException("There was an error checking the authentication status.", (Throwable)e);
        }
    }

    private FlowStatus handleFlowResponse(String applicationId, FlowResponse flowResponse) throws IOException, OOBAuthGeneralException {
        OOBAuthResultContext.Status status;
        String flowId = flowResponse.getId();
        String statusMessage = null;
        switch (Status.valueOf(flowResponse.getStatus())) {
            case PUSH_CONFIRMATION_TIMED_OUT: {
                LOGGER.log(LogEvent.PUSH_CONFIRMATION_TIMED_OUT);
                status = OOBAuthResultContext.Status.FAILURE;
                statusMessage = "Push confirmation timed out";
                break;
            }
            case FAILED: {
                status = this.handleFailedResponse((FailedResponse)flowResponse);
                if (status != null) break;
            }
            case SIGN_ON_REQUIRED: 
            case OTP_REQUIRED: {
                throw new OOBAuthGeneralException(String.format("PingOne flow %s status is %s and cannot be advanced further for an out-of-band authentication.", flowId, flowResponse.getStatus()));
            }
            case DEVICE_SELECTION_REQUIRED: {
                return this.handleDeviceSelectionRequiredResponse(applicationId, (DeviceSelectionRequiredResponse)flowResponse);
            }
            case PUSH_CONFIRMATION_REQUIRED: {
                status = OOBAuthResultContext.Status.IN_PROGRESS;
                break;
            }
            case COMPLETED: {
                return this.handleCompletedResponse(applicationId, (CompletedResponse)flowResponse);
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + Status.valueOf(flowResponse.getStatus()));
            }
        }
        return new FlowStatus(flowId, status, statusMessage);
    }

    private OOBAuthResultContext.Status handleFailedResponse(FailedResponse failedResponse) throws OOBAuthGeneralException {
        OOBAuthResultContext.Status status = null;
        FlowError error = failedResponse.getError();
        if (error != null) {
            String code = error.getCode();
            LOGGER.log((com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.FAILED_RESPONSE, code, error.getMessage());
            if (FlowError.Code.USER_DENIED.name().equals(code)) {
                LOGGER.log(LogEvent.USER_DENIED);
                status = OOBAuthResultContext.Status.FAILURE;
            } else {
                if (LogEvent.MFA_DISABLED.name().equals(code)) {
                    LOGGER.log(LogEvent.MFA_DISABLED);
                    throw new OOBAuthGeneralException(LogEvent.MFA_DISABLED.getMessage());
                }
                if (FlowError.Code.NO_USABLE_DEVICES.name().equals(code)) {
                    LOGGER.log(LogEvent.NO_USABLE_DEVICES);
                    throw new OOBAuthGeneralException(LogEvent.NO_USABLE_DEVICES.getMessage());
                }
            }
        }
        return status;
    }

    private FlowStatus handleDeviceSelectionRequiredResponse(String applicationId, DeviceSelectionRequiredResponse deviceSelectionRequiredResponse) throws IOException, OOBAuthGeneralException {
        String flowId = deviceSelectionRequiredResponse.getId();
        List<Device> devices = deviceSelectionRequiredResponse.getEmbeddedResources().getDevices();
        Optional<Device> device = devices.stream().filter(it -> MobileDevice.TYPE.equals(it.getType())).findFirst();
        if (device.isPresent()) {
            SelectDeviceRequest selectDeviceRequest = new SelectDeviceRequest(new Device(device.get().getId()));
            FlowResponse flowResponse = this.flowsApiClient.selectDevice(flowId, selectDeviceRequest, null);
            return this.handleFlowResponse(applicationId, flowResponse);
        }
        throw new OOBAuthGeneralException("User has no mobile devices.");
    }

    private FlowStatus handleCompletedResponse(String applicationId, CompletedResponse completedResponse) throws OOBAuthGeneralException, IOException {
        String flowId = completedResponse.getId();
        AuthorizeResponse authorizeResponse = completedResponse.getAuthorizeResponse();
        if (authorizeResponse == null) {
            FlowResponse flowResponse = this.flowsApiClient.resume(flowId, completedResponse.getSessionToken());
            return this.handleFlowResponse(applicationId, flowResponse);
        }
        try {
            String statusMessage;
            OOBAuthResultContext.Status status;
            IdToken idToken = this.idTokenFactory.newInstance(authorizeResponse.getIdToken(), this.authPath + "/" + this.envId + "/as/jwks", this.authPath + "/" + this.envId + "/as", applicationId);
            List<String> amr = idToken.getAmr();
            if (amr != null && amr.contains(IdToken.AmrValues.MFA.toString())) {
                status = OOBAuthResultContext.Status.SUCCESS;
                statusMessage = null;
            } else {
                status = OOBAuthResultContext.Status.FAILURE;
                statusMessage = "User cannot bypass MFA";
            }
            return new FlowStatus(flowId, status, statusMessage);
        }
        catch (InvalidJwtException e) {
            throw new OOBAuthGeneralException("Invalid ID token", (Throwable)e);
        }
    }

    private void handleApiResponseException(ApiResponseException apiResponseException) throws OOBAuthGeneralException {
        if (apiResponseException.getErrorResponse() != null) {
            ErrorResponse errorResponse = (ErrorResponse)apiResponseException.getErrorResponse();
            LOGGER.log((com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.API_ERROR, errorResponse.getPrettyErrorDetails());
            String code = errorResponse.getCode();
            String exceptionMsg = null;
            switch (code) {
                case "INVALID_DATA": {
                    String message = errorResponse.getMessage();
                    if (message != null && message.contains("Invalid sign-on policy provided in acr_values parameter")) {
                        LOGGER.log(LogEvent.INVALID_POLICY);
                        exceptionMsg = "Invalid sign-on policy.";
                        break;
                    }
                    String errorDetailCode = errorResponse.getErrorDetailCode();
                    String target = ErrorResponseUtil.getErrorDetailTarget(errorResponse);
                    if (!"INVALID_VALUE".equals(errorDetailCode) || !"request".equals(target)) break;
                    this.appSecretCache.invalidateAppSecret(this.applicationId);
                    break;
                }
                case "REQUEST_FAILED": {
                    String errorDetailCode;
                    switch (errorDetailCode = errorResponse.getErrorDetailCode()) {
                        case "PUSH_FAILED": {
                            LOGGER.log(LogEvent.PUSH_FAILED);
                            exceptionMsg = LogEvent.PUSH_FAILED.getMessage();
                            break;
                        }
                        case "NO_USABLE_DEVICES": {
                            LOGGER.log(LogEvent.NO_USABLE_DEVICES);
                            exceptionMsg = LogEvent.NO_USABLE_DEVICES.getMessage();
                        }
                    }
                    break;
                }
                case "ACCESS_FAILED": {
                    String errorDetailCode = errorResponse.getErrorDetailCode();
                    String errorDetailMessage = ErrorResponseUtil.getErrorDetailMessage(errorResponse);
                    if (!errorDetailCode.equals("POLICY_DENIED") || !errorDetailMessage.contains("MFA is disabled for user")) break;
                    LOGGER.log(LogEvent.MFA_DISABLED);
                    exceptionMsg = LogEvent.MFA_DISABLED.getMessage();
                    break;
                }
                case "INVALID_REQUEST": {
                    if (!ErrorResponseUtil.isInvalidUserError(errorResponse)) break;
                    LOGGER.log(LogEvent.INVALID_USER);
                    this.appSecretCache.invalidateAppSecret(this.applicationId);
                }
            }
            if (exceptionMsg != null) {
                throw new OOBAuthGeneralException(exceptionMsg, (Throwable)apiResponseException);
            }
        }
    }

    private String getPiTemplate(OOBAuthRequestContext oobAuthRequestContext) throws IOException, ParseException {
        ArrayList<TemplateVariable> templateVariables = new ArrayList<TemplateVariable>(TemplateVariables.from(oobAuthRequestContext));
        Map<String, Object> context = this.getBaseContext(oobAuthRequestContext);
        ArrayList velocityTemplateVariablesCopy = new ArrayList();
        this.velocityTemplateVariables.forEach(it -> velocityTemplateVariablesCopy.add(new VelocityTemplateVariable(it.getName(), it.getValue())));
        for (VelocityTemplateVariable v : velocityTemplateVariablesCopy) {
            v.setValue(context);
        }
        templateVariables.addAll(velocityTemplateVariablesCopy);
        Map<String, String> variables = templateVariables.stream().filter(it -> StringUtils.isNotBlank(it.getValue())).collect(Collectors.toMap(TemplateVariable::getName, TemplateVariable::getValue));
        AttributeValue requestedTemplateVariant = (AttributeValue)oobAuthRequestContext.getUserAttributes().get((Object)"pi.template.variant");
        String templateVariant = null;
        if (StringUtils.isNotEmpty(this.templateVariant)) {
            templateVariant = this.templateVariant;
        } else if (requestedTemplateVariant != null) {
            templateVariant = requestedTemplateVariant.getValue();
        }
        PiTemplate piTemplate = new PiTemplate(this.templateName, variables, templateVariant);
        return ObjectMappers.getDefault().writeValueAsString(piTemplate);
    }

    private Map<String, Object> getBaseContext(OOBAuthRequestContext oobAuthRequestContext) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        LanguagePackMessages languagePackMessages = this.lpmFactory.newLpm(this.messageProperties, oobAuthRequestContext.getLocale());
        context.put("languagePackMessages", languagePackMessages);
        context.put("oobAuthRequestContext", oobAuthRequestContext);
        AttributeMap userAttributes = oobAuthRequestContext.getUserAttributes();
        context.putAll(userAttributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> ((AttributeValue)it.getValue()).getValue())));
        return context;
    }

    private String getClientContext(OOBAuthRequestContext oobAuthRequestContext) throws IOException, ParseException {
        if (StringUtils.isNotEmpty(this.clientContext)) {
            Map<String, Object> context = this.getBaseContext(oobAuthRequestContext);
            context.put("JSONValue", new JSONValue());
            return VelocityUtils.apply("clientContext", this.clientContext, context).trim();
        }
        return "";
    }

    private String getPingOneMfaAcrValue(OOBAuthRequestContext oobAuthRequestContext) {
        return Optional.ofNullable(oobAuthRequestContext.getUserAttributes()).map(attributeMap -> (AttributeValue)attributeMap.get((Object)"pingone-mfa-acr")).map(AttributeValue::getValue).orElse(null);
    }

    public static class Builder {
        private String applicationId;
        private AppSecretCache appSecretCache;
        private String authPath;
        private String envId;
        private FlowsApiClient flowsApiClient;
        private String templateName;
        private String templateVariant;
        private List<VelocityTemplateVariable> velocityTemplateVariables;
        private String clientContext;
        private String messageProperties;
        private LanguagePackMessagesFactory lpmFactory;
        private IdTokenFactory idTokenFactory;

        public Builder setApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder setAppSecretCache(AppSecretCache appSecretCache) {
            this.appSecretCache = appSecretCache;
            return this;
        }

        public Builder setAuthPath(String authPath) {
            this.authPath = authPath;
            return this;
        }

        public Builder setEnvId(String envId) {
            this.envId = envId;
            return this;
        }

        public Builder setFlowsApiClient(FlowsApiClient flowsApiClient) {
            this.flowsApiClient = flowsApiClient;
            return this;
        }

        public Builder setTemplateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder setTemplateVariant(String templateVariant) {
            this.templateVariant = templateVariant;
            return this;
        }

        public Builder setVelocityTemplateVariables(List<VelocityTemplateVariable> velocityTemplateVariables) {
            this.velocityTemplateVariables = velocityTemplateVariables;
            return this;
        }

        public Builder setClientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public Builder setMessageProperties(String messageProperties) {
            this.messageProperties = messageProperties;
            return this;
        }

        public Builder setLpmFactory(LanguagePackMessagesFactory lpmFactory) {
            this.lpmFactory = lpmFactory;
            return this;
        }

        public Builder setIdTokenFactory(IdTokenFactory idTokenFactory) {
            this.idTokenFactory = idTokenFactory;
            return this;
        }

        public PingOneMfaCibaHandler build() {
            if (StringUtils.isNotBlank(this.applicationId) && this.appSecretCache != null && StringUtils.isNotBlank(this.authPath) && StringUtils.isNotBlank(this.envId) && this.flowsApiClient != null && StringUtils.isNotBlank(this.templateName) && this.velocityTemplateVariables != null && this.clientContext != null && this.messageProperties != null && this.lpmFactory != null && this.idTokenFactory != null) {
                return new PingOneMfaCibaHandler(this);
            }
            throw new IllegalArgumentException("All fields are required for an instance of " + PingOneMfaCibaHandler.class.getSimpleName());
        }
    }
}

