/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.oobauth.pingone.mfa.config;

import com.pingidentity.adapters.pingone.mfa.config.ApplicationsHelper;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.config.PingOnePreRenderCallback;
import com.pingidentity.oobauth.pingone.mfa.VelocityTemplateVariable;
import com.pingidentity.oobauth.pingone.mfa.config.PingOneMfaCibaAuthenticatorConfigurationValidator;
import com.pingidentity.oobauth.pingone.mfa.config.TestConnectionAction;
import com.pingidentity.oobauth.pingone.mfa.config.validator.TemplatesTableColumnValuesUniqueValidator;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextAreaFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class PingOneMfaCibaAuthenticatorConfiguration {
    private static final TemplateVariablesTable TEMPLATE_VARIABLES_TABLE = new TemplateVariablesTable();
    private static final PingOneMfaAdapterConfiguration.EnvIdField ENV_ID_FIELD = new PingOneMfaAdapterConfiguration.EnvIdField();
    private static final PingOneMfaAdapterConfiguration.RegionField REGION_FIELD = new PingOneMfaAdapterConfiguration.RegionField();
    private static final FieldDescriptor APPLICATION_CLIENT_SECRET_FIELD = new PingOneMfaAdapterConfiguration.EndUserClientSecretField();
    private static final PingOneMfaAdapterConfiguration.AuthenticationPolicyField AUTHENTICATION_POLICY_FIELD = new PingOneMfaAdapterConfiguration.AuthenticationPolicyField("The PingOne authentication policy, or policies to use.");
    private static final PingOneMfaAdapterConfiguration.TestUsernameField TEST_USERNAME_FIELD = new PingOneMfaAdapterConfiguration.TestUsernameField();
    private static final TemplateNameField TEMPLATE_NAME_FIELD = new TemplateNameField();
    private static final TemplateVariantField TEMPLATE_VARIANT_FIELD = new TemplateVariantField();
    private static final ClientContextField CLIENT_CONTEXT_FIELD = new ClientContextField();
    private static final PingOneMfaAdapterConfiguration.MessagePropertiesField MESSAGE_PROPERTIES_FIELD = new PingOneMfaAdapterConfiguration.MessagePropertiesField("Identifies the customizable language-pack file that the authenticator uses.\nIf you customized the language-pack file names in \"/server/default/conf/language-packs\", enter the new name here. \nThe default value is \"pingone-mfa-messages\".\n");
    private static final PingOneMfaAdapterConfiguration.RequestTimeoutField REQUEST_TIMEOUT_FIELD = new PingOneMfaAdapterConfiguration.RequestTimeoutField();
    private static final PingOneMfaAdapterConfiguration.ProxySettingsField PROXY_SETTINGS_RADIO_GROUP_FIELD = new PingOneMfaAdapterConfiguration.ProxySettingsField();
    private static final PingOneMfaAdapterConfiguration.ProxyHostField PROXY_HOST_FIELD = new PingOneMfaAdapterConfiguration.ProxyHostField();
    private static final PingOneMfaAdapterConfiguration.ProxyPortField PROXY_PORT_FIELD = new PingOneMfaAdapterConfiguration.ProxyPortField();

    public static GuiConfigDescriptor guiConfigDescriptor() {
        return PingOneMfaCibaAuthenticatorConfiguration.guiConfigDescriptor(null);
    }

    public static GuiConfigDescriptor guiConfigDescriptor(Configuration configuration) {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.setDescription("The PingOne MFA CIBA Authenticator allows PingFederate to use PingOne MFA to prompt users to approve or deny Client Initiated Backchannel Authentication (CIBA) requests.");
        guiConfigDescriptor.addTable((TableDescriptor)TEMPLATE_VARIABLES_TABLE);
        if (PingOneMfaAdapterConfiguration.supportsPingOneEnvironmentFieldDescriptor()) {
            guiConfigDescriptor.addField(PingOneMfaAdapterConfiguration.PingOneEnvironmentField.newPingOneEnvironmentField());
            guiConfigDescriptor.addField(PingOneMfaAdapterConfiguration.ApplicationField.newApplicationField(configuration, Collections.singletonList(SelectFieldDescriptor.SELECT_ONE)));
            guiConfigDescriptor.addPreRenderCallback((PreRenderCallback)new PingOnePreRenderCallback(new ApplicationsHelper()));
        } else {
            guiConfigDescriptor.addField((FieldDescriptor)ENV_ID_FIELD);
            guiConfigDescriptor.addField((FieldDescriptor)REGION_FIELD);
            guiConfigDescriptor.addField(PingOneMfaAdapterConfiguration.ApplicationField.newApplicationField());
            guiConfigDescriptor.addField(APPLICATION_CLIENT_SECRET_FIELD);
        }
        guiConfigDescriptor.addField((FieldDescriptor)AUTHENTICATION_POLICY_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)TEST_USERNAME_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)TEMPLATE_NAME_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)TEMPLATE_VARIANT_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)CLIENT_CONTEXT_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)MESSAGE_PROPERTIES_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)REQUEST_TIMEOUT_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)PROXY_SETTINGS_RADIO_GROUP_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)PROXY_HOST_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)PROXY_PORT_FIELD);
        guiConfigDescriptor.addValidator((ConfigurationValidator)new TemplatesTableColumnValuesUniqueValidator("PingOne Template Variables", "PingOne Template Variable Name", "Duplicate variables are not allowed: "));
        guiConfigDescriptor.addValidator((ConfigurationValidator)new PingOneMfaCibaAuthenticatorConfigurationValidator(configuration));
        guiConfigDescriptor.addAction(new ActionDescriptor("Test Connection", "Validate your configuration by initiating a test authentication.", (ActionDescriptor.Action)new TestConnectionAction()));
        return guiConfigDescriptor;
    }

    public static boolean legacyPingOneFieldsAreConfigured(Configuration configuration) {
        return PingOneMfaAdapterConfiguration.EnvIdField.isConfigured(configuration) && PingOneMfaAdapterConfiguration.RegionField.isConfigured(configuration);
    }

    public static class ClientContextField
    extends TextAreaFieldDescriptor {
        private ClientContextField() {
            super("Client Context", "This optional field allows you to customize the information sent to PingOne with the CIBA request. Although the PingOne notification template allows you to customize text and variables, this field allows you to access a more complex set of information that is available to PingFederate.", 30, 50);
            this.setDefaultValue("#*\nDefine additional key/value pairs to be received at the mobile application.\nThe following variables are available by default:\n\n$oobAuthRequestContext - Context for the out-of-band authentication/authorization request\n$languagePackMessages - The language-pack file configured for this authenticator\n$subject - The user's PingOne username or user ID.\n$JSONValue - A JSON utility class that can be used to escape text and convert objects to JSON.\n   Methods:\n       escape(String s) - Escape quotes, \\, /, \\r, \\n, \\b, \\f, \\t and other control characters (U+0000 through U+001F).\n       toJSONString(Object value) - Convert an object to JSON text.\n\nAdditionally, any Extended Contract attributes are also available using the $name syntax.\n\nExample:\n\n{\n   \"requestingApplicationName\": \"$JSONValue.escape($oobAuthRequestContext.requestingApplication.name)\",\n   \"requestedScope\": $JSONValue.toJSONString($oobAuthRequestContext.requestedScope.values()),\n   \"amount\": \"$JSONValue.escape($amount)\",\n   \"alert.color\": \"red\"\n}\n*#");
        }

        public static String getClientContext(Configuration configuration) {
            return configuration.getFieldValue("Client Context");
        }
    }

    public static class TemplateVariantField
    extends TextFieldDescriptor {
        private TemplateVariantField() {
            super("PingOne Template Variant", "Determines which variant of the PingOne notification template is used to show the CIBA request to the user. Overrides any variant name provided in the request context.");
        }

        public static String getTemplateVariant(Configuration configuration) {
            return configuration.getFieldValue("PingOne Template Variant");
        }
    }

    public static class TemplateNameField
    extends TextFieldDescriptor {
        private TemplateNameField() {
            super("PingOne Template Name", "Determines which PingOne notification template is used to show the CIBA request to the user.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.setDefaultValue("transaction");
        }

        public static String getTemplateName(Configuration configuration) {
            return configuration.getFieldValue("PingOne Template Name");
        }
    }

    public static class TemplateVariablesTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new TemplateVariableNameField(), new TemplateVariableValueField()});

        private TemplateVariablesTable() {
            super("PingOne Template Variables", "This table allows you to map dynamic values to the variables in your PingOne notification template.", ROW);
        }

        public static List<VelocityTemplateVariable> getTemplateVariables(Configuration configuration) {
            return configuration.getTable("PingOne Template Variables").getRows().stream().map(TemplateVariablesTable::fromRow).collect(Collectors.toList());
        }

        private static VelocityTemplateVariable fromRow(Row row) {
            String templateVariableName = TemplateVariableNameField.getTemplateVariableName(row);
            String templateVariableValue = TemplateVariableValueField.getTemplateVariableValue(row);
            return new VelocityTemplateVariable(templateVariableName, templateVariableValue);
        }
    }

    public static class TemplateVariableValueField
    extends TextAreaFieldDescriptor {
        private TemplateVariableValueField() {
            super("PingOne Template Variable Value", "Enter the value of the PingOne notification template variable. Use Apache Velocity Template Language to combine or manipulate plain text, language-pack messages, and attributes from the extended contract or authentication context. For example, 'The total value is $sum $currency.'", 30, 50);
            this.setDefaultValue("#*\nDefine values for PingOne template variables using the Velocity Template Language.\nThe following variables are available by default:\n\n$oobAuthRequestContext - Context for the out-of-band authentication/authorization request\n$languagePackMessages - The language-pack file configured for this authenticator\n$subject - The user's PingOne username or user ID.\n\nAdditionally, any Extended Contract attributes are also available using the $name syntax.\n*#");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getTemplateVariableValue(Row row) {
            return row.getFieldValue("PingOne Template Variable Value");
        }
    }

    public static class TemplateVariableNameField
    extends TextFieldDescriptor {
        private TemplateVariableNameField() {
            super("PingOne Template Variable Name", "Enter the name of the variable used in your PingOne notification template. For example, for the variable '${totalValue}', enter 'totalValue'.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static String getTemplateVariableName(Row row) {
            return row.getFieldValue("PingOne Template Variable Name");
        }
    }
}

