/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.oobauth.pingone.mfa.config;

import com.pingidentity.adapters.pingone.mfa.api.client.PingOneClientsFactory;
import com.pingidentity.adapters.pingone.mfa.api.client.flows.FlowsApiClient;
import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorResponse;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.exception.ApiResponseException;
import com.pingidentity.adapters.pingone.mfa.shade.com.google.common.cache.CacheBuilder;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.util.AppSecretCache;
import com.pingidentity.adapters.pingone.mfa.util.DefaultAppSecretProvider;
import com.pingidentity.adapters.pingone.mfa.util.ErrorResponseUtil;
import com.pingidentity.adapters.pingone.mfa.util.IdToken;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import com.pingidentity.oobauth.pingone.mfa.FlowStatus;
import com.pingidentity.oobauth.pingone.mfa.PingOneMfaCibaHandler;
import com.pingidentity.oobauth.pingone.mfa.VelocityTemplateVariable;
import com.pingidentity.oobauth.pingone.mfa.config.PingOneMfaCibaAuthenticatorConfiguration;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.oobauth.OOBAuthGeneralException;
import com.pingidentity.sdk.oobauth.OOBAuthRequestContext;
import com.pingidentity.sdk.oobauth.OOBAuthResultContext;
import com.pingidentity.sdk.oobauth.UnknownUserException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.util.log.AttributeMap;

public class TestConnectionAction
implements ActionDescriptor.Action {
    private static final String TEST_FAILED = "Test authentication failed. ";

    public String actionInvoked(Configuration configuration) {
        Object result;
        String testUsername = PingOneMfaAdapterConfiguration.TestUsernameField.getTestUserID(configuration);
        if (StringUtils.isBlank(testUsername)) {
            result = "Enter a valid value for 'Test Username' field to test.";
        } else {
            block23: {
                PingOneMfaCibaHandler handler = TestConnectionAction.newHandler(configuration);
                try {
                    OOBAuthRequestContext oobAuthRequestContext = new OOBAuthRequestContext();
                    oobAuthRequestContext.setLocale(Locale.getDefault());
                    oobAuthRequestContext.setRequestedScope(Collections.emptyMap());
                    oobAuthRequestContext.setRequestingApplication(new OOBAuthRequestContext.RequestingApplication());
                    oobAuthRequestContext.setUserAttributes(new AttributeMap());
                    FlowStatus flowStatus = handler.initiate(testUsername, oobAuthRequestContext);
                    if (!OOBAuthResultContext.Status.FAILURE.equals((Object)flowStatus.getStatus())) {
                        result = "Test authentication flow initiated successfully.";
                    } else {
                        result = TEST_FAILED;
                        String statusMessage = flowStatus.getStatusMessage();
                        if (StringUtils.isNotEmpty(statusMessage)) {
                            result = (String)result + statusMessage;
                        }
                    }
                }
                catch (OOBAuthGeneralException e) {
                    ApiResponseException apiResponseException;
                    result = TEST_FAILED;
                    String message = e.getMessage();
                    if (StringUtils.isNotEmpty(message)) {
                        result = (String)result + message + "\n";
                    }
                    if (!(e.getCause() instanceof ApiResponseException) || (apiResponseException = (ApiResponseException)e.getCause()).getErrorResponse() == null) break block23;
                    ErrorResponse errorResponse = (ErrorResponse)apiResponseException.getErrorResponse();
                    String code = errorResponse.getCode();
                    String errorDetailCode = errorResponse.getErrorDetailCode();
                    String errorDetailTarget = ErrorResponseUtil.getErrorDetailTarget(errorResponse);
                    String errorDetailMessage = ErrorResponseUtil.getErrorDetailMessage(errorResponse);
                    switch (code) {
                        case "INVALID_REQUEST": {
                            if ("INVALID_PARAMETER".equals(errorDetailCode) && "response_type".equals(errorDetailTarget)) {
                                result = (String)result + "Response type 'token id_token' is required and not supported by application '" + PingOneMfaAdapterConfiguration.ApplicationField.getApplicationId(configuration) + "'.";
                                break;
                            }
                        }
                        case "INVALID_DATA": {
                            if ("INVALID_VALUE".equals(errorDetailCode) && "scope".equals(errorDetailTarget)) {
                                result = (String)result + errorDetailMessage;
                                break;
                            }
                        }
                        case "ACCESS_FAILED": {
                            if ("INVALID_VALUE".equals(errorDetailCode) && "client_id".equals(errorDetailTarget)) {
                                result = (String)result + errorDetailMessage;
                                break;
                            }
                        }
                        default: {
                            result = (String)result + "\nError details: " + errorResponse.getPrettyErrorDetails();
                        }
                    }
                }
                catch (UnknownUserException e) {
                    result = TEST_FAILED + e.getMessage();
                }
            }
            if (TEST_FAILED.equals(result)) {
                result = (String)result + "Check configuration and/or server log for more details.";
            }
        }
        return result;
    }

    private static PingOneMfaCibaHandler newHandler(Configuration configuration) {
        PingOneClientsFactory clientsFactory = new PingOneClientsFactory(configuration);
        WorkerApiClient workerApiClient = clientsFactory.getWorkerApiClient();
        TokenService tokenService = clientsFactory.getTokenServiceClient();
        FlowsApiClient flowsApiClient = clientsFactory.getFlowsApiClient();
        List<VelocityTemplateVariable> velocityTemplateVariables = PingOneMfaCibaAuthenticatorConfiguration.TemplateVariablesTable.getTemplateVariables(configuration);
        String envId = clientsFactory.getEnvId();
        String authEndpoint = clientsFactory.getAuthPath();
        String applicationId = PingOneMfaAdapterConfiguration.ApplicationField.getApplicationId(configuration);
        String templateName = PingOneMfaCibaAuthenticatorConfiguration.TemplateNameField.getTemplateName(configuration);
        String templateVariant = PingOneMfaCibaAuthenticatorConfiguration.TemplateVariantField.getTemplateVariant(configuration);
        String clientContext = PingOneMfaCibaAuthenticatorConfiguration.ClientContextField.getClientContext(configuration);
        String messageProperties = PingOneMfaAdapterConfiguration.MessagePropertiesField.getMessageProperties(configuration);
        AppSecretCache appSecretCache = new AppSecretCache("appSecret.", CacheBuilder.newBuilder().expireAfterWrite(Duration.ZERO).build(), new DefaultAppSecretProvider(configuration, tokenService, workerApiClient));
        return new PingOneMfaCibaHandler.Builder().setApplicationId(applicationId).setAppSecretCache(appSecretCache).setAuthPath(authEndpoint).setEnvId(envId).setFlowsApiClient(flowsApiClient).setTemplateName(templateName).setTemplateVariant(templateVariant).setVelocityTemplateVariables(velocityTemplateVariables).setClientContext(clientContext).setMessageProperties(messageProperties).setLpmFactory(LanguagePackMessages::new).setIdTokenFactory(IdToken::new).build();
    }
}

