/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.integrations.provisioner.pingidforworkforce;

import com.pingidentity.integrations.provisioner.pingidforworkforce.PingIDForWorkforceWorkerFactory;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ResourceFieldKey;
import com.pingidentity.integrations.provisioner.pingidforworkforce.UserStatus;
import com.pingidentity.integrations.provisioner.pingidforworkforce.metadata.AttributeMetadataBuilder;
import com.pingidentity.integrations.provisioner.pingidforworkforce.metadata.PingIDForWorkforceAttributeMetadataBuilder;
import com.pingidentity.integrations.provisioner.pingidforworkforce.metadata.PingIDForWorkforceProvisionerInformationBuilder;
import com.pingidentity.integrations.provisioner.pingidforworkforce.metadata.ProvisionerInformationBuilder;
import com.pingidentity.integrations.provisioner.pingidforworkforce.metadata.attribute.ConnectionProfilesBuilder;
import com.pingidentity.integrations.provisioner.pingidforworkforce.metadata.attribute.PingIDForWorkforceConnectionProfileBuilder;
import com.pingidentity.integrations.provisioner.pingidforworkforce.metadata.attribute.PingIDForWorkforceUserAttributeBuilder;
import com.pingidentity.integrations.provisioner.pingidforworkforce.metadata.capability.PingIDForWorkforceCapabilityBuilder;
import com.pingidentity.integrations.provisioner.pingidforworkforce.metadata.enhancement.PingIDForWorkforceEnhancementBuilder;
import com.pingidentity.io.cpl.pingidforworkforce.Worker;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceNotFoundException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceNotModifiedException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceUnknownStateException;
import com.pingidentity.io.cpl.pingidforworkforce.metadata.AttributeMetadata;
import com.pingidentity.io.cpl.pingidforworkforce.metadata.ConnectionProfiles;
import com.pingidentity.io.cpl.pingidforworkforce.metadata.ProvisionerInformation;
import com.pingidentity.io.cpl.pingidforworkforce.request.CheckConnectionRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.ConnectionFields;
import com.pingidentity.io.cpl.pingidforworkforce.request.CreateUsersRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.DeleteUsersRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetAttributesRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetConnectionProfilesRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetInfoRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.GetUsersRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.UpdateUsersRequest;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingidforworkforce.resource.User;
import com.pingidentity.io.cpl.pingidforworkforce.response.CheckConnectionResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.CreateUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.DeleteUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetAttributesResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetConnectionProfilesResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetInfoResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.GetUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.UpdateUsersResponse;
import com.pingidentity.io.cpl.pingidforworkforce.response.UserAttempt;
import com.pingidentity.saas.definition.pingidforworkforce.SaasUser;
import com.pingidentity.saas.definition.pingidforworkforce.SaasUserApi;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.util.TextUtils;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.serialization.SerializationException;

public class PingIDForWorkforceWorker
extends Worker {
    private ProvisionerInformationBuilder provisionerInformationBuilder;
    private ConnectionProfilesBuilder connectionProfilesBuilder;
    private AttributeMetadataBuilder attributeMetadataBuilder;
    private SaasUserApi saasWrapper;
    private IntegrationsLogger adptLogger = new IntegrationsLogger(PingIDForWorkforceWorker.class);

    public PingIDForWorkforceWorker() {
        PingIDForWorkforceCapabilityBuilder capabilitiesBuilder = new PingIDForWorkforceCapabilityBuilder();
        PingIDForWorkforceEnhancementBuilder enhancementBuilder = new PingIDForWorkforceEnhancementBuilder();
        PingIDForWorkforceUserAttributeBuilder userAttributes = new PingIDForWorkforceUserAttributeBuilder();
        this.provisionerInformationBuilder = new PingIDForWorkforceProvisionerInformationBuilder();
        this.connectionProfilesBuilder = new PingIDForWorkforceConnectionProfileBuilder();
        this.attributeMetadataBuilder = new PingIDForWorkforceAttributeMetadataBuilder(capabilitiesBuilder, enhancementBuilder, userAttributes);
        this.saasWrapper = new PingIDForWorkforceWorkerFactory().make();
    }

    public PingIDForWorkforceWorker(ProvisionerInformationBuilder provisionerInformationBuilder, ConnectionProfilesBuilder connectionProfilesBuilder, AttributeMetadataBuilder attributeMetadataBuilder, SaasUserApi saasWrapper) {
        this.provisionerInformationBuilder = provisionerInformationBuilder;
        this.connectionProfilesBuilder = connectionProfilesBuilder;
        this.attributeMetadataBuilder = attributeMetadataBuilder;
        this.saasWrapper = saasWrapper;
    }

    @Override
    public GetInfoResponse getInfo(GetInfoRequest request) {
        this.adptLogger.logMethodEntry();
        ProvisionerInformation information = this.provisionerInformationBuilder.build();
        GetInfoResponse response = new GetInfoResponse();
        response.setInformation(information);
        return response;
    }

    @Override
    public GetConnectionProfilesResponse getConnectionProfiles(GetConnectionProfilesRequest request) {
        this.adptLogger.logMethodEntry();
        ConnectionProfiles connectionProfiles = this.connectionProfilesBuilder.build();
        GetConnectionProfilesResponse response = new GetConnectionProfilesResponse();
        response.setConnectionProfiles(connectionProfiles);
        return response;
    }

    @Override
    public GetAttributesResponse getAttributes(GetAttributesRequest request) {
        this.adptLogger.logMethodEntry();
        AttributeMetadata attributeMetadata = this.attributeMetadataBuilder.build();
        GetAttributesResponse response = new GetAttributesResponse();
        response.setAttributeMetadata(attributeMetadata);
        return response;
    }

    @Override
    public CheckConnectionResponse checkConnection(CheckConnectionRequest request) {
        this.adptLogger.logMethodEntry();
        ConnectionFields connectionFields = request.getConnectionFields();
        CheckConnectionResponse response = new CheckConnectionResponse();
        try {
            this.saasWrapper.checkConnection(connectionFields);
        }
        catch (ServiceException e) {
            response.addServiceException(e);
        }
        catch (SerializationException e) {
            response.addServiceException(new ServiceUnknownStateException(e.getMessage()));
        }
        return response;
    }

    @Override
    public CreateUsersResponse createUsers(CreateUsersRequest request) {
        this.adptLogger.logMethodEntry();
        ConnectionFields connectionFields = request.getConnectionFields();
        User user = (User)request.getUsers().get(0);
        CreateUsersResponse response = new CreateUsersResponse();
        UserAttempt userAttempt = new UserAttempt();
        response.addUserAttempt(userAttempt);
        SaasUser saasUser = null;
        try {
            saasUser = this.saasWrapper.createUser(connectionFields, user);
            userAttempt.setUser(saasUser.getCplUser());
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        catch (ResourceException e) {
            userAttempt.addResourceException(e);
        }
        catch (SerializationException e) {
            response.addServiceException(new ServiceUnknownStateException(e.getMessage()));
        }
        return response;
    }

    @Override
    public GetUsersResponse getUsers(GetUsersRequest request) {
        this.adptLogger.logMethodEntry();
        ConnectionFields connectionFields = request.getConnectionFields();
        User requestUser = (User)request.getUsers().get(0);
        ResourceUniqueId resourceUniqueId = requestUser.getResourceUniqueId();
        GetUsersResponse response = new GetUsersResponse();
        SaasUser user = null;
        UserAttempt userAttempt = new UserAttempt();
        response.addUserAttempt(userAttempt);
        try {
            try {
                user = this.saasWrapper.getUserBySaasGuid(connectionFields, requestUser);
            }
            catch (ResourceNotFoundException e) {
                return this.add404UserToResponse(resourceUniqueId, response);
            }
            catch (SerializationException e) {
                response.addServiceException(new ServiceUnknownStateException(e.getMessage()));
            }
            if (user != null) {
                userAttempt.setUser(user.getCplUser());
            }
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        catch (ResourceException e) {
            userAttempt.addResourceException(e);
        }
        return response;
    }

    @Override
    public UpdateUsersResponse updateUsers(UpdateUsersRequest request) {
        this.adptLogger.logMethodEntry();
        ConnectionFields connectionFields = request.getConnectionFields();
        User user = (User)request.getUsers().get(0);
        if (user.getResourceUniqueId().getId() == null || TextUtils.isEmpty(user.getResourceUniqueId().getId())) {
            ResourceUniqueId resourceUniqueId = new ResourceUniqueId(user.getResourceAttributes().getValueOf(ResourceFieldKey.USERNAME.getLabel()));
            user.setResourceUniqueId(resourceUniqueId);
        }
        UpdateUsersResponse response = new UpdateUsersResponse();
        UserAttempt userAttempt = new UserAttempt();
        response.addUserAttempt(userAttempt);
        SaasUser saasUser = null;
        SaasUser getSaasUser = null;
        try {
            getSaasUser = this.saasWrapper.getUserBySaasGuid(connectionFields, user);
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        catch (ResourceException e) {
            userAttempt.addResourceException(e);
        }
        catch (SerializationException e) {
            userAttempt.addResourceException(new ResourceNotModifiedException(user, e.getMessage()));
        }
        String pingIdUserStatus = null;
        ResourceAttributes updateAttrs = user.getResourceAttributes();
        String usorUserStatus = updateAttrs.getValueOf(ResourceFieldKey.ACTIVATE_USER.getLabel());
        if (getSaasUser != null) {
            User getUser = getSaasUser.getCplUser();
            ResourceAttributes attrs = getUser.getResourceAttributes();
            pingIdUserStatus = attrs.getValueOf(ResourceFieldKey.STATUS.getLabel());
        }
        if (this.userIsActiveOrSuspendedInPingID(pingIdUserStatus)) {
            try {
                if (this.userStatusIsDifferentInUSoR(pingIdUserStatus, usorUserStatus)) {
                    this.saasWrapper.activateOrSuspendUser(connectionFields, user);
                }
            }
            catch (ServiceException e) {
                response.addServiceException(e);
                return response;
            }
            catch (ResourceException e) {
                userAttempt.addResourceException(e);
            }
            catch (SerializationException e) {
                userAttempt.addResourceException(new ResourceNotModifiedException(user, e.getMessage()));
            }
        }
        try {
            saasUser = this.saasWrapper.updateUser(connectionFields, user);
            userAttempt.setUser(saasUser.getCplUser());
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        catch (ResourceException e) {
            userAttempt.addResourceException(e);
        }
        catch (SerializationException e) {
            response.addServiceException(new ServiceUnknownStateException(e.getMessage()));
        }
        return response;
    }

    @Override
    public DeleteUsersResponse deleteUsers(DeleteUsersRequest request) {
        this.adptLogger.logMethodEntry();
        ConnectionFields connectionFields = request.getConnectionFields();
        User user = (User)request.getUsers().get(0);
        DeleteUsersResponse response = new DeleteUsersResponse();
        UserAttempt userAttempt = new UserAttempt();
        response.addUserAttempt(userAttempt);
        try {
            this.saasWrapper.deleteUser(connectionFields, user);
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        catch (ResourceException e) {
            userAttempt.addResourceException(e);
        }
        catch (SerializationException e) {
            response.addServiceException(new ServiceUnknownStateException(e.getMessage()));
        }
        return response;
    }

    private GetUsersResponse add404UserToResponse(ResourceUniqueId resourceUniqueId, GetUsersResponse response) {
        ResourceNotFoundException ex = new ResourceNotFoundException(new User(resourceUniqueId), "User Not Found");
        ((UserAttempt)response.getUserAttempts().get(0)).addResourceException(ex);
        return response;
    }

    private boolean userIsActiveOrSuspendedInPingID(String pingIdUserStatus) {
        return pingIdUserStatus != null && !pingIdUserStatus.isEmpty() && (pingIdUserStatus.equalsIgnoreCase(UserStatus.ACTIVE.getStatus()) || pingIdUserStatus.equalsIgnoreCase(UserStatus.SUSPENDED.getStatus()));
    }

    private boolean userStatusIsDifferentInUSoR(String pingIdUserStatus, String usorUserStatus) {
        return !UserStatus.findByStatus(pingIdUserStatus).getBooleanValue().equalsIgnoreCase(usorUserStatus);
    }
}

