/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.io.cpl.pingidforworkforce.exception;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ProvisionerException;
import com.pingidentity.io.cpl.pingidforworkforce.resource.Resource;

public class ResourceException
extends ProvisionerException {
    private static final long serialVersionUID = -6554628542581702901L;
    private static final String NULL_RESOURCE_MSG = "not_available";
    private static final String DEFAULT_MSG = "Action on resource id [%s] failed. Provided error message: %s";
    private final Resource resource;

    @JsonCreator
    public ResourceException(@JsonProperty(value="resource") Resource resource, @JsonProperty(value="errorMessage") String errorMessage) {
        super(DEFAULT_MSG, ResourceException.resourceNotPopulated(resource) ? NULL_RESOURCE_MSG : resource.getResourceUniqueId().getId(), errorMessage);
        this.resource = resource;
    }

    public ResourceException(Resource resource, String errorMessage, String identifier) {
        super(DEFAULT_MSG, identifier, errorMessage);
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    private static boolean resourceNotPopulated(Resource resource) {
        return resource == null || resource.getResourceUniqueId() == null || resource.getResourceUniqueId().getId() == null || resource.getResourceUniqueId().getId().isEmpty();
    }
}

