/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingidforworkforce.request;

import com.pingidentity.io.cpl.pingidforworkforce.metadata.CapabilityType;
import com.pingidentity.io.cpl.pingidforworkforce.metadata.ReferenceAttribute;
import com.pingidentity.prov.saas.pingidforworkforce.metadata.MetadataService;
import com.pingidentity.prov.saas.pingidforworkforce.metadata.MetadataServiceFactory;
import com.pingidentity.prov.saas.pingidforworkforce.request.CheckConnectionRequestBuilder;
import com.pingidentity.prov.saas.pingidforworkforce.request.CreateUserRequestBuilder;
import com.pingidentity.prov.saas.pingidforworkforce.request.DeleteUserRequestBuilder;
import com.pingidentity.prov.saas.pingidforworkforce.request.GetUserRequestBuilder;
import com.pingidentity.prov.saas.pingidforworkforce.request.RequestBuilder;
import com.pingidentity.prov.saas.pingidforworkforce.request.RequestBuilderFactory;
import com.pingidentity.prov.saas.pingidforworkforce.request.UpdateUserRequestBuilder;

public class DefaultUserRequestBuilderFactory
implements RequestBuilderFactory {
    protected final MetadataService metadataService;
    protected String activationAttributeName;
    protected Boolean activeState;

    public DefaultUserRequestBuilderFactory(MetadataServiceFactory metadataServiceFactory) {
        this.metadataService = metadataServiceFactory.make();
    }

    public DefaultUserRequestBuilderFactory(MetadataServiceFactory metadataServiceFactory, String activationAttributeName, Boolean activeState) {
        this.metadataService = metadataServiceFactory.make();
        this.activationAttributeName = activationAttributeName;
        this.activeState = activeState;
    }

    @Override
    public RequestBuilder make(CapabilityType capabilityType) {
        switch (capabilityType) {
            case GET_USERS: {
                return new GetUserRequestBuilder();
            }
            case CREATE_USERS: {
                return new CreateUserRequestBuilder(this.metadataService.getUserAttributes(), this.getActivationAttributeName(), this.getActiveState());
            }
            case UPDATE_USERS: {
                return new UpdateUserRequestBuilder(this.metadataService.getUserAttributes(), this.getActivationAttributeName(), this.getActiveState());
            }
            case DELETE_USERS: {
                return new DeleteUserRequestBuilder();
            }
            case CHECK_CONNECTION: {
                return new CheckConnectionRequestBuilder();
            }
        }
        throw new IllegalArgumentException("Capability Type not supported");
    }

    public String getActivationAttributeName() {
        if (this.activationAttributeName == null) {
            return ReferenceAttribute.ACTIVE.getKey();
        }
        return this.activationAttributeName;
    }

    public boolean getActiveState() {
        if (this.activeState == null) {
            return true;
        }
        return this.activeState;
    }
}

