/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingidforworkforce.request;

import com.pingidentity.io.cpl.pingidforworkforce.metadata.Attributes;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceAttributes;
import com.pingidentity.provisioner.sdk.SaasUserData;
import java.util.Set;

public abstract class UserRequestBuilder {
    private String activationAttributeName;
    private boolean activeState;

    protected UserRequestBuilder(String activationAttributeName, boolean activeState) {
        this.activationAttributeName = activationAttributeName;
        this.activeState = activeState;
    }

    protected ResourceAttributes buildAttributes(SaasUserData saasUserData, Attributes attributes) {
        String isActiveValue = null;
        ResourceAttributes userAttributes = new ResourceAttributes();
        isActiveValue = this.activeState ? saasUserData.isAccountEnabled() + "" : !saasUserData.isAccountEnabled() + "";
        saasUserData.addAttribute(this.activationAttributeName, isActiveValue);
        userAttributes.add(this.activationAttributeName, isActiveValue);
        for (String attributeKey : attributes.keySet()) {
            if (!this.attributeExistsInSaasUserData(saasUserData, attributeKey)) continue;
            userAttributes.add(attributeKey, new String());
        }
        userAttributes = this.populate(saasUserData, userAttributes);
        return userAttributes;
    }

    private ResourceAttributes populate(SaasUserData saasUserData, ResourceAttributes userAttributes) {
        Set attributeKeys = saasUserData.getAttributeMap().keySet();
        for (String key : attributeKeys) {
            if (userAttributes.get(key) == null) continue;
            userAttributes.add(key, saasUserData.getAttributeValues(key));
        }
        return userAttributes;
    }

    private boolean attributeExistsInSaasUserData(SaasUserData saasUserData, String attributeKey) {
        return saasUserData.getAttributeFirstValue(attributeKey) != null;
    }
}

