/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingidforworkforce.request.groups;

import com.pingidentity.io.cpl.pingidforworkforce.metadata.Attributes;
import com.pingidentity.io.cpl.pingidforworkforce.metadata.BaseAttribute;
import com.pingidentity.io.cpl.pingidforworkforce.request.ConnectionFields;
import com.pingidentity.io.cpl.pingidforworkforce.request.CreateGroupsRequest;
import com.pingidentity.io.cpl.pingidforworkforce.request.Request;
import com.pingidentity.io.cpl.pingidforworkforce.resource.Group;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceUniqueId;
import com.pingidentity.prov.saas.pingidforworkforce.request.RequestBuilder;
import com.pingidentity.prov.saas.pingidforworkforce.request.RequestParameters;
import com.pingidentity.prov.saas.pingidforworkforce.request.groups.GroupRequestBuilder;
import com.pingidentity.prov.saas.pingidforworkforce.request.groups.GroupRequestParameters;
import com.pingidentity.provisioner.sdk.SaasGroupData;

public class CreateGroupRequestBuilder
extends GroupRequestBuilder
implements RequestBuilder {
    private Attributes attributes;

    public CreateGroupRequestBuilder(Attributes attributes, String groupNameAttributeName) {
        super(groupNameAttributeName);
        this.attributes = attributes;
    }

    @Override
    public Request build(RequestParameters requestParameters) {
        Attributes createableAttributes = new Attributes();
        for (String groupAttributeKey : this.attributes.keySet()) {
            BaseAttribute attribute = (BaseAttribute)this.attributes.get(groupAttributeKey);
            boolean createable = attribute.isCreatable();
            boolean required = attribute.isRequiredOnCreate();
            if (!required && !createable) continue;
            createableAttributes.add(attribute);
        }
        GroupRequestParameters parameters = (GroupRequestParameters)requestParameters;
        SaasGroupData data = parameters.getSaasGroupData();
        ConnectionFields connectionFields = parameters.getConnectionFields();
        ResourceAttributes attributes = this.buildAttributes(data, createableAttributes);
        Group group = new Group(attributes, new ResourceUniqueId(data.getGuid()));
        return new CreateGroupsRequest(connectionFields, group);
    }
}

