/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Resource<T> {
    private String id;
    private Map<T, List<String>> attributes;

    public Resource() {
        this(null, null);
    }

    public Resource(String id) {
        this(id, null);
    }

    public Resource(Map<T, List<String>> attributes) {
        this(null, attributes);
    }

    public Resource(String id, Map<T, List<String>> attributes) {
        this.id = id;
        this.attributes = attributes == null ? new HashMap() : attributes;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<T, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<T, List<String>> attributes) {
        this.attributes = attributes == null ? new HashMap() : attributes;
    }

    public void add(T key, String value) {
        ArrayList<String> storedValue = this.attributes.get(key);
        storedValue = storedValue == null ? new ArrayList<String>() : storedValue;
        storedValue.add(value);
        this.attributes.put(key, storedValue);
    }

    public List<String> put(T key, List<String> value) {
        return this.attributes.put(key, value);
    }

    public List<String> putOne(T key, String value) {
        ArrayList<String> l = new ArrayList<String>();
        if (value != null) {
            l.add(value);
        }
        return this.put(key, l);
    }

    public List<String> get(T key) {
        return this.attributes.get(key);
    }

    public String getOne(T key) {
        List<String> values = this.attributes.get(key);
        return values != null && values.size() > 0 ? values.get(0) : null;
    }

    public List<String> remove(T key) {
        return this.attributes.remove(key);
    }

    public String toString() {
        return "Resource [id=" + this.id + ", attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

