/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud;

import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.CrudClient;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.CrudException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.RequestBuilder;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.crud.ServiceException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdCredential;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDevice;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDeviceAttribute;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDeviceRequestBuilder;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDeviceResponseParser;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.exception.ConfigurationException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.exception.DeviceNotFoundException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.HttpService;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.HttpServiceException;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.http.apache5.ApacheHttpServiceFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PingIdDeviceClient
implements CrudClient<PingIdCredential, PingIdDevice> {
    private final RequestBuilder<PingIdCredential, PingIdDevice> requestBuilder;
    private final HttpService httpService;
    private final PingIdDeviceResponseParser responseParser;

    public PingIdDeviceClient(RequestBuilder<PingIdCredential, PingIdDevice> requestBuilder, HttpService httpService, PingIdDeviceResponseParser responseParser) {
        this.requestBuilder = requestBuilder;
        this.httpService = httpService;
        this.responseParser = responseParser;
    }

    public PingIdDeviceClient() {
        this(new PingIdDeviceRequestBuilder(), new ApacheHttpServiceFactory().make(), new PingIdDeviceResponseParser());
    }

    @Override
    public PingIdDevice create(Map<PingIdCredential, String> creds, PingIdDevice resource) throws CrudException {
        boolean areDeviceNicknamesDifferent;
        List<PingIdDevice> initialDevices = this.search(creds, resource);
        GenericHttpRequest req = this.requestBuilder.buildCreateRequest(creds, resource);
        GenericHttpResponse resp = null;
        try {
            resp = this.httpService.execute(req);
        }
        catch (HttpServiceException e) {
            throw new ServiceException(e);
        }
        String base64Key = creds.get((Object)PingIdCredential.BASE_64_KEY);
        this.responseParser.parseCreateResponse(base64Key, resp);
        List<PingIdDevice> postCreateDevices = this.search(creds, resource);
        Optional<PingIdDevice> optionalCreatedDevice = postCreateDevices.stream().filter(postCreateDevice -> !initialDevices.contains(postCreateDevice)).findFirst();
        if (!optionalCreatedDevice.isPresent()) {
            throw new DeviceNotFoundException(String.format("Created device for user \"%s\" could not be found.", resource.get(PingIdDeviceAttribute.USERNAME)));
        }
        PingIdDevice createdDevice = optionalCreatedDevice.get();
        String preCreateDevicePrimacy = resource.getOne(PingIdDeviceAttribute.PRIMARY);
        preCreateDevicePrimacy = preCreateDevicePrimacy != null ? preCreateDevicePrimacy : Boolean.FALSE.toString();
        String postCreateDevicePrimacy = createdDevice.getOne(PingIdDeviceAttribute.PRIMARY);
        postCreateDevicePrimacy = postCreateDevicePrimacy != null ? postCreateDevicePrimacy : Boolean.FALSE.toString();
        boolean isResourceDevicePrimary = Boolean.TRUE.toString().equalsIgnoreCase(preCreateDevicePrimacy);
        boolean isCreatedDevicePrimary = Boolean.TRUE.toString().equalsIgnoreCase(postCreateDevicePrimacy);
        boolean doesPrimaryRequireUpdate = isResourceDevicePrimary && !isCreatedDevicePrimary;
        String preCreateDeviceNickname = resource.getOne(PingIdDeviceAttribute.NICKNAME);
        preCreateDeviceNickname = preCreateDeviceNickname != null ? preCreateDeviceNickname : "";
        String postCreateDeviceNickname = createdDevice.getOne(PingIdDeviceAttribute.NICKNAME);
        postCreateDeviceNickname = postCreateDeviceNickname != null ? postCreateDeviceNickname : "";
        boolean bl = areDeviceNicknamesDifferent = !preCreateDeviceNickname.equalsIgnoreCase(postCreateDeviceNickname);
        if (doesPrimaryRequireUpdate || areDeviceNicknamesDifferent) {
            createdDevice.putOne(PingIdDeviceAttribute.NICKNAME, preCreateDeviceNickname);
            createdDevice.putOne(PingIdDeviceAttribute.PRIMARY, preCreateDevicePrimacy);
            createdDevice = this.update(creds, createdDevice);
        }
        return createdDevice;
    }

    @Override
    public PingIdDevice read(Map<PingIdCredential, String> creds, PingIdDevice resource) throws CrudException {
        String username;
        String deviceId = resource != null ? resource.getId() : null;
        String string = username = resource != null ? resource.getOne(PingIdDeviceAttribute.USERNAME) : null;
        if (resource == null || deviceId == null || deviceId.isEmpty() || username == null || username.isEmpty()) {
            throw new ConfigurationException("Read PingID Device Request is missing required fields id and/or username");
        }
        List<PingIdDevice> devices = this.search(creds, resource);
        Optional<PingIdDevice> foundDevice = devices.stream().filter(pid -> pid.getId().equalsIgnoreCase(resource.getId())).findFirst();
        if (foundDevice.isPresent()) {
            return foundDevice.get();
        }
        throw new DeviceNotFoundException(String.format("Device with Id \"%s\" for user \"%s\" could not be found.", deviceId, username));
    }

    @Override
    public PingIdDevice update(Map<PingIdCredential, String> creds, PingIdDevice resource) throws CrudException {
        String nickname;
        String deviceId = resource.getId();
        String username = resource.getOne(PingIdDeviceAttribute.USERNAME);
        String primacy = resource.getOne(PingIdDeviceAttribute.PRIMARY);
        String base64Key = creds.get((Object)PingIdCredential.BASE_64_KEY);
        if ("true".equalsIgnoreCase(primacy)) {
            PingIdDevice updatePrimaryDevice = new PingIdDevice(deviceId);
            updatePrimaryDevice.add(PingIdDeviceAttribute.USERNAME, username);
            updatePrimaryDevice.add(PingIdDeviceAttribute.PRIMARY, primacy);
            GenericHttpRequest req = this.requestBuilder.buildUpdateRequest(creds, resource);
            GenericHttpResponse resp = null;
            try {
                resp = this.httpService.execute(req);
            }
            catch (HttpServiceException e) {
                throw new ServiceException(e);
            }
            this.responseParser.parseUpdateResponse(base64Key, resp);
        }
        if ((nickname = resource.getOne(PingIdDeviceAttribute.NICKNAME)) != null && !nickname.isEmpty()) {
            PingIdDevice updateNicknameDevice = new PingIdDevice(deviceId);
            updateNicknameDevice.add(PingIdDeviceAttribute.USERNAME, username);
            updateNicknameDevice.add(PingIdDeviceAttribute.NICKNAME, nickname);
            GenericHttpRequest req = this.requestBuilder.buildUpdateRequest(creds, updateNicknameDevice);
            GenericHttpResponse resp = null;
            try {
                resp = this.httpService.execute(req);
            }
            catch (HttpServiceException e) {
                throw new ServiceException(e);
            }
            this.responseParser.parseUpdateResponse(base64Key, resp);
        }
        return this.read(creds, resource);
    }

    @Override
    public Optional<PingIdDevice> partialUpdate(Map<PingIdCredential, String> creds, PingIdDevice resource) throws CrudException {
        throw new UnsupportedOperationException("Partial update has not been implemented");
    }

    @Override
    public void delete(Map<PingIdCredential, String> creds, PingIdDevice resource) throws CrudException {
        GenericHttpRequest req = this.requestBuilder.buildDeleteRequest(creds, resource);
        GenericHttpResponse resp = null;
        try {
            resp = this.httpService.execute(req);
        }
        catch (HttpServiceException e) {
            throw new ServiceException(e);
        }
        String base64Key = creds.get((Object)PingIdCredential.BASE_64_KEY);
        this.responseParser.parseDeleteResponse(base64Key, resp);
    }

    @Override
    public List<PingIdDevice> search(Map<PingIdCredential, String> creds, PingIdDevice resource) throws CrudException {
        GenericHttpRequest req = this.requestBuilder.buildSearchRequest(creds, resource);
        GenericHttpResponse resp = null;
        try {
            resp = this.httpService.execute(req);
        }
        catch (HttpServiceException e) {
            throw new ServiceException(e);
        }
        String base64Key = creds.get((Object)PingIdCredential.BASE_64_KEY);
        return this.responseParser.parseSearchResponse(base64Key, resp);
    }
}

