/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud;

import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDevice;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.PingIdDeviceAttribute;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.Translator;
import com.pingidentity.saas.prov_pingid.shade.com.pingidentity.common.device.crud.dto.search.DeviceDto;

public class PingIdDeviceDtoTranslator
implements Translator<DeviceDto, PingIdDevice> {
    private static final String EMAIL_TYPE = "Email";
    private static final String SMS_TYPE = "SMS";
    private static final String VOICE_TYPE = "Voice";
    private static final String PRIMARY = "PRIMARY";

    @Override
    public PingIdDevice translate(DeviceDto u) {
        PingIdDevice device = new PingIdDevice();
        String id = u.getDeviceId();
        device.setId(id);
        String type = u.getType();
        device.add(PingIdDeviceAttribute.TYPE, type);
        String pairingData = EMAIL_TYPE.equalsIgnoreCase(type) ? u.getEmail() : u.getCountryCode() + u.getPhoneNumber();
        device.add(PingIdDeviceAttribute.PAIRING_DATA, pairingData);
        String nickname = u.getNickname();
        device.add(PingIdDeviceAttribute.NICKNAME, nickname);
        boolean isPrimary = PRIMARY.equalsIgnoreCase(u.getDeviceRole());
        device.add(PingIdDeviceAttribute.PRIMARY, String.valueOf(isPrimary));
        return device;
    }
}

