/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.prov_pingid.shade.org.jose4j.jwe.kdf;

import com.pingidentity.saas.prov_pingid.shade.org.jose4j.keys.HmacKey;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.lang.ByteUtil;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.lang.JoseException;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.lang.UncheckedJoseException;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.mac.MacUtil;
import java.io.ByteArrayOutputStream;
import javax.crypto.Mac;

public class PasswordBasedKeyDerivationFunction2 {
    private String hmacAlgorithm;

    public PasswordBasedKeyDerivationFunction2(String hmacAlgorithm) {
        this.hmacAlgorithm = hmacAlgorithm;
    }

    public byte[] derive(byte[] password, byte[] salt, int iterationCount, int dkLen) throws JoseException {
        return this.derive(password, salt, iterationCount, dkLen, null);
    }

    public byte[] derive(byte[] password, byte[] salt, int iterationCount, int dkLen, String provider) throws JoseException {
        Mac prf = MacUtil.getInitializedMac(this.hmacAlgorithm, new HmacKey(password), provider);
        int hLen = prf.getMacLength();
        long maxDerivedKeyLength = 0xFFFFFFFFL;
        if ((long)dkLen > maxDerivedKeyLength) {
            throw new UncheckedJoseException("derived key too long " + dkLen);
        }
        int l = (int)Math.ceil((double)dkLen / (double)hLen);
        int r = dkLen - (l - 1) * hLen;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < l; ++i) {
            byte[] block = this.f(salt, iterationCount, i + 1, prf);
            if (i == l - 1) {
                block = ByteUtil.subArray(block, 0, r);
            }
            byteArrayOutputStream.write(block, 0, block.length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    byte[] f(byte[] salt, int iterationCount, int blockIndex, Mac prf) {
        byte[] lastU = null;
        byte[] xorU = null;
        for (int i = 1; i <= iterationCount; ++i) {
            byte[] currentU;
            if (i == 1) {
                byte[] inputBytes = ByteUtil.concat(salt, ByteUtil.getBytes(blockIndex));
                xorU = currentU = prf.doFinal(inputBytes);
            } else {
                currentU = prf.doFinal(lastU);
                for (int j = 0; j < currentU.length; ++j) {
                    xorU[j] = (byte)(currentU[j] ^ xorU[j]);
                }
            }
            lastU = currentU;
        }
        return xorU;
    }
}

