/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.wrapper.pingidforworkforce;

import com.pingidentity.integrations.provisioner.pingidforworkforce.ResourceFieldKey;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingidforworkforce.resource.User;
import com.pingidentity.saas.definition.pingidforworkforce.SaasUser;
import com.pingidentity.saas.prov_pingid.shade.com.google.gson.annotations.SerializedName;
import com.pingidentity.saas.wrapper.pingidforworkforce.ManagedDeviceNickname;
import com.pingidentity.saas.wrapper.pingidforworkforce.UserDevice;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.serialization.SerializationConstants;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONObject;

public class UserProfile
implements SaasUser,
SerializationConstants {
    @SerializedName(value="userName")
    private String username;
    @SerializedName(value="activateUser", alternate={"userEnabled"})
    private Boolean activateUser;
    @SerializedName(value="email")
    private String email;
    @SerializedName(value="fName", alternate={"fname"})
    private String fName;
    @SerializedName(value="lname", alternate={"lName"})
    private String lName;
    @SerializedName(value="role")
    private String role;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="devicesDetails")
    private List<UserDevice> devices;

    public UserProfile() {
    }

    public UserProfile(String username) {
        this.setUsername(username);
    }

    public UserProfile(ResourceAttributes attrs) {
        this.setUsername(attrs.getValueOf(ResourceFieldKey.USERNAME.getLabel()));
        this.setActivateUser(Boolean.valueOf(attrs.getValueOf(ResourceFieldKey.ACTIVATE_USER.getLabel())));
        this.setEmail(attrs.getValueOf(ResourceFieldKey.EMAIL.getLabel()));
        this.setfName(attrs.getValueOf(ResourceFieldKey.F_NAME.getLabel()));
        this.setlName(attrs.getValueOf(ResourceFieldKey.L_NAME.getLabel()));
        this.setStatus(attrs.getValueOf(ResourceFieldKey.STATUS.getLabel()));
        this.setRole("REGULAR");
    }

    @Override
    public User getCplUser() {
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.add(ResourceFieldKey.USERNAME.getLabel(), this.getUsername());
        attributes.add(ResourceFieldKey.ACTIVATE_USER.getLabel(), Boolean.toString(this.getActivateUser()));
        attributes.add(ResourceFieldKey.EMAIL.getLabel(), this.getEmail());
        attributes.add(ResourceFieldKey.F_NAME.getLabel(), this.getfName());
        attributes.add(ResourceFieldKey.L_NAME.getLabel(), this.getlName());
        attributes.add(ResourceFieldKey.STATUS.getLabel(), this.getStatus());
        this.devices = this.devices == null ? new ArrayList() : this.devices;
        this.devices.stream().filter(d -> ManagedDeviceNickname.EMAIL_1.getNickname().equals(d.getNickname())).findFirst().ifPresent(d -> attributes.add(ResourceFieldKey.MFA_EMAIL_1.getLabel(), d.getEmail()));
        this.devices.stream().filter(d -> ManagedDeviceNickname.EMAIL_2.getNickname().equals(d.getNickname())).findFirst().ifPresent(d -> attributes.add(ResourceFieldKey.MFA_EMAIL_2.getLabel(), d.getEmail()));
        this.devices.stream().filter(d -> ManagedDeviceNickname.EMAIL_3.getNickname().equals(d.getNickname())).findFirst().ifPresent(d -> attributes.add(ResourceFieldKey.MFA_EMAIL_3.getLabel(), d.getEmail()));
        this.devices.stream().filter(d -> ManagedDeviceNickname.SMS_1.getNickname().equals(d.getNickname())).findFirst().ifPresent(d -> attributes.add(ResourceFieldKey.MFA_SMS_1.getLabel(), d.getPhoneNumber()));
        this.devices.stream().filter(d -> ManagedDeviceNickname.SMS_2.getNickname().equals(d.getNickname())).findFirst().ifPresent(d -> attributes.add(ResourceFieldKey.MFA_SMS_2.getLabel(), d.getPhoneNumber()));
        this.devices.stream().filter(d -> ManagedDeviceNickname.SMS_3.getNickname().equals(d.getNickname())).findFirst().ifPresent(d -> attributes.add(ResourceFieldKey.MFA_SMS_3.getLabel(), d.getPhoneNumber()));
        this.devices.stream().filter(d -> ManagedDeviceNickname.VOICE_1.getNickname().equals(d.getNickname())).findFirst().ifPresent(d -> attributes.add(ResourceFieldKey.MFA_VOICE_1.getLabel(), d.getPhoneNumber()));
        this.devices.stream().filter(d -> ManagedDeviceNickname.VOICE_2.getNickname().equals(d.getNickname())).findFirst().ifPresent(d -> attributes.add(ResourceFieldKey.MFA_VOICE_2.getLabel(), d.getPhoneNumber()));
        this.devices.stream().filter(d -> ManagedDeviceNickname.VOICE_3.getNickname().equals(d.getNickname())).findFirst().ifPresent(d -> attributes.add(ResourceFieldKey.MFA_VOICE_3.getLabel(), d.getPhoneNumber()));
        User cplUser = new User(attributes, new ResourceUniqueId(this.getUsername()));
        return cplUser;
    }

    @Override
    public JSONObject getCreateJsonUser() {
        JSONObject jsonUser = new JSONObject();
        jsonUser.put((Object)"email", (Object)this.getEmail());
        jsonUser.put((Object)"fName", (Object)this.getfName());
        jsonUser.put((Object)"lname", (Object)this.getlName());
        jsonUser.put((Object)"userName", (Object)this.getUsername());
        jsonUser.put((Object)"role", (Object)this.getRole());
        jsonUser.put((Object)"activateUser", (Object)this.getActivateUser());
        return jsonUser;
    }

    @Override
    public JSONObject getUpdateJsonUser() {
        JSONObject jsonUser = new JSONObject();
        jsonUser.put((Object)"email", (Object)this.getEmail());
        jsonUser.put((Object)"fName", (Object)this.getfName());
        jsonUser.put((Object)"lName", (Object)this.getlName());
        jsonUser.put((Object)"userName", (Object)this.getUsername());
        jsonUser.put((Object)"role", (Object)this.getRole());
        return jsonUser;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Boolean getActivateUser() {
        return this.activateUser;
    }

    public void setActivateUser(Boolean activateUser) {
        this.activateUser = activateUser;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getfName() {
        return this.fName;
    }

    public void setfName(String fName) {
        this.fName = fName;
    }

    public String getlName() {
        return this.lName;
    }

    public void setlName(String lName) {
        this.lName = lName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<UserDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(List<UserDevice> devices) {
        this.devices = devices;
    }
}

