/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.wrapper.pingidforworkforce.http;

import com.pingidentity.integrations.provisioner.pingidforworkforce.ConnectionFieldKey;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ResourceFieldKey;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceCollisionException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceNotFoundException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceNotModifiedException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceUnknownStateException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceAuthenticationException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceUnavailableException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceUnknownStateException;
import com.pingidentity.io.cpl.pingidforworkforce.request.ConnectionFields;
import com.pingidentity.io.cpl.pingidforworkforce.resource.Resource;
import com.pingidentity.io.cpl.pingidforworkforce.resource.User;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.HttpEntity;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.HttpResponse;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.ParseException;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.StatusLine;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.util.EntityUtils;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.base64url.Base64;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.jws.JsonWebSignature;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.keys.HmacKey;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.PingIDForWorkforceErrorCode;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.PingIDForWorkforceStatusCode;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.ResponseError;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.Validator;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.serialization.PingIDForWorkforceSerializer;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.serialization.SerializationException;
import com.pingidentity.saas.wrapper.pingidforworkforce.http.serialization.Serializer;
import java.io.IOException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PingIDForWorkforceValidator
implements Validator {
    final String MESSAGE = "PingIDForWorkforce responded with the message: %2s";
    private final Serializer serializer = new PingIDForWorkforceSerializer();

    @Override
    public void validateFullRequest(Resource resource, HttpResponse response, ConnectionFields connectionFields) throws ServiceException, ResourceException, SerializationException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        String body = "";
        String responseBody = "";
        if (this.successful(statusCode)) {
            return;
        }
        this.forbidden(statusCode, resource, response, connectionFields);
        this.serverError(statusCode, resource, response, connectionFields);
        if (statusCode == PingIDForWorkforceStatusCode.BAD_REQUEST.getStatusCode()) {
            try {
                body = this.getResponseBody(resource, response);
                ResponseError error = this.parseResponseError(body, connectionFields);
                responseBody = this.serializer.serialize(error);
                if (this.userNotFoundException(error)) {
                    throw new ResourceNotFoundException(resource, String.format("PingIDForWorkforce responded with the message: %2s", responseBody), this.getIdentifier(resource));
                }
                if (this.userNotModifiedException(error)) {
                    throw new ResourceNotModifiedException(resource, String.format("PingIDForWorkforce responded with the message: %2s", responseBody), this.getIdentifier(resource));
                }
                if (this.userCollisionException(error)) {
                    throw new ResourceCollisionException(resource, String.format("PingIDForWorkforce responded with the message: %2s", responseBody), this.getIdentifier(resource));
                }
            }
            catch (IOException e) {
                throw new ResourceNotModifiedException(resource, String.format("PingIDForWorkforce responded with the message: %2s", responseBody), this.getIdentifier(resource));
            }
            catch (ParseException e) {
                throw new ResourceNotModifiedException(resource, String.format("PingIDForWorkforce responded with the message: %2s", responseBody), this.getIdentifier(resource));
            }
            throw new ResourceNotModifiedException(resource, String.format("PingIDForWorkforce responded with the message: %2s", responseBody), this.getIdentifier(resource));
        }
        throw new ResourceUnknownStateException(resource, String.format("PingIDForWorkforce responded with the message: %2s", responseBody), this.getIdentifier(resource));
    }

    @Override
    public void validateServiceRequest(Resource resource, HttpResponse response, ConnectionFields connectionFields) throws ServiceException, SerializationException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        String body = "";
        String responseBody = "";
        if (this.successful(statusCode)) {
            return;
        }
        this.forbidden(statusCode, resource, response, connectionFields);
        this.serverError(statusCode, resource, response, connectionFields);
        if (statusCode == PingIDForWorkforceStatusCode.BAD_REQUEST.getStatusCode()) {
            try {
                body = this.getResponseBody(resource, response);
                ResponseError error = this.parseResponseError(body, connectionFields);
                responseBody = this.serializer.serialize(error);
                if (this.userNotFoundException(error)) {
                    throw new ServiceUnknownStateException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
                }
                if (body.length() > 0) {
                    throw new ServiceAuthenticationException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
                }
            }
            catch (IOException e) {
                throw new ServiceAuthenticationException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
            }
            catch (ParseException e) {
                throw new ServiceAuthenticationException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
            }
            throw new ServiceAuthenticationException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
        }
        throw new ServiceUnknownStateException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
    }

    private boolean successful(int statusCode) {
        return statusCode == PingIDForWorkforceStatusCode.UPDATED.getStatusCode();
    }

    private void serverError(int statusCode, Resource resource, HttpResponse response, ConnectionFields connectionFields) throws ServiceException, SerializationException {
        String body = "";
        String responseBody = "";
        if (statusCode == PingIDForWorkforceStatusCode.SERVER_ERROR.getStatusCode()) {
            try {
                body = this.getResponseBody(resource, response);
                ResponseError error = this.parseResponseError(body, connectionFields);
                responseBody = this.serializer.serialize(error);
                throw new ServiceUnavailableException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
            }
            catch (IOException e) {
                throw new ServiceUnavailableException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
            }
            catch (ParseException e) {
                throw new ServiceUnknownStateException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
            }
        }
    }

    private void forbidden(int statusCode, Resource resource, HttpResponse response, ConnectionFields connectionFields) throws ServiceException, SerializationException {
        String responseBody = "";
        if (statusCode == PingIDForWorkforceStatusCode.FORBIDDEN.getStatusCode() || statusCode == PingIDForWorkforceStatusCode.UNAUTHORIZED.getStatusCode()) {
            try {
                String body = this.getResponseBody(resource, response);
                ResponseError error = this.parseResponseError(body, connectionFields);
                responseBody = this.serializer.serialize(error);
                throw new ServiceAuthenticationException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
            }
            catch (IOException e) {
                throw new ServiceAuthenticationException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
            }
            catch (ParseException e) {
                throw new ServiceUnknownStateException(String.format("PingIDForWorkforce responded with the message: %2s", responseBody));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseBody(Resource resource, HttpResponse response) throws IOException, ParseException {
        String body = "";
        if (response.getEntity() != null) {
            HttpEntity entity = response.getEntity();
            try {
                body = EntityUtils.toString(entity);
            }
            finally {
                if (entity != null) {
                    EntityUtils.consumeQuietly(entity);
                }
            }
        }
        return body;
    }

    private String getIdentifier(Resource resource) {
        if (resource instanceof User) {
            return resource.getResourceAttributes().getValueOf(ResourceFieldKey.getSecondaryId().getLabel());
        }
        return "Unknown Resource type";
    }

    private ResponseError parseResponseError(String responseToken, ConnectionFields connectionFields) throws ServiceUnknownStateException {
        JSONParser parser = new JSONParser();
        JSONObject responsePayloadJSON = null;
        ResponseError errorInfo = new ResponseError();
        if (responseToken.contains("responseBody")) {
            try {
                responsePayloadJSON = (JSONObject)parser.parse(responseToken);
                responsePayloadJSON = (JSONObject)responsePayloadJSON.get((Object)"responseBody");
            }
            catch (org.json.simple.parser.ParseException e) {
                throw new ServiceUnknownStateException(String.format("Unable to parse Response Token: %s.", e.getMessage()));
            }
        }
        try {
            JsonWebSignature responseJWS = new JsonWebSignature();
            responseJWS.setCompactSerialization(responseToken);
            HmacKey key = new HmacKey(Base64.decode((String)connectionFields.get(ConnectionFieldKey.BASE64_KEY.getKey())));
            responseJWS.setKey(key);
            responsePayloadJSON = (JSONObject)parser.parse(responseJWS.getPayload());
            if (responsePayloadJSON.containsKey((Object)"responseBody")) {
                responsePayloadJSON = (JSONObject)responsePayloadJSON.get((Object)"responseBody");
            }
        }
        catch (Exception e) {
            throw new ServiceUnknownStateException(String.format("Unable to parse Response Token: %s.", e.getMessage()));
        }
        if (responsePayloadJSON != null) {
            errorInfo.setErrorId((Long)responsePayloadJSON.get((Object)"errorId"));
            errorInfo.setErrorMessage((String)responsePayloadJSON.get((Object)"errorMsg"));
            errorInfo.setUniqueMessageId((String)responsePayloadJSON.get((Object)"uniqueMsgId"));
        } else {
            errorInfo.setErrorId(501L);
            errorInfo.setErrorMessage("Could not parse JWS");
            errorInfo.setUniqueMessageId("");
        }
        return errorInfo;
    }

    private boolean userNotModifiedException(ResponseError error) {
        return error.getErrorId() == PingIDForWorkforceErrorCode.FAILED_TRANSACTION.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.FAILED_USER_ACTIVATION.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.INVALID_INPUT.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.FAILED_USER_DELETE.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.FAILED_USER_ACTIVATION_INACTIVE.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.FAILED_USER_SUSPENSION.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.FAILED_USER_SUSPENSION_INACTIVE.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.UNABLE_TO_ACCESS_DATABASE.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.FAILED_USER_UPDATE.getErrorCode();
    }

    private boolean userCollisionException(ResponseError error) {
        return error.getErrorId() == PingIDForWorkforceErrorCode.USER_ALREADY_EXISTS.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.USER_ALREADY_EXISTS_UNIQUE_USERNAME.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.USERNAME_ALREADY_EXISTS.getErrorCode();
    }

    private boolean userNotFoundException(ResponseError error) {
        return error.getErrorId() == PingIDForWorkforceErrorCode.USER_DOES_NOT_EXIST.getErrorCode() || error.getErrorId() == PingIDForWorkforceErrorCode.UNDEFINED_USER.getErrorCode();
    }
}

