/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.saas.wrapper.pingidforworkforce.request_builder;

import com.pingidentity.integrations.provisioner.pingidforworkforce.ConnectionFieldKey;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ResourceFieldKey;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ResourceUnknownStateException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceException;
import com.pingidentity.io.cpl.pingidforworkforce.exception.ServiceUnknownStateException;
import com.pingidentity.io.cpl.pingidforworkforce.request.ConnectionFields;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingidforworkforce.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingidforworkforce.resource.User;
import com.pingidentity.saas.definition.pingidforworkforce.UserRequestBuilder;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.client.methods.HttpPost;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.client.methods.HttpUriRequest;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.entity.ContentType;
import com.pingidentity.saas.prov_pingid.shade.org.apache.http.entity.StringEntity;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.base64url.Base64;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.jws.JsonWebSignature;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.keys.HmacKey;
import com.pingidentity.saas.prov_pingid.shade.org.jose4j.lang.JoseException;
import com.pingidentity.saas.wrapper.pingidforworkforce.UserProfile;
import com.pingidentity.saas.wrapper.pingidforworkforce.request_builder.PingIDForWorkforceEndpoint;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.simple.JSONObject;

public class PingIDForWorkforceUserRequestBuilder
implements UserRequestBuilder {
    private static final String SCHEME = "https://";
    private static final String API_VERSION = "4.9";

    @Override
    public HttpUriRequest buildCreateUserRequest(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        String updateUserUrl = this.getUrl(PingIDForWorkforceEndpoint.ADD_USER, connectionFields);
        UserProfile userProfile = new UserProfile(user.getResourceAttributes());
        JSONObject jsonUser = userProfile.getCreateJsonUser();
        String requestToken = this.buildRequestToken(jsonUser, connectionFields);
        HttpPost httpRequest = new HttpPost(updateUserUrl);
        StringEntity entity = new StringEntity(requestToken, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildGetUserRequest(ConnectionFields connectionFields, ResourceUniqueId id) throws ResourceException, ServiceException {
        String getUserUrl = this.getUrl(PingIDForWorkforceEndpoint.GET_USER, connectionFields);
        UserProfile userProfile = new UserProfile(id.getId());
        JSONObject user = userProfile.getUpdateJsonUser();
        String requestToken = this.buildRequestToken(user, connectionFields);
        HttpPost httpRequest = new HttpPost(getUserUrl);
        StringEntity entity = new StringEntity(requestToken, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildUpdateUserRequest(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        String updateUserUrl = this.getUrl(PingIDForWorkforceEndpoint.UPDATE_USER, connectionFields);
        UserProfile userProfile = new UserProfile(user.getResourceAttributes());
        JSONObject jsonUser = userProfile.getUpdateJsonUser();
        String requestToken = this.buildRequestToken(jsonUser, connectionFields);
        HttpPost httpRequest = new HttpPost(updateUserUrl);
        StringEntity entity = new StringEntity(requestToken, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildDeleteUserRequest(ConnectionFields connectionFields, ResourceUniqueId id) throws ResourceException, ServiceUnknownStateException {
        String deleteUserUrl = this.getUrl(PingIDForWorkforceEndpoint.DELETE_USER, connectionFields);
        UserProfile userProfile = new UserProfile(id.getId());
        JSONObject user = userProfile.getUpdateJsonUser();
        String requestToken = this.buildRequestToken(user, connectionFields);
        HttpPost httpRequest = new HttpPost(deleteUserUrl);
        StringEntity entity = new StringEntity(requestToken, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildActivateOrSuspendUserRequest(ConnectionFields connectionFields, User user) throws ResourceUnknownStateException, ServiceUnknownStateException {
        ResourceAttributes attrs = user.getResourceAttributes();
        String activateSuspendUrl = null;
        String status = attrs.getValueOf(ResourceFieldKey.ACTIVATE_USER.getLabel());
        activateSuspendUrl = Boolean.FALSE.toString().equalsIgnoreCase(status) ? this.getUrl(PingIDForWorkforceEndpoint.SUSPEND_USER, connectionFields) : this.getUrl(PingIDForWorkforceEndpoint.ACTIVATE_USER, connectionFields);
        UserProfile userProfile = new UserProfile(user.getResourceUniqueId().getId());
        JSONObject jsonUser = userProfile.getUpdateJsonUser();
        String requestToken = this.buildRequestToken(jsonUser, connectionFields);
        HttpPost httpRequest = new HttpPost(activateSuspendUrl);
        StringEntity entity = new StringEntity(requestToken, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    private String getUrl(PingIDForWorkforceEndpoint type, ConnectionFields connectionFields) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(SCHEME);
        urlBuilder.append(this.getFormattedDomain(connectionFields));
        urlBuilder.append(type.getEndpoint());
        return urlBuilder.toString();
    }

    public String buildRequestToken(JSONObject requestBody, ConnectionFields connectionFields) throws ResourceUnknownStateException, ServiceUnknownStateException {
        JSONObject requestHeader = this.buildRequestHeader(connectionFields);
        JSONObject payload = new JSONObject();
        payload.put((Object)"reqHeader", (Object)requestHeader);
        payload.put((Object)"reqBody", (Object)requestBody);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("HS256");
        jws.setHeader("org_alias", (String)connectionFields.get(ConnectionFieldKey.ORG_ALIAS.getKey()));
        jws.setHeader("token", (String)connectionFields.get(ConnectionFieldKey.TOKEN.getKey()));
        jws.setPayload(payload.toJSONString());
        HmacKey key = new HmacKey(Base64.decode((String)connectionFields.get(ConnectionFieldKey.BASE64_KEY.getKey())));
        jws.setKey(key);
        String jwsCompactSerialization = null;
        try {
            jwsCompactSerialization = jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new ServiceUnknownStateException(String.format("Unable to create Request Token for User: %s.  Error Message: %s", requestBody.get((Object)"userName"), e.getMessage()));
        }
        return jwsCompactSerialization;
    }

    private JSONObject buildRequestHeader(ConnectionFields connectionFields) {
        JSONObject reqHeader = new JSONObject();
        reqHeader.put((Object)"locale", (Object)"en");
        reqHeader.put((Object)"orgAlias", connectionFields.get(ConnectionFieldKey.ORG_ALIAS.getKey()));
        reqHeader.put((Object)"secretKey", connectionFields.get(ConnectionFieldKey.TOKEN.getKey()));
        reqHeader.put((Object)"timestamp", (Object)this.getCurrentTimeStamp());
        reqHeader.put((Object)"version", (Object)API_VERSION);
        return reqHeader;
    }

    private String getCurrentTimeStamp() {
        Date currentDate = new Date();
        SimpleDateFormat PingIDDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return PingIDDateFormat.format(currentDate);
    }

    private String getFormattedDomain(ConnectionFields connectionFields) {
        String domain = (String)connectionFields.get(ConnectionFieldKey.DOMAIN.getKey().trim());
        if ("/".equals(domain.substring(domain.length() - 1))) {
            domain = domain.substring(0, domain.length() - 1);
        }
        return domain;
    }
}

