/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.extensions.CancelExtendedRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class IdentifyUniqueAttributeConflicts
extends LDAPCommandLineTool
implements SearchResultListener {
    @NotNull
    private static final String BEHAVIOR_UNIQUE_WITHIN_ATTR = "unique-within-each-attribute";
    @NotNull
    private static final String BEHAVIOR_UNIQUE_ACROSS_ATTRS_INCLUDING_SAME = "unique-across-all-attributes-including-in-same-entry";
    @NotNull
    private static final String BEHAVIOR_UNIQUE_ACROSS_ATTRS_EXCEPT_SAME = "unique-across-all-attributes-except-in-same-entry";
    @NotNull
    private static final String BEHAVIOR_UNIQUE_IN_COMBINATION = "unique-in-combination";
    private static final int DEFAULT_TIME_LIMIT_SECONDS = 10;
    private static final long serialVersionUID = 4216291898088659008L;
    @NotNull
    private final AtomicBoolean timeLimitExceeded = new AtomicBoolean(false);
    @NotNull
    private final AtomicLong entriesExamined = new AtomicLong(0L);
    @NotNull
    private final AtomicLong combinationConflictCounts = new AtomicLong(0L);
    private boolean allowConflictsInSameEntry = false;
    private boolean uniqueAcrossAttributes = false;
    private boolean uniqueInCombination = false;
    @Nullable
    private DNArgument baseDNArgument = null;
    @Nullable
    private FilterArgument filterArgument = null;
    @Nullable
    private IntegerArgument pageSizeArgument = null;
    @Nullable
    private IntegerArgument timeLimitArgument = null;
    @Nullable
    private LDAPConnectionPool findConflictsPool = null;
    @NotNull
    private final Map<String, AtomicLong> conflictCounts = new TreeMap<String, AtomicLong>();
    @Nullable
    private String[] attributes = null;
    @Nullable
    private String[] baseDNs = null;
    @Nullable
    private StringArgument attributeArgument = null;
    @Nullable
    private StringArgument multipleAttributeBehaviorArgument = null;

    public static void main(String ... args) {
        ResultCode resultCode = IdentifyUniqueAttributeConflicts.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@NotNull String[] args, @Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        IdentifyUniqueAttributeConflicts tool = new IdentifyUniqueAttributeConflicts(outStream, errStream);
        return tool.runTool(args);
    }

    public IdentifyUniqueAttributeConflicts(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "identify-unique-attribute-conflicts";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "This tool may be used to identify unique attribute conflicts.  That is, it may identify values of one or more attributes which are supposed to exist only in a single entry but are found in multiple entries.";
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "7.0.0";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        String description = "The search base DN(s) to use to find entries with attributes for which to find uniqueness conflicts.  At least one base DN must be specified.";
        this.baseDNArgument = new DNArgument(Character.valueOf('b'), "baseDN", true, 0, "{dn}", description);
        this.baseDNArgument.addLongIdentifier("base-dn", true);
        parser.addArgument(this.baseDNArgument);
        description = "A filter that will be used to identify the set of entries in which to identify uniqueness conflicts.  If this is not specified, then all entries containing the target attribute(s) will be examined.";
        this.filterArgument = new FilterArgument(Character.valueOf('f'), "filter", false, 1, "{filter}", description);
        parser.addArgument(this.filterArgument);
        description = "The attributes for which to find uniqueness conflicts.  At least one attribute must be specified, and each attribute must be indexed for equality searches.";
        this.attributeArgument = new StringArgument(Character.valueOf('A'), "attribute", true, 0, "{attr}", description);
        parser.addArgument(this.attributeArgument);
        description = "Indicates the behavior to exhibit if multiple unique attributes are provided.  Allowed values are 'unique-within-each-attribute' (indicates that each value only needs to be unique within its own attribute type), 'unique-across-all-attributes-including-in-same-entry' (indicates that each value needs to be unique across all of the specified attributes), 'unique-across-all-attributes-except-in-same-entry' (indicates each value needs to be unique across all of the specified attributes, except that multiple attributes in the same entry are allowed to share the same value), and 'unique-in-combination' (indicates that every combination of the values of the specified attributes must be unique across each entry).";
        Set<String> allowedValues = StaticUtils.setOf(BEHAVIOR_UNIQUE_WITHIN_ATTR, BEHAVIOR_UNIQUE_ACROSS_ATTRS_INCLUDING_SAME, BEHAVIOR_UNIQUE_ACROSS_ATTRS_EXCEPT_SAME, BEHAVIOR_UNIQUE_IN_COMBINATION);
        this.multipleAttributeBehaviorArgument = new StringArgument(Character.valueOf('m'), "multipleAttributeBehavior", false, 1, "{behavior}", description, allowedValues, BEHAVIOR_UNIQUE_WITHIN_ATTR);
        this.multipleAttributeBehaviorArgument.addLongIdentifier("multiple-attribute-behavior", true);
        parser.addArgument(this.multipleAttributeBehaviorArgument);
        description = "The maximum number of entries to retrieve at a time when attempting to find uniqueness conflicts.  This requires that the authenticated user have permission to use the simple paged results control, but it can avoid problems with the server sending entries too quickly for the client to handle.  By default, the simple paged results control will not be used.";
        this.pageSizeArgument = new IntegerArgument(Character.valueOf('z'), "simplePageSize", false, 1, "{num}", description, 1, Integer.MAX_VALUE);
        this.pageSizeArgument.addLongIdentifier("simple-page-size", true);
        parser.addArgument(this.pageSizeArgument);
        description = "The time limit in seconds that will be used for search requests attempting to identify conflicts for each value of any of the unique attributes.  This time limit is used to avoid sending expensive unindexed search requests that can consume significant server resources.  If any of these search operations fails in a way that indicates the requested time limit was exceeded, the tool will abort its processing.  A value of zero indicates that no time limit will be enforced.  If this argument is not provided, a default time limit of 10 will be used.";
        this.timeLimitArgument = new IntegerArgument(Character.valueOf('l'), "timeLimitSeconds", false, 1, "{num}", description, 0, Integer.MAX_VALUE, 10);
        this.timeLimitArgument.addLongIdentifier("timeLimit", true);
        this.timeLimitArgument.addLongIdentifier("time-limit-seconds", true);
        this.timeLimitArgument.addLongIdentifier("time-limit", true);
        parser.addArgument(this.timeLimitArgument);
    }

    @Override
    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setResponseTimeoutMillis(0L);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        LDAPConnectionPool findUniqueAttributesPool;
        List<String> attrList = this.attributeArgument.getValues();
        String multiAttrBehavior = this.multipleAttributeBehaviorArgument.getValue();
        if (attrList.size() > 1) {
            if (multiAttrBehavior.equalsIgnoreCase(BEHAVIOR_UNIQUE_ACROSS_ATTRS_INCLUDING_SAME)) {
                this.uniqueAcrossAttributes = true;
                this.uniqueInCombination = false;
                this.allowConflictsInSameEntry = false;
            } else if (multiAttrBehavior.equalsIgnoreCase(BEHAVIOR_UNIQUE_ACROSS_ATTRS_EXCEPT_SAME)) {
                this.uniqueAcrossAttributes = true;
                this.uniqueInCombination = false;
                this.allowConflictsInSameEntry = true;
            } else if (multiAttrBehavior.equalsIgnoreCase(BEHAVIOR_UNIQUE_IN_COMBINATION)) {
                this.uniqueAcrossAttributes = false;
                this.uniqueInCombination = true;
                this.allowConflictsInSameEntry = true;
            } else {
                this.uniqueAcrossAttributes = false;
                this.uniqueInCombination = false;
                this.allowConflictsInSameEntry = true;
            }
        } else {
            this.uniqueAcrossAttributes = false;
            this.uniqueInCombination = false;
            this.allowConflictsInSameEntry = true;
        }
        List<DN> dnList = this.baseDNArgument.getValues();
        this.baseDNs = new String[dnList.size()];
        for (int i = 0; i < this.baseDNs.length; ++i) {
            this.baseDNs[i] = dnList.get(i).toString();
        }
        try {
            findUniqueAttributesPool = this.getConnectionPool(1, 1);
            findUniqueAttributesPool.setRetryFailedOperationsDueToInvalidConnections(true);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err("Unable to establish a connection to the directory server:  ", StaticUtils.getExceptionMessage(le));
            return le.getResultCode();
        }
        try {
            int i;
            Filter filter;
            try {
                this.findConflictsPool = this.getConnectionPool(1, 1);
                this.findConflictsPool.setRetryFailedOperationsDueToInvalidConnections(true);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err("Unable to establish a connection to the directory server:  ", StaticUtils.getExceptionMessage(le));
                ResultCode resultCode = le.getResultCode();
                findUniqueAttributesPool.close();
                if (this.findConflictsPool != null) {
                    this.findConflictsPool.close();
                }
                return resultCode;
            }
            this.attributes = new String[attrList.size()];
            attrList.toArray(this.attributes);
            if (this.attributes.length == 1) {
                filter = Filter.createPresenceFilter(this.attributes[0]);
                this.conflictCounts.put(this.attributes[0], new AtomicLong(0L));
            } else if (this.uniqueInCombination) {
                Filter[] andComps = new Filter[this.attributes.length];
                for (i = 0; i < this.attributes.length; ++i) {
                    andComps[i] = Filter.createPresenceFilter(this.attributes[i]);
                    this.conflictCounts.put(this.attributes[i], new AtomicLong(0L));
                }
                filter = Filter.createANDFilter(andComps);
            } else {
                Object[] orComps = new Filter[this.attributes.length];
                for (i = 0; i < this.attributes.length; ++i) {
                    orComps[i] = Filter.createPresenceFilter(this.attributes[i]);
                    this.conflictCounts.put(this.attributes[i], new AtomicLong(0L));
                }
                filter = Filter.createORFilter((Filter[])orComps);
            }
            if (this.filterArgument.isPresent()) {
                filter = Filter.createANDFilter(this.filterArgument.getValue(), filter);
            }
            for (String baseDN : this.baseDNs) {
                ASN1OctetString cookie = null;
                while (!this.timeLimitExceeded.get()) {
                    SimplePagedResultsControl pagedResultsResponse;
                    SearchResult searchResult;
                    SearchRequest searchRequest = new SearchRequest((SearchResultListener)this, baseDN, SearchScope.SUB, filter, this.attributes);
                    if (this.pageSizeArgument.isPresent()) {
                        searchRequest.addControl(new SimplePagedResultsControl(this.pageSizeArgument.getValue(), cookie, false));
                    }
                    try {
                        searchResult = findUniqueAttributesPool.search(searchRequest);
                    }
                    catch (LDAPSearchException lse) {
                        Debug.debugException(lse);
                        try {
                            searchResult = this.findConflictsPool.search(searchRequest);
                        }
                        catch (LDAPSearchException lse2) {
                            Debug.debugException(lse2);
                            searchResult = lse2.getSearchResult();
                        }
                    }
                    if (searchResult.getResultCode() != ResultCode.SUCCESS) {
                        this.err("An error occurred while attempting to search for unique attributes in entries below " + (String)baseDN + ":  " + searchResult.getDiagnosticMessage());
                        ResultCode lse = searchResult.getResultCode();
                        return lse;
                    }
                    try {
                        pagedResultsResponse = SimplePagedResultsControl.get(searchResult);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.err("An error occurred while attempting to decode a simple paged results response control in the response to a search for entries below " + (String)baseDN + ":  " + StaticUtils.getExceptionMessage(le));
                        ResultCode resultCode = le.getResultCode();
                        findUniqueAttributesPool.close();
                        if (this.findConflictsPool != null) {
                            this.findConflictsPool.close();
                        }
                        return resultCode;
                    }
                    if (pagedResultsResponse != null) {
                        cookie = pagedResultsResponse.moreResultsToReturn() ? pagedResultsResponse.getCookie() : null;
                    }
                    if (cookie != null) continue;
                }
            }
            boolean conflictFound = false;
            if (this.uniqueInCombination) {
                long count = this.combinationConflictCounts.get();
                if (count > 0L) {
                    conflictFound = true;
                    this.err("Found " + count + " total conflicts.");
                }
            } else {
                for (Map.Entry<String, AtomicLong> e : this.conflictCounts.entrySet()) {
                    long numConflicts = e.getValue().get();
                    if (numConflicts <= 0L) continue;
                    if (!conflictFound) {
                        this.err(new Object[0]);
                        conflictFound = true;
                    }
                    this.err("Found " + numConflicts + " unique value conflicts in attribute " + e.getKey());
                }
            }
            if (conflictFound) {
                ResultCode resultCode = ResultCode.CONSTRAINT_VIOLATION;
                return resultCode;
            }
            if (this.timeLimitExceeded.get()) {
                ResultCode resultCode = ResultCode.TIME_LIMIT_EXCEEDED;
                return resultCode;
            }
            this.out("No unique attribute conflicts were found.");
            ResultCode resultCode = ResultCode.SUCCESS;
            return resultCode;
        }
        finally {
            findUniqueAttributesPool.close();
            if (this.findConflictsPool != null) {
                this.findConflictsPool.close();
            }
        }
    }

    public long getCombinationConflictCounts() {
        return this.combinationConflictCounts.get();
    }

    @NotNull
    public Map<String, AtomicLong> getConflictCounts() {
        return Collections.unmodifiableMap(this.conflictCounts);
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=john.doe,ou=People,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--attribute", "uid", "--simplePageSize", "100"};
        exampleMap.put(args, "Identify any values of the uid attribute that are not unique across all entries below dc=example,dc=com.");
        return exampleMap;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void searchEntryReturned(@NotNull SearchResultEntry searchEntry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkForConflictsInCombination(@NotNull SearchResultEntry entry) {
        ArrayList<Filter> andComponents = new ArrayList<Filter>(this.attributes.length + 1);
        block12: for (String attrName : this.attributes) {
            LinkedHashSet<Filter> values = new LinkedHashSet<Filter>(StaticUtils.computeMapCapacity(5));
            for (Attribute a : entry.getAttributesWithOptions(attrName, null)) {
                for (byte[] value : a.getValueByteArrays()) {
                    Filter equalityFilter = Filter.createEqualityFilter(attrName, value);
                    values.add(Filter.createEqualityFilter(attrName, value));
                }
            }
            switch (values.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    andComponents.add((Filter)values.iterator().next());
                    continue block12;
                }
                default: {
                    andComponents.add(Filter.createORFilter(values));
                }
            }
        }
        if (this.filterArgument.isPresent()) {
            andComponents.add(this.filterArgument.getValue());
        }
        Filter filter = Filter.createANDFilter(andComponents);
        block15: for (DN baseDN : this.baseDNArgument.getValues()) {
            SearchResult searchResult;
            SearchRequest searchRequest = new SearchRequest(baseDN.toString(), SearchScope.SUB, DereferencePolicy.NEVER, 2, (int)this.timeLimitArgument.getValue(), false, filter, "1.1");
            try {
                searchResult = this.findConflictsPool.search(searchRequest);
            }
            catch (LDAPSearchException lse) {
                Debug.debugException(lse);
                if (lse.getResultCode() == ResultCode.TIME_LIMIT_EXCEEDED) {
                    this.timeLimitExceeded.set(true);
                    try {
                        this.findConflictsPool.processExtendedOperation(new CancelExtendedRequest(entry.getMessageID()));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                    this.err("A server-side time limit was exceeded when searching below base DN '" + baseDN + "' with filter '" + filter + "', which likely means that the search request is not indexed in the server.  Check the server configuration to ensure that any appropriate indexes are in place.  To indicate that searches should not request any time limit, use the " + this.timeLimitArgument.getIdentifierString() + " to indicate a time limit of zero seconds.");
                    return;
                }
                if (lse.getResultCode().isConnectionUsable()) {
                    searchResult = lse.getSearchResult();
                }
                try {
                    searchResult = this.findConflictsPool.search(searchRequest);
                }
                catch (LDAPSearchException lse2) {
                    Debug.debugException(lse2);
                    searchResult = lse2.getSearchResult();
                }
            }
            for (SearchResultEntry e : searchResult.getSearchEntries()) {
                try {
                    if (DN.equals(entry.getDN(), e.getDN())) {
                        continue;
                    }
                }
                catch (Exception ex) {
                    Debug.debugException(ex);
                }
                this.err("Entry '" + entry.getDN() + " has a combination of values that are also present in entry '" + e.getDN() + "'.");
                this.combinationConflictCounts.incrementAndGet();
                break block15;
            }
            if (searchResult.getResultCode() == ResultCode.SUCCESS) continue;
            this.err("An error occurred while attempting to search for conflicts  with entry '" + entry.getDN() + "' below '" + baseDN + "':  " + searchResult.getDiagnosticMessage());
            this.combinationConflictCounts.incrementAndGet();
            break;
        }
    }

    @Override
    public void searchReferenceReturned(@NotNull SearchResultReference searchReference) {
    }
}

