/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.DebugType;
import com.unboundid.util.MinimalLogFormatter;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONBuffer;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Debug
implements Serializable {
    @NotNull
    public static final String PROPERTY_DEBUG_ENABLED = "com.unboundid.ldap.sdk.debug.enabled";
    @NotNull
    public static final String PROPERTY_INCLUDE_STACK_TRACE = "com.unboundid.ldap.sdk.debug.includeStackTrace";
    @NotNull
    public static final String PROPERTY_DEBUG_LEVEL = "com.unboundid.ldap.sdk.debug.level";
    @NotNull
    public static final String PROPERTY_DEBUG_TYPE = "com.unboundid.ldap.sdk.debug.type";
    @NotNull
    public static final String PROPERTY_INCLUDE_CAUSE_IN_EXCEPTION_MESSAGES = "com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages";
    @NotNull
    public static final String PROPERTY_INCLUDE_STACK_TRACE_IN_EXCEPTION_MESSAGES = "com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages";
    @NotNull
    public static final String PROPERTY_DEBUG_FILE = "com.unboundid.ldap.sdk.debug.file";
    @NotNull
    public static final String LOGGER_NAME = "com.unboundid.ldap.sdk";
    @NotNull
    private static final Logger logger = Logger.getLogger("com.unboundid.ldap.sdk");
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_FORMATTERS = new ThreadLocal();
    private static final long serialVersionUID = -6079754380415146030L;
    private static boolean debugEnabled;
    private static boolean includeStackTrace;
    @NotNull
    private static EnumSet<DebugType> debugTypes;

    private Debug() {
    }

    public static void initialize() {
        includeStackTrace = false;
        debugEnabled = false;
        debugTypes = EnumSet.allOf(DebugType.class);
        StaticUtils.setLoggerLevel(logger, Level.ALL);
    }

    public static void initialize(@Nullable Properties properties) {
        String levelProp;
        String typesProp;
        String stackProp;
        Debug.initialize();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String enabledProp = properties.getProperty(PROPERTY_DEBUG_ENABLED);
        if (enabledProp != null && !enabledProp.isEmpty()) {
            if (enabledProp.equalsIgnoreCase("true")) {
                debugEnabled = true;
            } else if (enabledProp.equalsIgnoreCase("false")) {
                debugEnabled = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + enabledProp + "' for property " + PROPERTY_DEBUG_ENABLED + ".  The value must be either 'true' or 'false'.");
            }
        }
        if ((stackProp = properties.getProperty(PROPERTY_INCLUDE_STACK_TRACE)) != null && !stackProp.isEmpty()) {
            if (stackProp.equalsIgnoreCase("true")) {
                includeStackTrace = true;
            } else if (stackProp.equalsIgnoreCase("false")) {
                includeStackTrace = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + stackProp + "' for property " + PROPERTY_INCLUDE_STACK_TRACE + ".  The value must be either 'true' or 'false'.");
            }
        }
        if ((typesProp = properties.getProperty(PROPERTY_DEBUG_TYPE)) != null && !typesProp.isEmpty()) {
            debugTypes = EnumSet.noneOf(DebugType.class);
            StringTokenizer t = new StringTokenizer(typesProp, ", ");
            while (t.hasMoreTokens()) {
                String debugTypeName = t.nextToken();
                DebugType debugType = DebugType.forName(debugTypeName);
                if (debugType == null) {
                    throw new IllegalArgumentException("Invalid value '" + debugTypeName + "' for property " + PROPERTY_DEBUG_TYPE + ".  Allowed values include:  " + DebugType.getTypeNameList() + '.');
                }
                debugTypes.add(debugType);
            }
        }
        if ((levelProp = properties.getProperty(PROPERTY_DEBUG_LEVEL)) != null && !levelProp.isEmpty()) {
            StaticUtils.setLoggerLevel(logger, Level.parse(levelProp));
        }
    }

    @NotNull
    public static Logger getLogger() {
        return logger;
    }

    public static boolean debugEnabled() {
        return debugEnabled;
    }

    public static boolean debugEnabled(@NotNull DebugType debugType) {
        return debugEnabled && debugTypes.contains((Object)debugType);
    }

    public static void setEnabled(boolean enabled) {
        debugTypes = EnumSet.allOf(DebugType.class);
        debugEnabled = enabled;
    }

    public static void setEnabled(boolean enabled, @Nullable Set<DebugType> types) {
        debugTypes = types == null || types.isEmpty() ? EnumSet.allOf(DebugType.class) : EnumSet.copyOf(types);
        debugEnabled = enabled;
    }

    public static boolean includeStackTrace() {
        return includeStackTrace;
    }

    public static void setIncludeStackTrace(boolean includeStackTrace) {
        Debug.includeStackTrace = includeStackTrace;
    }

    @NotNull
    public static EnumSet<DebugType> getDebugTypes() {
        return debugTypes;
    }

    public static void debugException(@NotNull Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            Debug.debugException(Level.WARNING, t);
        }
    }

    public static void debugException(@NotNull Level l, @NotNull Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.EXCEPTION);
            Debug.addCaughtException(buffer, "caught-exception", t);
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer, t);
        }
    }

    public static void debugConnect(@NotNull String h, int p) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(Level.INFO, h, p, null);
        }
    }

    public static void debugConnect(@NotNull Level l, @NotNull String h, int p) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(l, h, p, null);
        }
    }

    public static void debugConnect(@NotNull String h, int p, @Nullable LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(Level.INFO, h, p, c);
        }
    }

    public static void debugConnect(@NotNull Level l, @NotNull String h, int p, @Nullable LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.CONNECT);
            buffer.appendString("connected-to-address", h);
            buffer.appendNumber("connected-to-port", p);
            if (c != null) {
                String connectionPoolName;
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectionName = c.getConnectionName();
                if (connectionName != null) {
                    buffer.appendString("connection-name", connectionName);
                }
                if ((connectionPoolName = c.getConnectionPoolName()) != null) {
                    buffer.appendString("connection-pool-name", connectionPoolName);
                }
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugDisconnect(@NotNull String h, int p, @NotNull DisconnectType t, @Nullable String m, @Nullable Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(Level.INFO, h, p, null, t, m, e);
        }
    }

    public static void debugDisconnect(@NotNull Level l, @NotNull String h, int p, @NotNull DisconnectType t, @Nullable String m, @Nullable Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(l, h, p, null, t, m, e);
        }
    }

    public static void debugDisconnect(@NotNull String h, int p, @Nullable LDAPConnection c, @NotNull DisconnectType t, @Nullable String m, @Nullable Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(Level.INFO, h, p, c, t, m, e);
        }
    }

    public static void debugDisconnect(@NotNull Level l, @NotNull String h, int p, @Nullable LDAPConnection c, @NotNull DisconnectType t, @Nullable String m, @Nullable Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.CONNECT);
            if (c != null) {
                String connectionPoolName;
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectionName = c.getConnectionName();
                if (connectionName != null) {
                    buffer.appendString("connection-name", connectionName);
                }
                if ((connectionPoolName = c.getConnectionPoolName()) != null) {
                    buffer.appendString("connection-pool-name", connectionPoolName);
                }
                buffer.appendString("disconnected-from-address", h);
                buffer.appendNumber("disconnected-from-port", p);
                buffer.appendString("disconnect-type", t.name());
                if (m != null) {
                    buffer.appendString("disconnect-message", m);
                }
            }
            if (e != null) {
                Debug.addCaughtException(buffer, "disconnect-cause", e);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer, e);
        }
    }

    public static void debugLDAPRequest(@NotNull LDAPRequest r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, r, -1, null);
        }
    }

    public static void debugLDAPRequest(@NotNull Level l, @NotNull LDAPRequest r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(l, r, -1, null);
        }
    }

    public static void debugLDAPRequest(@NotNull LDAPRequest r, int i, @Nullable LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, r, i, c);
        }
    }

    public static void debugLDAPRequest(@NotNull Level l, @NotNull LDAPRequest r, int i, @Nullable LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(l, String.valueOf(r), i, c);
        }
    }

    public static void debugLDAPRequest(@NotNull Level l, @NotNull String s, int i, @Nullable LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.LDAP);
            if (c != null) {
                String connectedAddress;
                String connectionPoolName;
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectionName = c.getConnectionName();
                if (connectionName != null) {
                    buffer.appendString("connection-name", connectionName);
                }
                if ((connectionPoolName = c.getConnectionPoolName()) != null) {
                    buffer.appendString("connection-pool-name", connectionPoolName);
                }
                if ((connectedAddress = c.getConnectedAddress()) != null) {
                    buffer.appendString("connected-to-address", connectedAddress);
                    buffer.appendNumber("connected-to-port", c.getConnectedPort());
                }
                try {
                    int soTimeout = InternalSDKHelper.getSoTimeout(c);
                    buffer.appendNumber("socket-timeout-millis", soTimeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i >= 0) {
                buffer.appendNumber("message-id", i);
            }
            buffer.appendString("sending-ldap-request", s);
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugLDAPResult(@NotNull LDAPResponse r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(Level.INFO, r, null);
        }
    }

    public static void debugLDAPResult(@NotNull Level l, @NotNull LDAPResponse r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(l, r, null);
        }
    }

    public static void debugLDAPResult(@NotNull LDAPResponse r, @Nullable LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(Level.INFO, r, c);
        }
    }

    public static void debugLDAPResult(@NotNull Level l, @NotNull LDAPResponse r, @Nullable LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.LDAP);
            if (c != null) {
                String connectedAddress;
                String connectionPoolName;
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectionName = c.getConnectionName();
                if (connectionName != null) {
                    buffer.appendString("connection-name", connectionName);
                }
                if ((connectionPoolName = c.getConnectionPoolName()) != null) {
                    buffer.appendString("connection-pool-name", connectionPoolName);
                }
                if ((connectedAddress = c.getConnectedAddress()) != null) {
                    buffer.appendString("connected-to-address", connectedAddress);
                    buffer.appendNumber("connected-to-port", c.getConnectedPort());
                }
            }
            buffer.appendString("read-ldap-result", r.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugASN1Write(@NotNull ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Write(Level.INFO, e);
        }
    }

    public static void debugASN1Write(@NotNull Level l, @NotNull ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.ASN1);
            buffer.appendString("writing-asn1-element", e.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugASN1Write(@NotNull ASN1Buffer b) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Write(Level.INFO, b);
        }
    }

    public static void debugASN1Write(@NotNull Level l, @NotNull ASN1Buffer b) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.ASN1);
            buffer.appendString("writing-asn1-element", StaticUtils.toHex(b.toByteArray()));
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugASN1Read(@NotNull ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Read(Level.INFO, e);
        }
    }

    public static void debugASN1Read(@NotNull Level l, @NotNull ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.ASN1);
            buffer.appendString("read-asn1-element", e.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugASN1Read(@NotNull Level l, @NotNull String dataType, int berType, int length, @Nullable Object value) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.ASN1);
            buffer.beginObject("read-asn1-element");
            buffer.appendString("data-type", dataType);
            buffer.appendString("ber-type", StaticUtils.toHex((byte)(berType & 0xFF)));
            buffer.appendNumber("value-length", length);
            if (value != null) {
                if (value instanceof byte[]) {
                    buffer.appendString("value-bytes", StaticUtils.toHex((byte[])value));
                } else {
                    buffer.appendString("value-string", value.toString());
                }
            }
            buffer.endObject();
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugConnectionPool(@NotNull Level l, @NotNull AbstractConnectionPool p, @Nullable LDAPConnection c, @Nullable String m, @Nullable Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECTION_POOL)) {
            long maxAvailable;
            long currentAvailable;
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.CONNECTION_POOL);
            String poolName = p.getConnectionPoolName();
            if (poolName == null) {
                buffer.appendNull("connection-pool-name");
            } else {
                buffer.appendString("connection-pool-name", poolName);
            }
            if (c != null) {
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectedAddress = c.getConnectedAddress();
                if (connectedAddress != null) {
                    buffer.appendString("connected-to-address", connectedAddress);
                    buffer.appendNumber("connected-to-port", c.getConnectedPort());
                }
            }
            if ((currentAvailable = (long)p.getCurrentAvailableConnections()) >= 0L) {
                buffer.appendNumber("current-available-connections", currentAvailable);
            }
            if ((maxAvailable = (long)p.getMaximumAvailableConnections()) >= 0L) {
                buffer.appendNumber("maximum-available-connections", maxAvailable);
            }
            if (m != null) {
                buffer.appendString("message", m);
            }
            if (e != null) {
                Debug.addCaughtException(buffer, "caught-exception", e);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer, e);
        }
    }

    public static void debugLDIFWrite(@NotNull LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            Debug.debugLDIFWrite(Level.INFO, r);
        }
    }

    public static void debugLDIFWrite(@NotNull Level l, @NotNull LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.LDIF);
            buffer.appendString("writing-ldif-record", r.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugLDIFRead(@NotNull LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            Debug.debugLDIFRead(Level.INFO, r);
        }
    }

    public static void debugLDIFRead(@NotNull Level l, @NotNull LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.LDIF);
            buffer.appendString("read-ldif-record", r.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugMonitor(@Nullable Entry e, @Nullable String m) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.MONITOR)) {
            Debug.debugMonitor(Level.FINE, e, m);
        }
    }

    public static void debugMonitor(@NotNull Level l, @Nullable Entry e, @Nullable String m) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.MONITOR)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.MONITOR);
            if (e != null) {
                buffer.appendString("monitor-entry-dn", e.getDN());
            }
            if (m != null) {
                buffer.appendString("message", m);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugCodingError(@NotNull Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CODING_ERROR)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, Level.SEVERE, DebugType.CODING_ERROR);
            Debug.addCaughtException(buffer, "coding-error", t);
            Debug.addCommonFooter(buffer);
            Debug.log(Level.SEVERE, buffer, t);
        }
    }

    public static void debug(@NotNull Level l, @NotNull DebugType t, @Nullable String m) {
        if (debugEnabled && debugTypes.contains((Object)t)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, t);
            if (m != null) {
                buffer.appendString("message", m);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debug(@NotNull Level l, @NotNull DebugType t, @Nullable String m, @Nullable Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)t)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, t);
            if (m != null) {
                buffer.appendString("message", m);
            }
            if (e != null) {
                Debug.addCaughtException(buffer, "caught-exception", e);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer, e);
        }
    }

    private static void addCommonHeader(@NotNull JSONBuffer buffer, @NotNull Level level, @NotNull DebugType type) {
        buffer.beginObject();
        buffer.appendString("timestamp", Debug.getTimestamp());
        buffer.appendString("debug-type", type.getName());
        buffer.appendString("level", level.getName());
        Thread t = Thread.currentThread();
        buffer.appendNumber("thread-id", t.getId());
        buffer.appendString("thread-name", t.getName());
    }

    @NotNull
    private static String getTimestamp() {
        SimpleDateFormat timestampFormatter = TIMESTAMP_FORMATTERS.get();
        if (timestampFormatter == null) {
            timestampFormatter = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss.SSS'Z'");
            timestampFormatter.setTimeZone(StaticUtils.getUTCTimeZone());
            TIMESTAMP_FORMATTERS.set(timestampFormatter);
        }
        return timestampFormatter.format(new Date());
    }

    @NotNull
    private static String formatStackTraceFrame(@NotNull StackTraceElement e) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(e.getMethodName());
        buffer.append('(');
        buffer.append(e.getFileName());
        int lineNumber = e.getLineNumber();
        if (lineNumber > 0) {
            buffer.append(':');
            buffer.append(lineNumber);
        } else if (e.isNativeMethod()) {
            buffer.append(":native");
        }
        buffer.append(')');
        return buffer.toString();
    }

    private static void addCaughtException(@NotNull JSONBuffer buffer, @NotNull String fieldName, @Nullable Throwable t) {
        if (t == null) {
            return;
        }
        buffer.beginObject(fieldName);
        String message = t.getMessage();
        if (message != null) {
            buffer.appendString("message", message);
        }
        buffer.beginArray("stack-trace");
        for (StackTraceElement e : t.getStackTrace()) {
            buffer.appendString(Debug.formatStackTraceFrame(e));
        }
        buffer.endArray();
        Throwable cause = t.getCause();
        if (cause != null) {
            Debug.addCaughtException(buffer, "cause", cause);
        }
        buffer.endObject();
    }

    private static void addCommonFooter(@NotNull JSONBuffer buffer) {
        if (includeStackTrace) {
            buffer.beginArray("caller-stack-trace");
            boolean foundDebug = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                String className = e.getClassName();
                if (className.equals(Debug.class.getName())) {
                    foundDebug = true;
                    continue;
                }
                if (!foundDebug) continue;
                buffer.appendString(Debug.formatStackTraceFrame(e));
            }
            buffer.endArray();
        }
        buffer.appendString("ldap-sdk-version", "7.0.0");
        buffer.appendString("ldap-sdk-revision", "323ff4fd3d622b96522298f300abc6915d0c209b");
        buffer.endObject();
    }

    private static void log(@NotNull Level level, @NotNull JSONBuffer buffer) {
        logger.log(level, buffer.toString());
    }

    private static void log(@NotNull Level level, @NotNull JSONBuffer buffer, @Nullable Throwable thrown) {
        logger.log(level, buffer.toString(), thrown);
    }

    public static void debugToFile(@NotNull String path, @NotNull String message) {
        Debug.debugToFile(new File(path), true, true, message);
    }

    public static void debugToFile(@NotNull File file, @NotNull String message) {
        Debug.debugToFile(file, true, true, message);
    }

    public static synchronized void debugToFile(@NotNull File file, boolean includeTimestamp, boolean includeStackTrace, @NotNull String message) {
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StaticUtils.setOf(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.SYNC), new FileAttribute[0]);
             FileLock fileLock = fileChannel.lock();){
            Validator.ensureTrue(fileLock.isValid());
            ByteStringBuffer messageBuffer = new ByteStringBuffer();
            if (fileChannel.size() > 0L) {
                messageBuffer.append(StaticUtils.EOL_BYTES);
            }
            if (includeTimestamp) {
                messageBuffer.append(StaticUtils.encodeRFC3339Time(System.currentTimeMillis()));
                messageBuffer.append(StaticUtils.EOL_BYTES);
            }
            messageBuffer.append(message);
            messageBuffer.append(StaticUtils.EOL_BYTES);
            if (includeStackTrace) {
                messageBuffer.append(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace()));
                messageBuffer.append(StaticUtils.EOL_BYTES);
            }
            fileChannel.write(ByteBuffer.wrap(messageBuffer.getBackingArray(), 0, messageBuffer.length()));
        }
        catch (Exception e) {
            Debug.debugException(e);
            System.err.println(UtilityMessages.ERR_DEBUG_CANNOT_WRITE_TO_FILE.get(file.getAbsolutePath(), StaticUtils.getExceptionMessage(e), message));
        }
    }

    static {
        debugTypes = EnumSet.allOf(DebugType.class);
        Debug.initialize(StaticUtils.getSystemProperties(PROPERTY_DEBUG_ENABLED, PROPERTY_DEBUG_LEVEL, PROPERTY_DEBUG_TYPE, PROPERTY_INCLUDE_STACK_TRACE));
        String logFilePropertyValue = StaticUtils.getSystemProperty(PROPERTY_DEBUG_FILE);
        if (logFilePropertyValue != null) {
            try {
                logger.setUseParentHandlers(false);
                FileHandler fileHandler = new FileHandler(logFilePropertyValue, true);
                fileHandler.setFormatter(new MinimalLogFormatter(null, false, false, true));
                logger.addHandler(fileHandler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

