/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.bcfips;

import com.pingidentity.pingcommons.bcfips.ImportExportException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS8EncryptedPrivateKeyInfoBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PemExportUtil {
    private static final Logger logger = LoggerFactory.getLogger(PemExportUtil.class);
    private static final Provider bouncyCastleFipsProvider = new BouncyCastleFipsProvider();

    private PemExportUtil() {
    }

    public static byte[] getExportablePEM(String password, PrivateKey privateKey, List<X509Certificate> certificates) throws ImportExportException {
        String privateKeyString;
        ByteArrayOutputStream keyPairStream = new ByteArrayOutputStream();
        try {
            privateKeyString = PemExportUtil.writeEncryptedKey(password.toCharArray(), privateKey);
        }
        catch (IOException | OperatorCreationException e) {
            throw new ImportExportException("Unable to write encrypted private key.", e);
        }
        catch (FipsUnapprovedOperationError e) {
            throw new ImportExportException("Error occurred exporting PEM-encoded key: " + e.getMessage(), e);
        }
        byte[] privateKeyBytes = privateKeyString.getBytes(StandardCharsets.UTF_8);
        try {
            keyPairStream.write(privateKeyBytes);
        }
        catch (IOException e) {
            throw new ImportExportException("Failure while processing private key.", e);
        }
        for (X509Certificate x509Certificate : certificates) {
            try {
                keyPairStream.write(PemExportUtil.writeCertificate(x509Certificate).getBytes(StandardCharsets.UTF_8));
            }
            catch (NullPointerException e) {
                throw new ImportExportException("The list of certificates is empty/null.", e);
            }
            catch (IOException e) {
                throw new ImportExportException("Failure while processing the certificate list.", e);
            }
        }
        return keyPairStream.toByteArray();
    }

    private static String writeEncryptedKey(char[] passwd, PrivateKey privateKey) throws IOException, OperatorCreationException, NullPointerException {
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        JcaPKCS8EncryptedPrivateKeyInfoBuilder pkcs8Builder = new JcaPKCS8EncryptedPrivateKeyInfoBuilder(privateKey);
        pemWriter.writeObject((Object)pkcs8Builder.build(new JcePKCSPBEOutputEncryptorBuilder(NISTObjectIdentifiers.id_aes128_CBC).setProvider(bouncyCastleFipsProvider).build(passwd)));
        pemWriter.close();
        return stringWriter.toString();
    }

    private static String writeCertificate(X509Certificate certificate) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        pemWriter.writeObject((Object)certificate);
        pemWriter.close();
        return stringWriter.toString();
    }
}

