/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api;

import com.pingidentity.admin.api.ApiConfig;
import com.pingidentity.admin.api.model.ConnectionType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ApiUtil {
    public static final String ID_SPLIT_DELIMITER = "|";
    private static final Pattern API_DOCS_PATTERN = Pattern.compile(Pattern.quote("/swagger.json") + "(/.*)?");
    private static volatile ApiConfig apiConfig;

    public static void setApiConfig(ApiConfig config) {
        apiConfig = config;
    }

    public static ApiConfig getApiConfig() {
        return apiConfig;
    }

    public static String getApiUrl() {
        return apiConfig.getApiUrl();
    }

    public static String getResourceUrl(String ... pathElements) {
        StringBuilder url = new StringBuilder();
        url.append(ApiUtil.getApiUrl());
        for (String pathElement : pathElements) {
            if (pathElement == null || pathElement.length() == 0) continue;
            if (pathElement.charAt(0) == '/') {
                url.append(pathElement);
                continue;
            }
            url.append("/").append(pathElement);
        }
        return url.toString();
    }

    public static Response makeFileDownloadResponse(String filename, String contentType, final byte[] outputBytes) {
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                output.write(outputBytes);
            }
        };
        return Response.ok((Object)streamingOutput).header("Content-disposition", (Object)("attachment; filename=" + filename)).header("Content-Length", (Object)outputBytes.length).type(contentType).build();
    }

    public static String[] splitId(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return new String[0];
        }
        return id.split("\\|");
    }

    public static String combineId(String sourceId, String targetId) {
        return sourceId + ID_SPLIT_DELIMITER + targetId;
    }

    public static boolean validId(String id) {
        String[] sourceTargetId = ApiUtil.splitId(id);
        return sourceTargetId.length == 2 && sourceTargetId[0].length() > 0 && sourceTargetId[1].length() > 0;
    }

    public static boolean isApiDocsRequest(HttpServletRequest servletRequest) {
        String pathInfo = StringUtils.defaultString((String)servletRequest.getPathInfo());
        return ApiUtil.isApiDocsPath(pathInfo);
    }

    public static boolean isApiDocsPath(String relativePath) {
        Matcher matcher = API_DOCS_PATTERN.matcher(relativePath);
        return matcher.matches();
    }

    public static ConnectionBase getConnection(String systemId, ConnectionType connectionType) {
        SpConnection connectionBase = null;
        switch (connectionType) {
            case SP: {
                connectionBase = MgmtFactory.getConnectionManager().getSpConnectionBySystemId(systemId);
                break;
            }
            case IDP: {
                connectionBase = MgmtFactory.getConnectionManager().getIdpConnectionBySystemId(systemId);
            }
        }
        return connectionBase;
    }
}

