/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ApiResultFactory;
import com.pingidentity.pf.common.api.CommonApiMsgKey;
import com.pingidentity.pf.common.api.model.ApiResult;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.List;
import javax.ws.rs.core.Response;

public final class Responses {
    public static Response resourceNotFound(String id) {
        ApiResult result = ApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.resource_with_id_not_found, (Object[])new Object[]{id});
        return Response.status((int)404).entity((Object)result).build();
    }

    public static Response resourceInUse(String id) {
        ApiResult result = ApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.resource_in_use, (Object[])new Object[]{id});
        return Response.status((int)422).entity((Object)result).build();
    }

    public static Response resourceInUseByPF(String id) {
        ApiResult result = ApiResultFactory.create(ApiMessageKey.resource_in_use_by_pf, id);
        return Response.status((int)422).entity((Object)result).build();
    }

    public static Response validationError(List<ValidationError> errors) {
        ApiResult result = ApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.validation_error);
        result.appendErrors(errors);
        return Response.status((int)422).entity((Object)result).build();
    }

    public static Response success(Object object) {
        return Response.ok().entity(object).build();
    }

    public static Response created(Object object, String location) {
        return Response.status((int)201).header("Location", (Object)location).entity(object).build();
    }

    public static Response modelParamNull(Class<?> objectClass) {
        ApiResult result = ApiResultFactory.create(ApiMessageKey.model_parameter_null, objectClass.getSimpleName());
        return Response.status((int)422).entity((Object)result).build();
    }

    public static Response errorGettingAccessToken() {
        ApiResult result = ApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.token_invalid);
        return Response.status((int)403).entity((Object)result).build();
    }

    public static Response validatePaginationParameters(Integer page, Integer numberPerPage) {
        if (page != null && numberPerPage == null || page == null && numberPerPage != null) {
            ApiResult result = ApiResultFactory.create(ApiMessageKey.paged_results_parameter_missing);
            return Response.status((int)422).entity((Object)result).build();
        }
        if (page != null && page <= 0) {
            ApiResult result = ApiResultFactory.create(ApiMessageKey.page_param_invalid);
            return Response.status((int)422).entity((Object)result).build();
        }
        if (numberPerPage != null && numberPerPage <= 0) {
            ApiResult result = ApiResultFactory.create(ApiMessageKey.numberperpage_param_invalid);
            return Response.status((int)422).entity((Object)result).build();
        }
        return null;
    }

    public static Response resourceDeleted() {
        return Response.status((int)204).build();
    }
}

