/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.bulkconfig;

import com.pingidentity.admin.api.bulkconfig.BulkConfigProviderFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkConfigManager {
    private static BulkConfigManager instance = new BulkConfigManager();
    private List<BulkConfigProviderFactory<?>> providerFactories = new ArrayList();

    public static BulkConfigManager getInstance() {
        return instance;
    }

    public synchronized void clearProviderFactories() {
        this.providerFactories.clear();
    }

    public synchronized void addProviderFactory(BulkConfigProviderFactory<?> factory) {
        this.providerFactories.add(factory);
    }

    public synchronized BulkConfigProviderFactory<?> getProviderFactoryForPath(String path) {
        for (BulkConfigProviderFactory<?> providerFactory : this.providerFactories) {
            if (!providerFactory.getResourcePath().equals(path)) continue;
            return providerFactory;
        }
        return null;
    }

    public synchronized List<BulkConfigProviderFactory<?>> getProviderFactories() {
        return Collections.unmodifiableList(this.providerFactories);
    }
}

