/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.bulkconfig;

public class ConfigStrategy {
    public static final ConfigStrategy Single = new ConfigStrategy(false);
    public static final ConfigStrategy Collection = new ConfigStrategy(true);
    public static final ConfigStrategy BatchUpdateCollection = new ConfigStrategy(true, true, false, false);
    public static final ConfigStrategy ConfigStoreCollection = new ConfigStrategy(true, false, true, true);
    private boolean isCollection;
    private boolean hasSubResources;
    private boolean deleteSupported;
    private boolean supportsBatchUpdate;

    public ConfigStrategy(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public ConfigStrategy(boolean isCollection, boolean supportsBatchUpdate, boolean hasSubResources, boolean deleteSupported) {
        this.isCollection = isCollection;
        this.supportsBatchUpdate = supportsBatchUpdate;
        if (supportsBatchUpdate && !isCollection) {
            throw new IllegalArgumentException("If supportsBatchUpdate is true, isCollection must also be true");
        }
        this.hasSubResources = hasSubResources;
        this.deleteSupported = deleteSupported;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean supportsBatchUpdate() {
        return this.supportsBatchUpdate;
    }

    public boolean hasSubResources() {
        return this.hasSubResources;
    }

    public boolean isDeleteSupported() {
        return this.deleteSupported;
    }
}

