/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.helpers;

import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.PkCert;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class PkCertManagerOpHelper {
    private final PkCertManager pkCertManager;

    public PkCertManagerOpHelper(PkCertManager pkCertManager) {
        this.pkCertManager = pkCertManager;
    }

    private String getAuditMessage(CertificateGenerator.CertificateType certificateType, PkCert cert) {
        StringBuilder sb = new StringBuilder();
        switch (certificateType) {
            case sslCertAuth: {
                sb.append("SSL Certificate - ");
                break;
            }
            case sslServerCerts: {
                sb.append("SSL Server Certificate - ");
                break;
            }
            case dsigSigningCert: {
                sb.append("Dsign Certificate - ");
                break;
            }
            default: {
                sb.append("Certificate - ");
            }
        }
        if (cert != null) {
            sb.append(cert.getX509Certificate().getSubjectDN().getName());
        }
        return sb.toString();
    }

    public void savePkCert(CertificateGenerator.CertificateType certType, PkCert newCert, AdminAuditLogger.Event event) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.pkCertManager.savePkCert(newCert);
            auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, event, this.getAuditMessage(certType, newCert));
        }
    }

    public boolean deletePkCert(CertificateGenerator.CertificateType certType, String id) {
        PkCert existing = this.pkCertManager.getPkCert(id);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            boolean result = this.pkCertManager.deletePkCertById(id);
            auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.DELETE, this.getAuditMessage(certType, existing));
            boolean bl = result;
            return bl;
        }
    }
}

