/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.helpers;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.event.ConfigurationListener;
import org.sourceid.saml20.adapter.gui.event.EventException;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class PluginHelper {
    private final PluginManager<?, ?> pluginManager;

    public PluginHelper(PluginManager<?, ?> pluginManager) {
        this.pluginManager = pluginManager;
    }

    public List<ValidationError> saveInstanceWithConfigurationListener(ConfigurablePluginInstance domainInstance) {
        List listeners = domainInstance.getDescriptor().getGuiConfigDescriptorBuilder().buildNewGuiDescriptor().getListenerChain();
        if (listeners != null && !listeners.isEmpty()) {
            Configuration config = domainInstance.getRuntimeCompositeConfiguration();
            try {
                for (ConfigurationListener listener : listeners) {
                    listener.onSave(config);
                }
            }
            catch (EventException e) {
                LinkedList<ValidationError> listenerErrors = new LinkedList<ValidationError>();
                if (e.getErrorMessages().isEmpty()) {
                    ValidationError subError = new ValidationError(ApiMessageKey.plugin_config_listener_save_error.getMsgKey(), "There was an unexpected error trying to save the plugin instance.", null);
                    listenerErrors.add(subError);
                }
                for (String message : e.getErrorMessages()) {
                    listenerErrors.add(new ValidationError(ApiMessageKey.plugin_config_listener_save_error.getMsgKey(), message, null));
                }
                return listenerErrors;
            }
        }
        this.pluginManager.saveInstance(domainInstance);
        return Collections.emptyList();
    }
}

